/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.client.codec;

import feign.Response;
import feign.codec.Decoder;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.client.codec.DefaultRestErrorResponse;
import org.wso2.msf4j.client.codec.MSF4JJacksonDecoder;
import org.wso2.msf4j.client.exception.RestServiceException;

public class DefaultErrorDecoder
implements ErrorDecoder {
    private static final Logger log = LoggerFactory.getLogger(DefaultErrorDecoder.class);
    private final Map<String, Class<? extends RestServiceException>> errorResponseMappers;
    private Decoder decoder = new MSF4JJacksonDecoder();
    private ErrorDecoder fallbackErrorDecoder = new ErrorDecoder.Default();

    public DefaultErrorDecoder(Map<String, Class<? extends RestServiceException>> errorResponseMappers) {
        this.errorResponseMappers = errorResponseMappers;
    }

    public Exception decode(String methodKey, Response response) {
        try {
            DefaultRestErrorResponse apiErrorResponse = (DefaultRestErrorResponse)this.decoder.decode(response, DefaultRestErrorResponse.class);
            if (apiErrorResponse != null && this.errorResponseMappers.containsKey(apiErrorResponse.getErrorCode())) {
                return this.getExceptionSupplierFromExceptionClass(this.errorResponseMappers.get(apiErrorResponse.getErrorCode()), apiErrorResponse.getMessage());
            }
        }
        catch (IOException e) {
            log.error("Error decoding error response", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Error instantiating the exception mapped for the REST service error response '{}'", (Object)response, (Object)e);
        }
        return this.fallbackErrorDecoder.decode(methodKey, response);
    }

    private RestServiceException getExceptionSupplierFromExceptionClass(Class<? extends RestServiceException> clazz, String message) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        List<String> supportedArguments = Collections.singletonList(message);
        for (Constructor<?> constructor : clazz.getConstructors()) {
            Class<?>[] parameters = constructor.getParameterTypes();
            ArrayList arguments = new ArrayList();
            for (Class<?> parameter : parameters) {
                supportedArguments.stream().filter(argumentInstance -> parameter.isAssignableFrom(argumentInstance.getClass())).findFirst().ifPresent(arguments::add);
            }
            if (arguments.size() != parameters.length) continue;
            return (RestServiceException)constructor.newInstance(arguments.toArray(new Object[0]));
        }
        log.warn("Could not instantiate the exception '{}'", (Object)clazz.getName());
        return null;
    }
}

