/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.wso2.msf4j.Session;
import org.wso2.msf4j.SessionManager;
import org.wso2.msf4j.internal.session.SessionIdGenerator;

public abstract class AbstractSessionManager
implements SessionManager {
    private boolean isStopped;
    private static final int DEFAULT_MAX_INACTIVE_INTERVAL = 15;
    private static final int DEFAULT_MAX_ACTIVE_SESSIONS = 100000;
    private static final int SESSION_ID_LENGTH = 16;
    private Map<String, Session> sessions = new ConcurrentHashMap<String, Session>();
    private SessionIdGenerator sessionIdGenerator = new SessionIdGenerator();
    private ScheduledExecutorService sessionExpiryChecker;

    @Override
    public final void init() {
        this.sessionIdGenerator.setSessionIdLength(16);
        this.loadSessions(this.sessions);
        this.sessionExpiryChecker = Executors.newScheduledThreadPool(1);
        this.sessionExpiryChecker.scheduleAtFixedRate(() -> this.sessions.values().parallelStream().filter(session -> System.currentTimeMillis() - session.getLastAccessedTime() >= (long)session.getMaxInactiveInterval() * 60L * 1000L).forEach(Session::invalidate), 30L, 30L, TimeUnit.SECONDS);
    }

    @Override
    public final Session getSession(String sessionId) {
        this.checkValidity();
        Session session = this.sessions.get(sessionId);
        if (session == null) {
            session = this.readSession(sessionId);
        }
        if (session != null) {
            this.sessions.put(session.getId(), session);
            session.setNew(false);
        }
        return session;
    }

    @Override
    public final Session createSession() {
        this.checkValidity();
        if (this.sessions.size() >= 100000) {
            throw new IllegalStateException("Too many active sessions");
        }
        Session session = new Session(this.sessionIdGenerator.generateSessionId(""), 15);
        session.setManager(this);
        this.sessions.put(session.getId(), session);
        this.saveSession(session);
        return session;
    }

    @Override
    public final void invalidateSession(Session session) {
        this.checkValidity();
        this.sessions.remove(session.getId());
        this.deleteSession(session);
    }

    @Override
    public final int getDefaultMaxInactiveInterval() {
        return 15;
    }

    @Override
    public final int getDefaultMaxActiveSessions() {
        return 100000;
    }

    @Override
    public final int getSessionIdLength() {
        return 16;
    }

    @Override
    public final void stop() {
        this.sessionExpiryChecker.shutdown();
        this.isStopped = true;
    }

    protected final void checkValidity() {
        if (this.isStopped) {
            throw new IllegalStateException("This SessionManager has been stopped");
        }
    }
}

