/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender.states;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.common.states.SenderReqRespStateManager;
import org.wso2.transport.http.netty.contractimpl.common.states.StateUtil;
import org.wso2.transport.http.netty.contractimpl.sender.TargetHandler;
import org.wso2.transport.http.netty.contractimpl.sender.states.EntityBodyReceived;
import org.wso2.transport.http.netty.contractimpl.sender.states.SenderState;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class ReceivingEntityBody
implements SenderState {
    private static final Logger LOG = LoggerFactory.getLogger(ReceivingEntityBody.class);
    private final SenderReqRespStateManager senderReqRespStateManager;
    private final TargetHandler targetHandler;

    ReceivingEntityBody(SenderReqRespStateManager senderReqRespStateManager, TargetHandler targetHandler) {
        this.senderReqRespStateManager = senderReqRespStateManager;
        this.targetHandler = targetHandler;
    }

    @Override
    public void writeOutboundRequestHeaders(HttpCarbonMessage httpOutboundRequest) {
        LOG.warn("writeOutboundRequestHeaders {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void writeOutboundRequestEntity(HttpCarbonMessage httpOutboundRequest, HttpContent httpContent) {
        LOG.warn("writeOutboundRequestEntity {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void readInboundResponseHeaders(TargetHandler targetHandler, HttpResponse httpInboundResponse) {
        LOG.warn("readInboundResponseHeaders {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void readInboundResponseEntityBody(ChannelHandlerContext ctx, HttpContent httpContent, HttpCarbonMessage inboundResponseMsg) throws Exception {
        if (httpContent instanceof LastHttpContent) {
            StateUtil.setInboundTrailersToNewMessage(((LastHttpContent)httpContent).trailingHeaders(), inboundResponseMsg);
            inboundResponseMsg.addHttpContent(httpContent);
            inboundResponseMsg.setLastHttpContentArrived();
            this.targetHandler.resetInboundMsg();
            Util.safelyRemoveHandlers(this.targetHandler.getTargetChannel().getChannel().pipeline(), "idleStateHandler");
            this.senderReqRespStateManager.state = new EntityBodyReceived(this.senderReqRespStateManager);
            if (!Util.isKeepAlive(this.targetHandler.getKeepAliveConfig(), this.targetHandler.getOutboundRequestMsg())) {
                this.targetHandler.closeChannel(ctx);
            }
            this.targetHandler.getConnectionManager().returnChannel(this.targetHandler.getTargetChannel());
        } else {
            inboundResponseMsg.addHttpContent(httpContent);
        }
    }

    @Override
    public void handleAbruptChannelClosure(TargetHandler targetHandler, HttpResponseFuture httpResponseFuture) {
        StateUtil.handleIncompleteInboundMessage(targetHandler.getInboundResponseMsg(), "Remote host closed the connection while reading inbound response body");
    }

    @Override
    public void handleIdleTimeoutConnectionClosure(TargetHandler targetHandler, HttpResponseFuture httpResponseFuture, String channelID) {
        this.senderReqRespStateManager.nettyTargetChannel.pipeline().remove("idleStateHandler");
        this.senderReqRespStateManager.nettyTargetChannel.close();
        StateUtil.handleIncompleteInboundMessage(targetHandler.getInboundResponseMsg(), "Idle timeout triggered while reading inbound response entity body");
    }
}

