/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyOperation;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.JSONObjectUtils;
import com.nimbusds.jose.util.X509CertChainUtils;
import java.math.BigInteger;
import java.net.URL;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAMultiPrimePrivateCrtKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAMultiPrimePrivateCrtKeySpec;
import java.security.spec.RSAOtherPrimeInfo;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class RSAKey
extends JWK {
    private final Base64URL n;
    private final Base64URL e;
    private final Base64URL d;
    private final Base64URL p;
    private final Base64URL q;
    private final Base64URL dp;
    private final Base64URL dq;
    private final Base64URL qi;
    private final List<OtherPrimesInfo> oth;

    public RSAKey(Base64URL n, Base64URL e, KeyUse use, Set<KeyOperation> ops, Algorithm alg, String kid, URL x5u, Base64URL x5t, List<Base64> x5c) {
        this(n, e, null, null, null, null, null, null, null, use, ops, alg, kid, x5u, x5t, x5c);
    }

    public RSAKey(Base64URL n, Base64URL e, Base64URL d, KeyUse use, Set<KeyOperation> ops, Algorithm alg, String kid, URL x5u, Base64URL x5t, List<Base64> x5c) {
        this(n, e, d, null, null, null, null, null, null, use, ops, alg, kid, x5u, x5t, x5c);
        if (d == null) {
            throw new IllegalArgumentException("The private exponent must not be null");
        }
    }

    public RSAKey(Base64URL n, Base64URL e, Base64URL p, Base64URL q, Base64URL dp, Base64URL dq, Base64URL qi, List<OtherPrimesInfo> oth, KeyUse use, Set<KeyOperation> ops, Algorithm alg, String kid, URL x5u, Base64URL x5t, List<Base64> x5c) {
        this(n, e, null, p, q, dp, dq, qi, oth, use, ops, alg, kid, x5u, x5t, x5c);
        if (p == null) {
            throw new IllegalArgumentException("The first prime factor must not be null");
        }
        if (q == null) {
            throw new IllegalArgumentException("The second prime factor must not be null");
        }
        if (dp == null) {
            throw new IllegalArgumentException("The first factor CRT exponent must not be null");
        }
        if (dq == null) {
            throw new IllegalArgumentException("The second factor CRT exponent must not be null");
        }
        if (qi == null) {
            throw new IllegalArgumentException("The first CRT coefficient must not be null");
        }
    }

    public RSAKey(Base64URL n, Base64URL e, Base64URL d, Base64URL p, Base64URL q, Base64URL dp, Base64URL dq, Base64URL qi, List<OtherPrimesInfo> oth, KeyUse use, Set<KeyOperation> ops, Algorithm alg, String kid, URL x5u, Base64URL x5t, List<Base64> x5c) {
        super(KeyType.RSA, use, ops, alg, kid, x5u, x5t, x5c);
        if (n == null) {
            throw new IllegalArgumentException("The modulus value must not be null");
        }
        this.n = n;
        if (e == null) {
            throw new IllegalArgumentException("The public exponent value must not be null");
        }
        this.e = e;
        this.d = d;
        if (p != null && q != null && dp != null && dq != null && qi != null) {
            this.p = p;
            this.q = q;
            this.dp = dp;
            this.dq = dq;
            this.qi = qi;
            this.oth = oth != null ? Collections.unmodifiableList(oth) : Collections.emptyList();
        } else if (p == null && q == null && dp == null && dq == null && qi == null && oth == null) {
            this.p = null;
            this.q = null;
            this.dp = null;
            this.dq = null;
            this.qi = null;
            this.oth = Collections.emptyList();
        } else {
            if (p == null) {
                throw new IllegalArgumentException("Incomplete second private (CRT) representation: The first prime factor must not be null");
            }
            if (q == null) {
                throw new IllegalArgumentException("Incomplete second private (CRT) representation: The second prime factor must not be null");
            }
            if (dp == null) {
                throw new IllegalArgumentException("Incomplete second private (CRT) representation: The first factor CRT exponent must not be null");
            }
            if (dq == null) {
                throw new IllegalArgumentException("Incomplete second private (CRT) representation: The second factor CRT exponent must not be null");
            }
            throw new IllegalArgumentException("Incomplete second private (CRT) representation: The first CRT coefficient must not be null");
        }
    }

    public RSAKey(RSAPublicKey pub, KeyUse use, Set<KeyOperation> ops, Algorithm alg, String kid, URL x5u, Base64URL x5t, List<Base64> x5c) {
        this(Base64URL.encode(pub.getModulus()), Base64URL.encode(pub.getPublicExponent()), use, ops, alg, kid, x5u, x5t, x5c);
    }

    public RSAKey(RSAPublicKey pub, RSAPrivateKey priv, KeyUse use, Set<KeyOperation> ops, Algorithm alg, String kid, URL x5u, Base64URL x5t, List<Base64> x5c) {
        this(Base64URL.encode(pub.getModulus()), Base64URL.encode(pub.getPublicExponent()), Base64URL.encode(priv.getPrivateExponent()), use, ops, alg, kid, x5u, x5t, x5c);
    }

    public RSAKey(RSAPublicKey pub, RSAPrivateCrtKey priv, KeyUse use, Set<KeyOperation> ops, Algorithm alg, String kid, URL x5u, Base64URL x5t, List<Base64> x5c) {
        this(Base64URL.encode(pub.getModulus()), Base64URL.encode(pub.getPublicExponent()), Base64URL.encode(priv.getPrivateExponent()), Base64URL.encode(priv.getPrimeP()), Base64URL.encode(priv.getPrimeQ()), Base64URL.encode(priv.getPrimeExponentP()), Base64URL.encode(priv.getPrimeExponentQ()), Base64URL.encode(priv.getCrtCoefficient()), null, use, ops, alg, kid, x5u, x5t, x5c);
    }

    public RSAKey(RSAPublicKey pub, RSAMultiPrimePrivateCrtKey priv, KeyUse use, Set<KeyOperation> ops, Algorithm alg, String kid, URL x5u, Base64URL x5t, List<Base64> x5c) {
        this(Base64URL.encode(pub.getModulus()), Base64URL.encode(pub.getPublicExponent()), Base64URL.encode(priv.getPrivateExponent()), Base64URL.encode(priv.getPrimeP()), Base64URL.encode(priv.getPrimeQ()), Base64URL.encode(priv.getPrimeExponentP()), Base64URL.encode(priv.getPrimeExponentQ()), Base64URL.encode(priv.getCrtCoefficient()), OtherPrimesInfo.toList(priv.getOtherPrimeInfo()), use, ops, alg, kid, x5u, x5t, x5c);
    }

    public Base64URL getModulus() {
        return this.n;
    }

    public Base64URL getPublicExponent() {
        return this.e;
    }

    public Base64URL getPrivateExponent() {
        return this.d;
    }

    public Base64URL getFirstPrimeFactor() {
        return this.p;
    }

    public Base64URL getSecondPrimeFactor() {
        return this.q;
    }

    public Base64URL getFirstFactorCRTExponent() {
        return this.dp;
    }

    public Base64URL getSecondFactorCRTExponent() {
        return this.dq;
    }

    public Base64URL getFirstCRTCoefficient() {
        return this.qi;
    }

    public List<OtherPrimesInfo> getOtherPrimes() {
        return this.oth;
    }

    public RSAPublicKey toRSAPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        BigInteger modulus = this.n.decodeToBigInteger();
        BigInteger exponent = this.e.decodeToBigInteger();
        RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, exponent);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return (RSAPublicKey)factory.generatePublic(spec);
    }

    public RSAPrivateKey toRSAPrivateKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        RSAPrivateKeySpec spec;
        if (this.d == null) {
            return null;
        }
        BigInteger modulus = this.n.decodeToBigInteger();
        BigInteger privateExponent = this.d.decodeToBigInteger();
        if (this.p == null) {
            spec = new RSAPrivateKeySpec(modulus, privateExponent);
        } else {
            BigInteger publicExponent = this.e.decodeToBigInteger();
            BigInteger primeP = this.p.decodeToBigInteger();
            BigInteger primeQ = this.q.decodeToBigInteger();
            BigInteger primeExponentP = this.dp.decodeToBigInteger();
            BigInteger primeExponentQ = this.dq.decodeToBigInteger();
            BigInteger crtCoefficient = this.qi.decodeToBigInteger();
            if (this.oth != null && !this.oth.isEmpty()) {
                RSAOtherPrimeInfo[] otherInfo = new RSAOtherPrimeInfo[this.oth.size()];
                for (int i = 0; i < this.oth.size(); ++i) {
                    OtherPrimesInfo opi = this.oth.get(i);
                    BigInteger otherPrime = opi.getPrimeFactor().decodeToBigInteger();
                    BigInteger otherPrimeExponent = opi.getFactorCRTExponent().decodeToBigInteger();
                    BigInteger otherCrtCoefficient = opi.getFactorCRTCoefficient().decodeToBigInteger();
                    otherInfo[i] = new RSAOtherPrimeInfo(otherPrime, otherPrimeExponent, otherCrtCoefficient);
                }
                spec = new RSAMultiPrimePrivateCrtKeySpec(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient, otherInfo);
            } else {
                spec = new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient);
            }
        }
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return (RSAPrivateKey)factory.generatePrivate(spec);
    }

    public KeyPair toKeyPair() throws NoSuchAlgorithmException, InvalidKeySpecException {
        return new KeyPair(this.toRSAPublicKey(), this.toRSAPrivateKey());
    }

    @Override
    public boolean isPrivate() {
        return this.d != null || this.p != null;
    }

    @Override
    public RSAKey toPublicJWK() {
        return new RSAKey(this.getModulus(), this.getPublicExponent(), this.getKeyUse(), this.getKeyOperations(), this.getAlgorithm(), this.getKeyID(), this.getX509CertURL(), this.getX509CertThumbprint(), this.getX509CertChain());
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject o = super.toJSONObject();
        o.put("n", this.n.toString());
        o.put("e", this.e.toString());
        if (this.d != null) {
            o.put("d", this.d.toString());
        }
        if (this.p != null) {
            o.put("p", this.p.toString());
        }
        if (this.q != null) {
            o.put("q", this.q.toString());
        }
        if (this.dp != null) {
            o.put("dp", this.dp.toString());
        }
        if (this.dq != null) {
            o.put("dq", this.dq.toString());
        }
        if (this.qi != null) {
            o.put("qi", this.qi.toString());
        }
        if (this.oth != null && !this.oth.isEmpty()) {
            JSONArray a = new JSONArray();
            for (OtherPrimesInfo other : this.oth) {
                JSONObject oo = new JSONObject();
                oo.put("r", other.r.toString());
                oo.put("d", other.d.toString());
                oo.put("t", other.t.toString());
                a.add(oo);
            }
            o.put("oth", a);
        }
        return o;
    }

    public static RSAKey parse(String s) throws ParseException {
        return RSAKey.parse(JSONObjectUtils.parseJSONObject(s));
    }

    public static RSAKey parse(JSONObject jsonObject) throws ParseException {
        Base64URL n = new Base64URL(JSONObjectUtils.getString(jsonObject, "n"));
        Base64URL e = new Base64URL(JSONObjectUtils.getString(jsonObject, "e"));
        KeyType kty = KeyType.parse(JSONObjectUtils.getString(jsonObject, "kty"));
        if (kty != KeyType.RSA) {
            throw new ParseException("The key type \"kty\" must be RSA", 0);
        }
        Base64URL d = null;
        if (jsonObject.containsKey("d")) {
            d = new Base64URL(JSONObjectUtils.getString(jsonObject, "d"));
        }
        Base64URL p = null;
        if (jsonObject.containsKey("p")) {
            p = new Base64URL(JSONObjectUtils.getString(jsonObject, "p"));
        }
        Base64URL q = null;
        if (jsonObject.containsKey("q")) {
            q = new Base64URL(JSONObjectUtils.getString(jsonObject, "q"));
        }
        Base64URL dp = null;
        if (jsonObject.containsKey("dp")) {
            dp = new Base64URL(JSONObjectUtils.getString(jsonObject, "dp"));
        }
        Base64URL dq = null;
        if (jsonObject.containsKey("dq")) {
            dq = new Base64URL(JSONObjectUtils.getString(jsonObject, "dq"));
        }
        Base64URL qi = null;
        if (jsonObject.containsKey("qi")) {
            qi = new Base64URL(JSONObjectUtils.getString(jsonObject, "qi"));
        }
        ArrayList<OtherPrimesInfo> oth = null;
        if (jsonObject.containsKey("oth")) {
            JSONArray arr = JSONObjectUtils.getJSONArray(jsonObject, "oth");
            oth = new ArrayList<OtherPrimesInfo>(arr.size());
            for (Object o : arr) {
                if (!(o instanceof JSONObject)) continue;
                JSONObject otherJson = (JSONObject)o;
                Base64URL r = new Base64URL(JSONObjectUtils.getString(otherJson, "r"));
                Base64URL odq = new Base64URL(JSONObjectUtils.getString(otherJson, "dq"));
                Base64URL t = new Base64URL(JSONObjectUtils.getString(otherJson, "t"));
                OtherPrimesInfo prime = new OtherPrimesInfo(r, odq, t);
                oth.add(prime);
            }
        }
        KeyUse use = null;
        if (jsonObject.containsKey("use")) {
            use = KeyUse.parse(JSONObjectUtils.getString(jsonObject, "use"));
        }
        Set<KeyOperation> ops = null;
        if (jsonObject.containsKey("key_ops")) {
            ops = KeyOperation.parse(JSONObjectUtils.getStringList(jsonObject, "key_ops"));
        }
        Algorithm alg = null;
        if (jsonObject.containsKey("alg")) {
            alg = new Algorithm(JSONObjectUtils.getString(jsonObject, "alg"));
        }
        String kid = null;
        if (jsonObject.containsKey("kid")) {
            kid = JSONObjectUtils.getString(jsonObject, "kid");
        }
        URL x5u = null;
        if (jsonObject.containsKey("x5u")) {
            x5u = JSONObjectUtils.getURL(jsonObject, "x5u");
        }
        Base64URL x5t = null;
        if (jsonObject.containsKey("x5t")) {
            x5t = new Base64URL(JSONObjectUtils.getString(jsonObject, "x5t"));
        }
        List<Base64> x5c = null;
        if (jsonObject.containsKey("x5c")) {
            x5c = X509CertChainUtils.parseX509CertChain(JSONObjectUtils.getJSONArray(jsonObject, "x5c"));
        }
        try {
            return new RSAKey(n, e, d, p, q, dp, dq, qi, oth, use, ops, alg, kid, x5u, x5t, x5c);
        }
        catch (IllegalArgumentException ex) {
            throw new ParseException(ex.getMessage(), 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private final Base64URL n;
        private final Base64URL e;
        private Base64URL d;
        private Base64URL p;
        private Base64URL q;
        private Base64URL dp;
        private Base64URL dq;
        private Base64URL qi;
        private List<OtherPrimesInfo> oth;
        private KeyUse use;
        private Set<KeyOperation> ops;
        private Algorithm alg;
        private String kid;
        private URL x5u;
        private Base64URL x5t;
        private List<Base64> x5c;

        public Builder(Base64URL n, Base64URL e) {
            if (n == null) {
                throw new IllegalArgumentException("The modulus value must not be null");
            }
            this.n = n;
            if (e == null) {
                throw new IllegalArgumentException("The public exponent value must not be null");
            }
            this.e = e;
        }

        public Builder(RSAPublicKey pub) {
            this.n = Base64URL.encode(pub.getModulus());
            this.e = Base64URL.encode(pub.getPublicExponent());
        }

        public Builder privateExponent(Base64URL d) {
            this.d = d;
            return this;
        }

        public Builder privateKey(RSAPrivateKey priv) {
            if (priv instanceof RSAPrivateCrtKey) {
                return this.privateKey((RSAPrivateCrtKey)priv);
            }
            if (priv instanceof RSAMultiPrimePrivateCrtKey) {
                return this.privateKey((RSAMultiPrimePrivateCrtKey)priv);
            }
            this.d = Base64URL.encode(priv.getPrivateExponent());
            return this;
        }

        public Builder firstPrimeFactor(Base64URL p) {
            this.p = p;
            return this;
        }

        public Builder secondPrimeFactor(Base64URL q) {
            this.q = q;
            return this;
        }

        public Builder firstFactorCRTExponent(Base64URL dp) {
            this.dp = dp;
            return this;
        }

        public Builder secondFactorCRTExponent(Base64URL dq) {
            this.dq = dq;
            return this;
        }

        public Builder firstCRTCoefficient(Base64URL qi) {
            this.qi = qi;
            return this;
        }

        public Builder otherPrimes(List<OtherPrimesInfo> oth) {
            this.oth = oth;
            return this;
        }

        public Builder privateKey(RSAPrivateCrtKey priv) {
            this.d = Base64URL.encode(priv.getPrivateExponent());
            this.p = Base64URL.encode(priv.getPrimeP());
            this.q = Base64URL.encode(priv.getPrimeQ());
            this.dp = Base64URL.encode(priv.getPrimeExponentP());
            this.dq = Base64URL.encode(priv.getPrimeExponentQ());
            this.qi = Base64URL.encode(priv.getCrtCoefficient());
            return this;
        }

        public Builder privateKey(RSAMultiPrimePrivateCrtKey priv) {
            this.d = Base64URL.encode(priv.getPrivateExponent());
            this.p = Base64URL.encode(priv.getPrimeP());
            this.q = Base64URL.encode(priv.getPrimeQ());
            this.dp = Base64URL.encode(priv.getPrimeExponentP());
            this.dq = Base64URL.encode(priv.getPrimeExponentQ());
            this.qi = Base64URL.encode(priv.getCrtCoefficient());
            this.oth = OtherPrimesInfo.toList(priv.getOtherPrimeInfo());
            return this;
        }

        public Builder keyUse(KeyUse use) {
            this.use = use;
            return this;
        }

        public Builder keyOperations(Set<KeyOperation> ops) {
            this.ops = ops;
            return this;
        }

        public Builder algorithm(Algorithm alg) {
            this.alg = alg;
            return this;
        }

        public Builder keyID(String kid) {
            this.kid = kid;
            return this;
        }

        public Builder x509CertURL(URL x5u) {
            this.x5u = x5u;
            return this;
        }

        public Builder x509CertThumbprint(Base64URL x5t) {
            this.x5t = x5t;
            return this;
        }

        public Builder x509CertChain(List<Base64> x5c) {
            this.x5c = x5c;
            return this;
        }

        public RSAKey build() {
            try {
                return new RSAKey(this.n, this.e, this.d, this.p, this.q, this.dp, this.dq, this.qi, this.oth, this.use, this.ops, this.alg, this.kid, this.x5u, this.x5t, this.x5c);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    public static class OtherPrimesInfo {
        private final Base64URL r;
        private final Base64URL d;
        private final Base64URL t;

        public OtherPrimesInfo(Base64URL r, Base64URL d, Base64URL t) {
            if (r == null) {
                throw new IllegalArgumentException("The prime factor must not be null");
            }
            this.r = r;
            if (d == null) {
                throw new IllegalArgumentException("The factor CRT exponent must not be null");
            }
            this.d = d;
            if (t == null) {
                throw new IllegalArgumentException("The factor CRT coefficient must not be null");
            }
            this.t = t;
        }

        public OtherPrimesInfo(RSAOtherPrimeInfo oth) {
            this.r = Base64URL.encode(oth.getPrime());
            this.d = Base64URL.encode(oth.getExponent());
            this.t = Base64URL.encode(oth.getCrtCoefficient());
        }

        public Base64URL getPrimeFactor() {
            return this.r;
        }

        public Base64URL getFactorCRTExponent() {
            return this.d;
        }

        public Base64URL getFactorCRTCoefficient() {
            return this.t;
        }

        public static List<OtherPrimesInfo> toList(RSAOtherPrimeInfo[] othArray) {
            ArrayList<OtherPrimesInfo> list = new ArrayList<OtherPrimesInfo>();
            if (othArray == null) {
                return list;
            }
            for (RSAOtherPrimeInfo oth : othArray) {
                list.add(new OtherPrimesInfo(oth));
            }
            return list;
        }
    }
}

