/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.util;

import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public class SystemVariableUtil {
    private static final String CUSTOM_VAR_PREFIX = "CUSTOM_";

    public static String getValue(String variableName, String defaultValue) {
        String value = System.getProperty(variableName) != null ? System.getProperty(variableName) : (System.getenv(variableName) != null ? System.getenv(variableName) : defaultValue);
        return value;
    }

    public static Map<String, String> getArbitraryAttributes() {
        Map<String, String> environmentVariables = System.getenv();
        Map<String, String> arbitraryAttributes = environmentVariables.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(CUSTOM_VAR_PREFIX)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Properties properties = System.getProperties();
        arbitraryAttributes.putAll(properties.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(CUSTOM_VAR_PREFIX)).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)entry.getValue())));
        return arbitraryAttributes;
    }
}

