/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.avltree;

import org.apache.directory.server.core.avltree.SingletonOrOrderedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedAvlMapNode<K, V> {
    K key;
    SingletonOrOrderedSet<V> value;
    LinkedAvlMapNode<K, V> left;
    LinkedAvlMapNode<K, V> right;
    LinkedAvlMapNode<K, V> next;
    LinkedAvlMapNode<K, V> previous;
    transient int depth;
    transient int index;
    boolean isLeft;
    transient int height = 1;

    public LinkedAvlMapNode(K theKey, V theValue) {
        this.key = theKey;
        this.value = new SingletonOrOrderedSet<V>(theValue);
        this.left = null;
        this.right = null;
    }

    public void setLeft(LinkedAvlMapNode<K, V> left) {
        this.left = left;
    }

    public void setRight(LinkedAvlMapNode<K, V> right) {
        this.right = right;
    }

    public LinkedAvlMapNode<K, V> getNext() {
        return this.next;
    }

    public LinkedAvlMapNode<K, V> getPrevious() {
        return this.previous;
    }

    public LinkedAvlMapNode<K, V> getLeft() {
        return this.left;
    }

    public LinkedAvlMapNode<K, V> getRight() {
        return this.right;
    }

    public K getKey() {
        return this.key;
    }

    public SingletonOrOrderedSet<V> getValue() {
        return this.value;
    }

    public boolean isLeaf() {
        return this.right == null && this.left == null;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getHeight() {
        return this.height;
    }

    public void setNext(LinkedAvlMapNode<K, V> next) {
        this.next = next;
    }

    public void setPrevious(LinkedAvlMapNode<K, V> previous) {
        this.previous = previous;
    }

    public int computeHeight() {
        int rh;
        int lh;
        if (this.right == null && this.left == null) {
            this.height = 1;
            return this.height;
        }
        if (this.isLeft) {
            lh = this.left == null ? -1 : this.left.computeHeight();
            rh = this.right == null ? -1 : this.right.getHeight();
        } else {
            rh = this.right == null ? -1 : this.right.computeHeight();
            lh = this.left == null ? -1 : this.left.getHeight();
        }
        this.height = 1 + Math.max(lh, rh);
        return this.height;
    }

    public int getBalance() {
        int lh = this.left == null ? 0 : this.left.computeHeight();
        int rh = this.right == null ? 0 : this.right.computeHeight();
        return rh - lh;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String toString() {
        return "[" + this.key + ", [" + this.value + "]" + "]";
    }
}

