/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.normalization;

import java.util.Iterator;
import java.util.List;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.filter.ApproximateNode;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.ExtensibleNode;
import org.apache.directory.shared.ldap.filter.FilterVisitor;
import org.apache.directory.shared.ldap.filter.GreaterEqNode;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.filter.LessEqNode;
import org.apache.directory.shared.ldap.filter.OrNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SubstringNode;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandingVisitor
implements FilterVisitor {
    private SchemaManager schemaManager;

    public ExpandingVisitor(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    @Override
    public boolean canVisit(ExprNode node) {
        return node instanceof BranchNode;
    }

    @Override
    public List<ExprNode> getOrder(BranchNode node, List<ExprNode> children) {
        return children;
    }

    @Override
    public boolean isPrefix() {
        return false;
    }

    @Override
    public Object visit(ExprNode node) {
        BranchNode bnode = (BranchNode)node;
        List<ExprNode> children = bnode.getChildren();
        int childNumber = 0;
        for (ExprNode child : children) {
            if (child instanceof LeafNode) {
                LeafNode leaf = (LeafNode)child;
                try {
                    if (!this.schemaManager.getAttributeTypeRegistry().hasDescendants(leaf.getAttribute())) continue;
                    OrNode orNode = new OrNode();
                    orNode.getChildren().add(leaf);
                    children.set(childNumber++, orNode);
                    Iterator<AttributeType> descendants = this.schemaManager.getAttributeTypeRegistry().descendants(leaf.getAttribute());
                    while (descendants.hasNext()) {
                        LeafNode newLeaf = null;
                        AttributeType descendant = descendants.next();
                        if (leaf instanceof PresenceNode) {
                            newLeaf = new PresenceNode(descendant.getOid());
                        } else if (leaf instanceof ApproximateNode) {
                            ApproximateNode approximateNode = (ApproximateNode)leaf;
                            newLeaf = new ApproximateNode(descendant.getOid(), approximateNode.getValue());
                        } else if (leaf instanceof EqualityNode) {
                            EqualityNode equalityNode = (EqualityNode)leaf;
                            newLeaf = new EqualityNode(descendant.getOid(), equalityNode.getValue());
                        } else if (leaf instanceof GreaterEqNode) {
                            GreaterEqNode greaterEqNode = (GreaterEqNode)leaf;
                            newLeaf = new GreaterEqNode(descendant.getOid(), greaterEqNode.getValue());
                        } else if (leaf instanceof LessEqNode) {
                            LessEqNode lessEqNode = (LessEqNode)leaf;
                            newLeaf = new LessEqNode(descendant.getOid(), lessEqNode.getValue());
                        } else if (leaf instanceof ExtensibleNode) {
                            ExtensibleNode extensibleNode = (ExtensibleNode)leaf;
                            newLeaf = new ExtensibleNode(descendant.getOid(), extensibleNode.getValue(), extensibleNode.getMatchingRuleId(), extensibleNode.hasDnAttributes());
                        } else if (leaf instanceof SubstringNode) {
                            SubstringNode substringNode = (SubstringNode)leaf;
                            newLeaf = new SubstringNode(descendant.getOid(), substringNode.getInitial(), substringNode.getFinal());
                        } else {
                            throw new IllegalStateException(I18n.err(I18n.ERR_260, leaf));
                        }
                        orNode.addNode(newLeaf);
                    }
                    continue;
                }
                catch (LdapException e) {
                    throw new RuntimeException(I18n.err(I18n.ERR_261, new Object[0]));
                }
            }
            this.visit(child);
        }
        return null;
    }
}

