/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.filtering.BaseEntryFilteringCursor;
import org.apache.directory.server.core.filtering.EntryFilter;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchingOperationContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.schema.SchemaService;
import org.apache.directory.server.core.schema.SchemaSubentryManager;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.constants.SchemaConstants;
import org.apache.directory.shared.ldap.cursor.EmptyCursor;
import org.apache.directory.shared.ldap.cursor.SingletonCursor;
import org.apache.directory.shared.ldap.entry.BinaryValue;
import org.apache.directory.shared.ldap.entry.DefaultServerAttribute;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.entry.ServerModification;
import org.apache.directory.shared.ldap.entry.StringValue;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapAttributeInUseException;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeTypeException;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeValueException;
import org.apache.directory.shared.ldap.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.exception.LdapNoSuchAttributeException;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.filter.ApproximateNode;
import org.apache.directory.shared.ldap.filter.AssertionNode;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.ExtensibleNode;
import org.apache.directory.shared.ldap.filter.GreaterEqNode;
import org.apache.directory.shared.ldap.filter.LessEqNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.ScopeNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.filter.SubstringNode;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.AVA;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.AttributeTypeOptions;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.shared.ldap.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.schema.registries.Schema;
import org.apache.directory.shared.ldap.schema.registries.SchemaLoader;
import org.apache.directory.shared.ldap.schema.syntaxCheckers.OctetStringSyntaxChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaInterceptor
extends BaseInterceptor {
    private static Logger LOG = LoggerFactory.getLogger(SchemaInterceptor.class);
    private static final String[] SCHEMA_SUBENTRY_RETURN_ATTRIBUTES = new String[]{"+", "*"};
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private PartitionNexus nexus;
    private BinaryAttributeFilter binaryAttributeFilter;
    private TopFilter topFilter;
    private List<EntryFilter> filters = new ArrayList<EntryFilter>();
    private SchemaManager schemaManager;
    private AttributeType OBJECT_CLASS;
    private String subschemaSubentryDnNorm;
    private DN subschemaSubentryDn;
    private DN schemaModificationAttributesDN;
    private SchemaSubentryManager schemaSubEntryManager;
    private SchemaService schemaService;
    private DN schemaBaseDN;
    private Map<String, List<ObjectClass>> superiors;
    private Map<String, List<AttributeType>> allMay;
    private Map<String, List<AttributeType>> allMust;
    private Map<String, List<AttributeType>> allowed;
    private static AttributeType MODIFIERS_NAME_ATTRIBUTE_TYPE;
    private static AttributeType MODIFY_TIMESTAMP_ATTRIBUTE_TYPE;

    @Override
    public void init(DirectoryService directoryService) throws Exception {
        if (IS_DEBUG) {
            LOG.debug("Initializing SchemaInterceptor...");
        }
        this.nexus = directoryService.getPartitionNexus();
        this.schemaManager = directoryService.getSchemaManager();
        this.OBJECT_CLASS = this.schemaManager.lookupAttributeTypeRegistry("objectClass");
        this.binaryAttributeFilter = new BinaryAttributeFilter();
        this.topFilter = new TopFilter();
        this.filters.add(this.binaryAttributeFilter);
        this.filters.add(this.topFilter);
        this.schemaBaseDN = new DN("ou=schema");
        this.schemaBaseDN.normalize(this.schemaManager.getNormalizerMapping());
        this.schemaService = directoryService.getSchemaService();
        Value<?> subschemaSubentry = this.nexus.getRootDSE(null).get("subschemaSubentry").get();
        this.subschemaSubentryDn = new DN(subschemaSubentry.getString());
        this.subschemaSubentryDn.normalize(this.schemaManager.getNormalizerMapping());
        this.subschemaSubentryDnNorm = this.subschemaSubentryDn.getNormName();
        this.schemaModificationAttributesDN = new DN("cn=schemaModifications,ou=schema");
        this.schemaModificationAttributesDN.normalize(this.schemaManager.getNormalizerMapping());
        this.computeSuperiors();
        SchemaLoader loader = this.schemaService.getSchemaPartition().getSchemaManager().getLoader();
        this.schemaSubEntryManager = new SchemaSubentryManager(this.schemaManager, loader);
        MODIFIERS_NAME_ATTRIBUTE_TYPE = this.schemaManager.lookupAttributeTypeRegistry("modifiersName");
        MODIFY_TIMESTAMP_ATTRIBUTE_TYPE = this.schemaManager.lookupAttributeTypeRegistry("modifyTimestamp");
        if (IS_DEBUG) {
            LOG.debug("SchemaInterceptor Initialized !");
        }
    }

    private void computeMustAttributes(ObjectClass objectClass, Set<String> atSeen) throws Exception {
        List<ObjectClass> parents = this.superiors.get(objectClass.getOid());
        ArrayList<AttributeType> mustList = new ArrayList<AttributeType>();
        ArrayList<AttributeType> allowedList = new ArrayList<AttributeType>();
        HashSet<String> mustSeen = new HashSet<String>();
        this.allMust.put(objectClass.getOid(), mustList);
        this.allowed.put(objectClass.getOid(), allowedList);
        for (ObjectClass parent : parents) {
            List<AttributeType> mustParent = parent.getMustAttributeTypes();
            if (mustParent == null || mustParent.size() == 0) continue;
            for (AttributeType attributeType : mustParent) {
                String oid = attributeType.getOid();
                if (mustSeen.contains(oid)) continue;
                mustSeen.add(oid);
                mustList.add(attributeType);
                allowedList.add(attributeType);
                atSeen.add(attributeType.getOid());
            }
        }
    }

    private void computeMayAttributes(ObjectClass objectClass, Set<String> atSeen) throws Exception {
        List<ObjectClass> parents = this.superiors.get(objectClass.getOid());
        ArrayList<AttributeType> mayList = new ArrayList<AttributeType>();
        HashSet<String> maySeen = new HashSet<String>();
        List<AttributeType> allowedList = this.allowed.get(objectClass.getOid());
        this.allMay.put(objectClass.getOid(), mayList);
        for (ObjectClass parent : parents) {
            List<AttributeType> mustParent = parent.getMustAttributeTypes();
            if (mustParent == null || mustParent.size() == 0) continue;
            for (AttributeType attributeType : mustParent) {
                String oid = attributeType.getOid();
                if (maySeen.contains(oid)) continue;
                maySeen.add(oid);
                mayList.add(attributeType);
                if (atSeen.contains(oid)) continue;
                allowedList.add(attributeType);
            }
        }
    }

    private void computeOCSuperiors(ObjectClass objectClass, List<ObjectClass> superiors, Set<String> ocSeen) throws Exception {
        List<ObjectClass> parents = objectClass.getSuperiors();
        if (parents != null && parents.size() != 0) {
            for (ObjectClass parent : parents) {
                if ("top".equals(parent.getName())) continue;
                this.computeOCSuperiors(parent, superiors, ocSeen);
                String oid = parent.getOid();
                if (ocSeen.contains(oid)) continue;
                superiors.add(parent);
                ocSeen.add(oid);
            }
        }
    }

    private void computeSuperior(ObjectClass objectClass) throws Exception {
        ArrayList<ObjectClass> ocSuperiors = new ArrayList<ObjectClass>();
        this.superiors.put(objectClass.getOid(), ocSuperiors);
        this.computeOCSuperiors(objectClass, ocSuperiors, new HashSet<String>());
        HashSet<String> atSeen = new HashSet<String>();
        this.computeMustAttributes(objectClass, atSeen);
        this.computeMayAttributes(objectClass, atSeen);
        this.superiors.put(objectClass.getName(), ocSuperiors);
    }

    private void computeSuperiors() throws Exception {
        Iterator objectClasses = this.schemaManager.getObjectClassRegistry().iterator();
        this.superiors = new ConcurrentHashMap<String, List<ObjectClass>>();
        this.allMust = new ConcurrentHashMap<String, List<AttributeType>>();
        this.allMay = new ConcurrentHashMap<String, List<AttributeType>>();
        this.allowed = new ConcurrentHashMap<String, List<AttributeType>>();
        while (objectClasses.hasNext()) {
            ObjectClass objectClass = (ObjectClass)objectClasses.next();
            this.computeSuperior(objectClass);
        }
    }

    @Override
    public EntryFilteringCursor list(NextInterceptor nextInterceptor, ListOperationContext opContext) throws Exception {
        EntryFilteringCursor cursor = nextInterceptor.list(opContext);
        cursor.addEntryFilter(this.binaryAttributeFilter);
        return cursor;
    }

    private void filterAttributesToReturn(SearchControls searchCtls) {
        String[] attributes = searchCtls.getReturningAttributes();
        if (attributes == null || attributes.length == 0) {
            searchCtls.setReturningAttributes(SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
            return;
        }
        HashMap<String, String> filteredAttrs = new HashMap<String, String>();
        boolean hasNoAttribute = false;
        boolean hasAttributes = false;
        for (String attribute : attributes) {
            if ("*".equals(attribute) || "+".equals(attribute) || "1.1".equals(attribute)) {
                if (!filteredAttrs.containsKey(attribute)) {
                    filteredAttrs.put(attribute, attribute);
                }
                if ("1.1".equals(attribute)) {
                    hasNoAttribute = true;
                    continue;
                }
                hasAttributes = true;
                continue;
            }
            try {
                if (this.schemaManager.getAttributeTypeRegistry().contains(attribute)) {
                    String oid = this.schemaManager.getAttributeTypeRegistry().getOidByName(attribute);
                    if (this.schemaManager.getAttributeTypeRegistry().contains(oid) && !filteredAttrs.containsKey(oid)) {
                        filteredAttrs.put(oid, attribute);
                    }
                }
                hasAttributes = true;
            }
            catch (Exception ne) {
                // empty catch block
            }
        }
        if (hasAttributes && hasNoAttribute) {
            filteredAttrs.remove("1.1");
        }
        if (filteredAttrs.size() == attributes.length) {
            return;
        }
        if (filteredAttrs.size() == 0) {
            searchCtls.setReturningAttributes(SchemaConstants.NO_ATTRIBUTE_ARRAY);
            return;
        }
        String[] newAttributesList = new String[filteredAttrs.size()];
        int pos = 0;
        for (String key : filteredAttrs.keySet()) {
            newAttributesList[pos++] = (String)filteredAttrs.get(key);
        }
        searchCtls.setReturningAttributes(newAttributesList);
    }

    private Value<?> convert(String id, Object value) throws Exception {
        AttributeType at = this.schemaManager.lookupAttributeTypeRegistry(id);
        if (at.getSyntax().isHumanReadable()) {
            if (value instanceof byte[]) {
                try {
                    return new StringValue(new String((byte[])value, "UTF-8"));
                }
                catch (UnsupportedEncodingException uee) {
                    String message = I18n.err(I18n.ERR_47, new Object[0]);
                    LOG.error(message);
                    throw new LdapException(message);
                }
            }
        } else if (value instanceof String) {
            try {
                return new BinaryValue(((String)value).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException uee) {
                String message = I18n.err(I18n.ERR_48, new Object[0]);
                LOG.error(message);
                throw new LdapException(message);
            }
        }
        return null;
    }

    private void checkFilter(ExprNode filter) throws Exception {
        block20: {
            block18: {
                block21: {
                    block19: {
                        if (filter == null) {
                            String message = I18n.err(I18n.ERR_49, new Object[0]);
                            LOG.error(message);
                            throw new LdapException(message);
                        }
                        if (!filter.isLeaf()) break block18;
                        if (!(filter instanceof EqualityNode)) break block19;
                        EqualityNode node = (EqualityNode)filter;
                        Value value = node.getValue();
                        Value<?> newValue = this.convert(node.getAttribute(), value);
                        if (newValue != null) {
                            node.setValue(newValue);
                        }
                        break block20;
                    }
                    if (!(filter instanceof SubstringNode)) break block21;
                    SubstringNode node = (SubstringNode)filter;
                    if (!this.schemaManager.lookupAttributeTypeRegistry(node.getAttribute()).getSyntax().isHumanReadable()) {
                        String message = I18n.err(I18n.ERR_50, new Object[0]);
                        LOG.error(message);
                        throw new LdapException(message);
                    }
                    break block20;
                }
                if (filter instanceof PresenceNode) break block20;
                if (filter instanceof GreaterEqNode) {
                    GreaterEqNode node = (GreaterEqNode)filter;
                    Value value = node.getValue();
                    Value<?> newValue = this.convert(node.getAttribute(), value);
                    if (newValue != null) {
                        node.setValue(newValue);
                    }
                } else if (filter instanceof LessEqNode) {
                    LessEqNode node = (LessEqNode)filter;
                    Value value = node.getValue();
                    Value<?> newValue = this.convert(node.getAttribute(), value);
                    if (newValue != null) {
                        node.setValue(newValue);
                    }
                } else if (filter instanceof ExtensibleNode) {
                    ExtensibleNode node = (ExtensibleNode)filter;
                    if (!this.schemaManager.lookupAttributeTypeRegistry(node.getAttribute()).getSyntax().isHumanReadable()) {
                        String message = I18n.err(I18n.ERR_51, new Object[0]);
                        LOG.error(message);
                        throw new LdapException(message);
                    }
                } else if (filter instanceof ApproximateNode) {
                    ApproximateNode node = (ApproximateNode)filter;
                    Value value = node.getValue();
                    Value<?> newValue = this.convert(node.getAttribute(), value);
                    if (newValue != null) {
                        node.setValue(newValue);
                    }
                } else {
                    if (filter instanceof AssertionNode) {
                        return;
                    }
                    if (filter instanceof ScopeNode) {
                        return;
                    }
                }
                break block20;
            }
            for (ExprNode child : ((BranchNode)filter).getChildren()) {
                this.checkFilter(child);
            }
        }
    }

    @Override
    public EntryFilteringCursor search(NextInterceptor nextInterceptor, SearchOperationContext opContext) throws Exception {
        String baseNormForm;
        DN base = opContext.getDn();
        SearchControls searchCtls = opContext.getSearchControls();
        ExprNode filter = opContext.getFilter();
        if (searchCtls.getReturningAttributes() != null) {
            this.filterAttributesToReturn(searchCtls);
        }
        this.checkFilter(filter);
        String string = baseNormForm = base.isNormalized() ? base.getNormName() : base.getNormName();
        if (!this.subschemaSubentryDnNorm.equals(baseNormForm)) {
            EntryFilteringCursor cursor = nextInterceptor.search(opContext);
            if (searchCtls.getReturningAttributes() != null) {
                cursor.addEntryFilter(this.topFilter);
                return cursor;
            }
            for (EntryFilter ef : this.filters) {
                cursor.addEntryFilter(ef);
            }
            return cursor;
        }
        if (searchCtls.getSearchScope() == 0) {
            PresenceNode node;
            if (filter instanceof SimpleNode) {
                SimpleNode node2 = (SimpleNode)filter;
                String objectClass = node2.getValue().getString();
                String objectClassOid = null;
                if (!this.schemaManager.getObjectClassRegistry().contains(objectClass)) {
                    return new BaseEntryFilteringCursor(new EmptyCursor<ServerEntry>(), opContext);
                }
                objectClassOid = ((ObjectClass)this.schemaManager.getObjectClassRegistry().lookup(objectClass)).getOid();
                String nodeOid = this.schemaManager.getAttributeTypeRegistry().getOidByName(node2.getAttribute());
                if (nodeOid.equals("2.5.4.0") && (objectClassOid.equals("2.5.6.0") || objectClassOid.equals("2.5.20.1")) && node2 instanceof EqualityNode) {
                    ServerEntry serverEntry = this.schemaService.getSubschemaEntry(searchCtls.getReturningAttributes());
                    serverEntry.setDn(base);
                    return new BaseEntryFilteringCursor(new SingletonCursor<ServerEntry>(serverEntry), opContext);
                }
                return new BaseEntryFilteringCursor(new EmptyCursor<ServerEntry>(), opContext);
            }
            if (filter instanceof PresenceNode && (node = (PresenceNode)filter).getAttribute().equals("2.5.4.0")) {
                ServerEntry serverEntry = this.schemaService.getSubschemaEntry(searchCtls.getReturningAttributes());
                serverEntry.setDn(base);
                BaseEntryFilteringCursor cursor = new BaseEntryFilteringCursor(new SingletonCursor<ServerEntry>(serverEntry), opContext);
                return cursor;
            }
        }
        return new BaseEntryFilteringCursor(new EmptyCursor<ServerEntry>(), opContext);
    }

    @Override
    public ClonedServerEntry lookup(NextInterceptor nextInterceptor, LookupOperationContext opContext) throws Exception {
        ClonedServerEntry result = nextInterceptor.lookup(opContext);
        if (result == null) {
            return null;
        }
        this.filterBinaryAttributes(result);
        this.filterObjectClass(result);
        return result;
    }

    private void getSuperiors(ObjectClass oc, Set<String> ocSeen, List<ObjectClass> result) throws Exception {
        for (ObjectClass parent : oc.getSuperiors()) {
            if ("top".equals(parent.getName())) continue;
            if (!ocSeen.contains(parent.getOid())) {
                ocSeen.add(parent.getOid());
                result.add(parent);
            }
            this.getSuperiors(parent, ocSeen, result);
        }
    }

    private boolean isRequired(String attrId, EntryAttribute objectClasses) throws Exception {
        OidRegistry oidRegistry = this.schemaManager.getGlobalOidRegistry();
        if (!oidRegistry.contains(attrId)) {
            return false;
        }
        String attrOid = this.schemaManager.getAttributeTypeRegistry().getOidByName(attrId);
        for (Value objectClass : objectClasses) {
            ObjectClass ocSpec = (ObjectClass)this.schemaManager.getObjectClassRegistry().lookup(objectClass.getString());
            for (AttributeType must : ocSpec.getMustAttributeTypes()) {
                if (!must.getOid().equals(attrOid)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCompleteRemoval(EntryAttribute change, ServerEntry entry) throws Exception {
        if (change.size() == 0) {
            return true;
        }
        EntryAttribute changedEntryAttr = entry.get(change.getUpId()).clone();
        for (Value value : change) {
            changedEntryAttr.remove(value);
        }
        return changedEntryAttr.size() == 0;
    }

    private EntryAttribute getResultantObjectClasses(ModificationOperation modOp, EntryAttribute changes, EntryAttribute existing) throws Exception {
        if (changes == null && existing == null) {
            return new DefaultServerAttribute("objectClass", this.OBJECT_CLASS);
        }
        if (changes == null) {
            return existing;
        }
        if (existing == null && modOp == ModificationOperation.ADD_ATTRIBUTE) {
            return changes;
        }
        if (existing == null) {
            return new DefaultServerAttribute("objectClass", this.OBJECT_CLASS);
        }
        switch (modOp) {
            case ADD_ATTRIBUTE: {
                for (Value value : changes) {
                    existing.add(value);
                }
                return existing;
            }
            case REPLACE_ATTRIBUTE: {
                return changes.clone();
            }
            case REMOVE_ATTRIBUTE: {
                for (Value value : changes) {
                    existing.remove(value);
                }
                return existing;
            }
        }
        throw new InternalError("");
    }

    private boolean getObjectClasses(EntryAttribute objectClasses, List<ObjectClass> result) throws Exception {
        HashSet<String> ocSeen = new HashSet<String>();
        boolean hasExtensibleObject = false;
        for (Value objectClass : objectClasses) {
            ObjectClass oc;
            String objectClassName = objectClass.getString();
            if ("top".equals(objectClassName)) continue;
            if ("extensibleObject".equalsIgnoreCase(objectClassName)) {
                hasExtensibleObject = true;
            }
            if (!ocSeen.contains((oc = (ObjectClass)this.schemaManager.getObjectClassRegistry().lookup(objectClassName)).getOid())) {
                ocSeen.add(oc.getOid());
                result.add(oc);
            }
            this.getSuperiors(oc, ocSeen, result);
        }
        return hasExtensibleObject;
    }

    private Set<String> getAllMust(EntryAttribute objectClasses) throws Exception {
        HashSet<String> must = new HashSet<String>();
        for (Value value : objectClasses) {
            String ocName = value.getString();
            ObjectClass oc = (ObjectClass)this.schemaManager.getObjectClassRegistry().lookup(ocName);
            List<AttributeType> types = oc.getMustAttributeTypes();
            if (types == null || types.size() <= 0) continue;
            for (AttributeType type : types) {
                must.add(type.getOid());
            }
        }
        return must;
    }

    private Set<String> getAllAllowed(EntryAttribute objectClasses, Set<String> must) throws Exception {
        HashSet<String> allowed = new HashSet<String>(must);
        allowed.add(this.schemaManager.getAttributeTypeRegistry().getOidByName("objectClass"));
        for (Value objectClass : objectClasses) {
            String ocName = objectClass.getString();
            ObjectClass oc = (ObjectClass)this.schemaManager.getObjectClassRegistry().lookup(ocName);
            List<AttributeType> types = oc.getMayAttributeTypes();
            if (types == null || types.size() <= 0) continue;
            for (AttributeType type : types) {
                String oid = type.getOid();
                allowed.add(oid);
            }
        }
        return allowed;
    }

    private void alterObjectClasses(EntryAttribute objectClassAttr) throws Exception {
        HashSet<String> objectClasses = new HashSet<String>();
        HashSet<String> objectClassesUP = new HashSet<String>();
        objectClasses.add("top");
        objectClassesUP.add("top");
        for (Value ocValue : objectClassAttr) {
            List<ObjectClass> ocSuperiors;
            String ocName = ocValue.getString();
            if (ocName.equalsIgnoreCase("top")) continue;
            String ocLowerName = ocName.toLowerCase();
            ObjectClass objectClass = (ObjectClass)this.schemaManager.getObjectClassRegistry().lookup(ocLowerName);
            if (!objectClasses.contains(ocLowerName)) {
                objectClasses.add(ocLowerName);
                objectClassesUP.add(ocName);
            }
            if ((ocSuperiors = this.superiors.get(objectClass.getOid())) == null) continue;
            for (ObjectClass oc : ocSuperiors) {
                if (objectClasses.contains(oc.getName().toLowerCase())) continue;
                objectClasses.add(oc.getName());
                objectClassesUP.add(oc.getName());
            }
        }
        objectClassAttr.clear();
        for (String attribute : objectClassesUP) {
            objectClassAttr.add(attribute);
        }
    }

    @Override
    public void rename(NextInterceptor next, RenameOperationContext opContext) throws Exception {
        DN oldDn = opContext.getDn();
        RDN newRdn = opContext.getNewRdn();
        boolean deleteOldRn = opContext.getDelOldDn();
        ServerEntry entry = (ServerEntry)opContext.getEntry().getClonedEntry();
        if (deleteOldRn) {
            AttributeType type;
            ServerEntry tmpEntry = (ServerEntry)entry.clone();
            RDN oldRDN = oldDn.getRdn();
            for (AVA atav : oldRDN) {
                type = this.schemaManager.lookupAttributeTypeRegistry(atav.getUpType());
                tmpEntry.remove(type, atav.getUpValue());
            }
            for (AVA atav : newRdn) {
                type = this.schemaManager.lookupAttributeTypeRegistry(atav.getUpType());
                if (tmpEntry.contains(type, atav.getNormValue())) continue;
                tmpEntry.add(new DefaultServerAttribute(type, atav.getUpValue()));
            }
            tmpEntry.setDn(opContext.getNewDn());
            this.check(opContext.getNewDn(), tmpEntry);
            for (AVA atav : oldRDN) {
                AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(atav.getUpType());
                if (attributeType.isUserModifiable()) continue;
                throw new LdapNoPermissionException("Cannot modify the attribute '" + atav.getUpType() + "'");
            }
        }
        next.rename(opContext);
    }

    private EntryAttribute createNewAttribute(EntryAttribute attribute) {
        AttributeType attributeType = attribute.getAttributeType();
        DefaultServerAttribute newAttribute = new DefaultServerAttribute(attribute.getUpId(), attributeType);
        for (Value value : attribute) {
            newAttribute.add(value);
        }
        return newAttribute;
    }

    private void checkModifyEntry(DN dn, ServerEntry currentEntry, List<Modification> mods) throws Exception {
        ServerEntry tempEntry = (ServerEntry)currentEntry.clone();
        block5: for (Modification mod : mods) {
            String msg;
            EntryAttribute attribute = mod.getAttribute();
            AttributeType attributeType = attribute.getAttributeType();
            if (!(attributeType.isUserModifiable() || attributeType.equals(MODIFIERS_NAME_ATTRIBUTE_TYPE) || attributeType.equals(MODIFY_TIMESTAMP_ATTRIBUTE_TYPE))) {
                msg = I18n.err(I18n.ERR_52, attributeType);
                LOG.error(msg);
                throw new LdapNoPermissionException(msg);
            }
            switch (mod.getOperation()) {
                case ADD_ATTRIBUTE: {
                    if (!attribute.isValid()) {
                        msg = I18n.err(I18n.ERR_53, attributeType);
                        LOG.error(msg);
                        throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, msg);
                    }
                    EntryAttribute currentAttribute = tempEntry.get(attributeType);
                    if (currentAttribute != null) {
                        for (Value value : attribute) {
                            if (currentAttribute.contains(value)) {
                                String msg2 = I18n.err(I18n.ERR_54, value);
                                LOG.error(msg2);
                                throw new LdapAttributeInUseException(msg2);
                            }
                            currentAttribute.add(value);
                        }
                        continue block5;
                    }
                    EntryAttribute newAttribute = this.createNewAttribute(attribute);
                    tempEntry.put(newAttribute);
                    break;
                }
                case REMOVE_ATTRIBUTE: {
                    if (!tempEntry.containsAttribute(attributeType)) {
                        String msg3 = I18n.err(I18n.ERR_55, attributeType);
                        LOG.error(msg3);
                        throw new LdapNoSuchAttributeException(msg3);
                    }
                    if (attribute.size() == 0) {
                        tempEntry.removeAttributes(attributeType);
                        break;
                    }
                    EntryAttribute currentAttribute = tempEntry.get(attributeType);
                    for (Value value : attribute) {
                        if (currentAttribute.contains(value)) {
                            currentAttribute.remove(value);
                            continue;
                        }
                        String msg4 = I18n.err(I18n.ERR_56, attributeType);
                        LOG.error(msg4);
                        throw new LdapNoSuchAttributeException(msg4);
                    }
                    if (currentAttribute.size() != 0) break;
                    tempEntry.removeAttributes(attributeType);
                    break;
                }
                case REPLACE_ATTRIBUTE: {
                    EntryAttribute newAttribute;
                    if (!tempEntry.containsAttribute(attributeType)) {
                        if (attribute.size() == 0) break;
                        newAttribute = this.createNewAttribute(attribute);
                        tempEntry.put(newAttribute);
                        break;
                    }
                    if (attribute.size() == 0) {
                        tempEntry.removeAttributes(attributeType);
                        break;
                    }
                    tempEntry.removeAttributes(attributeType);
                    newAttribute = this.createNewAttribute(attribute);
                    tempEntry.put(newAttribute);
                }
            }
        }
        this.check(dn, tempEntry);
    }

    @Override
    public void modify(NextInterceptor next, ModifyOperationContext opContext) throws Exception {
        DN dn = opContext.getDn();
        if (dn.equals(this.subschemaSubentryDn)) {
            LOG.debug("Modification attempt on schema subentry {}: \n{}", (Object)dn, (Object)opContext);
            List<Modification> mods = opContext.getModItems();
            ArrayList<Modification> cleanMods = new ArrayList<Modification>();
            for (Modification mod : mods) {
                AttributeType at = ((ServerModification)mod).getAttribute().getAttributeType();
                if (MODIFIERS_NAME_ATTRIBUTE_TYPE.equals(at) || MODIFY_TIMESTAMP_ATTRIBUTE_TYPE.equals(at)) continue;
                cleanMods.add(mod);
            }
            opContext.setModItems(cleanMods);
            this.schemaSubEntryManager.modifySchemaSubentry(opContext, opContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1"));
            return;
        }
        ClonedServerEntry entry = opContext.getEntry();
        List<Modification> modifications = opContext.getModItems();
        this.checkModifyEntry(dn, entry, modifications);
        next.modify(opContext);
    }

    private void filterAttributeTypes(SearchingOperationContext operation, ClonedServerEntry result) {
        if (operation.getReturningAttributes() == null) {
            return;
        }
        block2: for (AttributeTypeOptions attrOptions : operation.getReturningAttributes()) {
            EntryAttribute attribute = result.get(attrOptions.getAttributeType());
            if (!attrOptions.hasOption()) continue;
            for (String option : attrOptions.getOptions()) {
                if ("binary".equalsIgnoreCase(option)) continue;
                try {
                    if (!result.contains(attribute)) continue block2;
                    result.remove(attribute);
                }
                catch (LdapException ne) {}
                continue block2;
            }
        }
    }

    private void filterObjectClass(ServerEntry entry) throws Exception {
        ArrayList<ObjectClass> objectClasses = new ArrayList<ObjectClass>();
        EntryAttribute oc = entry.get("objectClass");
        if (oc != null) {
            this.getObjectClasses(oc, objectClasses);
            entry.removeAttributes("objectClass");
            DefaultServerAttribute newOc = new DefaultServerAttribute(oc.getAttributeType());
            for (ObjectClass currentOC : objectClasses) {
                newOc.add(currentOC.getName());
            }
            newOc.add("top");
            entry.put(newOc);
        }
    }

    private void filterBinaryAttributes(ServerEntry entry) throws Exception {
        for (EntryAttribute attribute : entry) {
            if (attribute.getAttributeType().getSyntax().isHumanReadable()) continue;
            ArrayList binaries = new ArrayList();
            for (Value value : attribute) {
                binaries.add(new BinaryValue(attribute.getAttributeType(), value.getBytes()));
            }
            attribute.clear();
            attribute.put(binaries);
        }
    }

    private void check(DN dn, ServerEntry entry) throws Exception {
        for (AttributeType attributeType : entry.getAttributeTypes()) {
            if (this.schemaManager.getAttributeTypeRegistry().contains(attributeType.getName())) continue;
            throw new LdapInvalidAttributeTypeException(I18n.err(I18n.ERR_275, attributeType.getName()));
        }
        EntryAttribute objectClassAttr = entry.get("objectClass");
        if (objectClassAttr == null) {
            objectClassAttr = new DefaultServerAttribute("objectClass", this.OBJECT_CLASS);
        }
        ArrayList<ObjectClass> ocs = new ArrayList<ObjectClass>();
        this.alterObjectClasses(objectClassAttr);
        Set<String> must = this.getAllMust(objectClassAttr);
        Set<String> allowed = this.getAllAllowed(objectClassAttr, must);
        boolean hasExtensibleObject = this.getObjectClasses(objectClassAttr, ocs);
        this.assertObjectClasses(dn, ocs);
        this.assertRequiredAttributesPresent(dn, entry, must);
        this.assertNumberOfAttributeValuesValid(entry);
        if (!hasExtensibleObject) {
            this.assertAllAttributesAllowed(dn, entry, allowed);
        }
        this.assertHumanReadable(entry);
        this.assertSyntaxes(entry);
        this.assertRdn(dn, entry);
    }

    private void checkOcSuperior(ServerEntry entry) throws Exception {
        EntryAttribute supOC = entry.get("m-supObjectClass");
        if (supOC != null) {
            ObjectClassTypeEnum ocType = ObjectClassTypeEnum.STRUCTURAL;
            if (entry.get("m-typeObjectClass") != null) {
                String type = entry.get("m-typeObjectClass").getString();
                ocType = ObjectClassTypeEnum.getClassType(type);
            }
            for (Value sup : supOC) {
                try {
                    String supName = sup.getString();
                    ObjectClass superior = (ObjectClass)this.schemaManager.getObjectClassRegistry().lookup(supName);
                    switch (ocType) {
                        case ABSTRACT: {
                            if (superior.isAbstract()) break;
                            String message = I18n.err(I18n.ERR_57, new Object[0]);
                            LOG.error(message);
                            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, message);
                        }
                        case AUXILIARY: {
                            if (superior.isAbstract() || superior.isAuxiliary()) break;
                            String message = I18n.err(I18n.ERR_58, new Object[0]);
                            LOG.error(message);
                            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, message);
                        }
                    }
                }
                catch (LdapException ne) {
                    String message = I18n.err(I18n.ERR_59, new Object[0]);
                    LOG.error(message);
                    throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, message);
                }
            }
        }
    }

    @Override
    public void add(NextInterceptor next, AddOperationContext addContext) throws Exception {
        DN name = addContext.getDn();
        ClonedServerEntry entry = addContext.getEntry();
        this.check(name, entry);
        if (name.isChildOf(this.schemaBaseDN)) {
            String schemaName = this.getSchemaName(name);
            if (entry.contains("objectClass", "metaSchema")) {
                next.add(addContext);
                if (this.schemaManager.isSchemaLoaded(schemaName)) {
                    this.computeSuperiors();
                }
            } else if (entry.contains("objectClass", "metaObjectClass")) {
                this.checkOcSuperior(addContext.getEntry());
                next.add(addContext);
                Schema schema = this.schemaManager.getLoadedSchema(schemaName);
                if (schema != null && schema.isEnabled()) {
                    String ocName = entry.get("m-name").getString();
                    ObjectClass addedOC = (ObjectClass)this.schemaManager.getObjectClassRegistry().lookup(ocName);
                    this.computeSuperior(addedOC);
                }
            } else if (entry.contains("objectClass", "metaAttributeType")) {
                next.add(addContext);
            } else {
                next.add(addContext);
            }
        } else {
            next.add(addContext);
        }
    }

    private String getSchemaName(DN dn) throws LdapException {
        if (dn.size() < 2) {
            throw new LdapException(I18n.err(I18n.ERR_276, new Object[0]));
        }
        RDN rdn = dn.getRdn(1);
        return rdn.getNormValue();
    }

    private void assertAllAttributesAllowed(DN dn, ServerEntry entry, Set<String> allowed) throws Exception {
        EntryAttribute objectClass = entry.get("objectClass");
        if (objectClass.contains("extensibleObject")) {
            return;
        }
        for (EntryAttribute attribute : entry) {
            String attrOid = attribute.getAttributeType().getOid();
            AttributeType attributeType = attribute.getAttributeType();
            if (attributeType.isCollective() || attributeType.getUsage() != UsageEnum.USER_APPLICATIONS || allowed.contains(attrOid)) continue;
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, I18n.err(I18n.ERR_277, attribute.getUpId(), dn.getName()));
        }
    }

    private void assertNumberOfAttributeValuesValid(Entry entry) throws LdapInvalidAttributeValueException {
        for (EntryAttribute attribute : entry) {
            this.assertNumberOfAttributeValuesValid(attribute);
        }
    }

    private void assertNumberOfAttributeValuesValid(EntryAttribute attribute) throws LdapInvalidAttributeValueException {
        if (attribute.size() > 1 && attribute.getAttributeType().isSingleValued()) {
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.CONSTRAINT_VIOLATION, I18n.err(I18n.ERR_278, attribute.getUpId()));
        }
    }

    private void assertRequiredAttributesPresent(DN dn, Entry entry, Set<String> must) throws Exception {
        for (EntryAttribute attribute : entry) {
            must.remove(attribute.getAttributeType().getOid());
        }
        if (must.size() != 0) {
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, I18n.err(I18n.ERR_279, must, dn.getName()));
        }
    }

    private void assertObjectClasses(DN dn, List<ObjectClass> ocs) throws Exception {
        HashSet<ObjectClass> structuralObjectClasses = new HashSet<ObjectClass>();
        for (ObjectClass oc : ocs) {
            if (!oc.isStructural()) continue;
            structuralObjectClasses.add(oc);
        }
        if (structuralObjectClasses.isEmpty()) {
            String message = I18n.err(I18n.ERR_60, dn);
            LOG.error(message);
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, message);
        }
        HashSet<ObjectClass> remaining = new HashSet<ObjectClass>(structuralObjectClasses.size());
        remaining.addAll(structuralObjectClasses);
        for (ObjectClass oc : structuralObjectClasses) {
            if (oc.getSuperiors() == null) continue;
            for (ObjectClass superClass : oc.getSuperiors()) {
                if (!superClass.isStructural()) continue;
                remaining.remove(superClass);
            }
        }
        if (remaining.size() > 1) {
            String message = I18n.err(I18n.ERR_61, dn, remaining);
            LOG.error(message);
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, message);
        }
    }

    private void assertSyntaxes(Entry entry) throws Exception {
        for (EntryAttribute attribute : entry) {
            AttributeType attributeType = attribute.getAttributeType();
            SyntaxChecker syntaxChecker = attributeType.getSyntax().getSyntaxChecker();
            if (syntaxChecker instanceof OctetStringSyntaxChecker) continue;
            for (Value value : attribute) {
                if (value.isValid()) continue;
                try {
                    syntaxChecker.assertSyntax(value.get());
                }
                catch (Exception ne) {
                    String message = I18n.err(I18n.ERR_280, value.getString(), attribute.getUpId());
                    LOG.info(message);
                    throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, message);
                }
            }
        }
    }

    private void assertRdn(DN dn, ServerEntry entry) throws Exception {
        for (AVA atav : dn.getRdn()) {
            EntryAttribute attribute = entry.get(atav.getNormType());
            if (attribute != null && attribute.contains(atav.getNormValue())) continue;
            String message = I18n.err(I18n.ERR_62, dn, atav.getUpType());
            LOG.error(message);
            throw new LdapSchemaViolationException(ResultCodeEnum.NOT_ALLOWED_ON_RDN, message);
        }
    }

    private boolean checkHumanReadable(EntryAttribute attribute) throws Exception {
        boolean isModified = false;
        for (Value value : attribute) {
            if (value instanceof StringValue) continue;
            if (value instanceof BinaryValue) {
                try {
                    String valStr = new String(value.getBytes(), "UTF-8");
                    attribute.remove(value);
                    attribute.add(valStr);
                    isModified = true;
                    continue;
                }
                catch (UnsupportedEncodingException uee) {
                    throw new LdapException(I18n.err(I18n.ERR_281, new Object[0]));
                }
            }
            throw new LdapException(I18n.err(I18n.ERR_282, new Object[0]));
        }
        return isModified;
    }

    private boolean checkNotHumanReadable(EntryAttribute attribute) throws Exception {
        boolean isModified = false;
        for (Value value : attribute) {
            if (value instanceof BinaryValue) continue;
            if (value instanceof StringValue) {
                try {
                    byte[] valBytes = value.getString().getBytes("UTF-8");
                    attribute.remove(value);
                    attribute.add(new byte[][]{valBytes});
                    isModified = true;
                    continue;
                }
                catch (UnsupportedEncodingException uee) {
                    String message = I18n.err(I18n.ERR_63, new Object[0]);
                    LOG.error(message);
                    throw new LdapException(message);
                }
            }
            String message = I18n.err(I18n.ERR_64, new Object[0]);
            LOG.error(message);
            throw new LdapException(message);
        }
        return isModified;
    }

    private void assertHumanReadable(ServerEntry entry) throws Exception {
        boolean isModified = false;
        ServerEntry clonedEntry = null;
        for (EntryAttribute attribute : entry) {
            AttributeType attributeType = attribute.getAttributeType();
            isModified = attributeType.getSyntax().isHumanReadable() ? this.checkHumanReadable(attribute) : this.checkNotHumanReadable(attribute);
            if (!isModified) continue;
            if (clonedEntry == null) {
                clonedEntry = (ServerEntry)entry.clone();
            }
            clonedEntry.put(attribute);
            isModified = false;
        }
        if (clonedEntry != null) {
            entry = clonedEntry;
        }
    }

    private class TopFilter
    implements EntryFilter {
        private TopFilter() {
        }

        public boolean accept(SearchingOperationContext operation, ClonedServerEntry result) throws Exception {
            SchemaInterceptor.this.filterObjectClass(result);
            SchemaInterceptor.this.filterAttributeTypes(operation, result);
            return true;
        }
    }

    private class BinaryAttributeFilter
    implements EntryFilter {
        private BinaryAttributeFilter() {
        }

        public boolean accept(SearchingOperationContext operation, ClonedServerEntry result) throws Exception {
            SchemaInterceptor.this.filterBinaryAttributes(result);
            return true;
        }
    }
}

