/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.sam;

import java.io.IOException;
import javax.security.auth.kerberos.KerberosKey;
import org.apache.directory.server.kerberos.sam.KeyIntegrityChecker;
import org.apache.directory.server.kerberos.shared.crypto.encryption.CipherTextHandler;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KeyUsage;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.io.decoder.EncryptedDataDecoder;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedTimeStamp;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;

public class TimestampChecker
implements KeyIntegrityChecker {
    private static final long FIVE_MINUTES = 300000L;
    private static final CipherTextHandler cipherTextHandler = new CipherTextHandler();

    public boolean checkKeyIntegrity(byte[] encryptedData, KerberosKey kerberosKey) {
        EncryptionType keyType = EncryptionType.getTypeByOrdinal(kerberosKey.getKeyType());
        EncryptionKey key = new EncryptionKey(keyType, kerberosKey.getEncoded());
        try {
            EncryptedData sadValue = EncryptedDataDecoder.decode(encryptedData);
            EncryptedTimeStamp timestamp = (EncryptedTimeStamp)cipherTextHandler.unseal(EncryptedTimeStamp.class, key, sadValue, KeyUsage.NUMBER1);
            KerberosTime time = timestamp.getTimeStamp();
            if (time.isInClockSkew(300000L)) {
                return true;
            }
        }
        catch (IOException ioe) {
            return false;
        }
        catch (KerberosException ke) {
            return false;
        }
        catch (ClassCastException cce) {
            return false;
        }
        return false;
    }
}

