/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.components;

import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.messages.Encodable;
import org.apache.directory.server.kerberos.shared.messages.components.MessageComponentType;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.HostAddresses;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.messages.value.LastRequest;
import org.apache.directory.server.kerberos.shared.messages.value.flags.TicketFlags;

public class EncKdcRepPart
implements Encodable {
    private EncryptionKey key;
    private LastRequest lastRequest;
    private int nonce;
    private KerberosTime keyExpiration;
    private TicketFlags flags = new TicketFlags();
    private KerberosTime authTime;
    private KerberosTime startTime;
    private KerberosTime endTime;
    private KerberosTime renewTill;
    private KerberosPrincipal serverPrincipal;
    private HostAddresses clientAddresses;
    private MessageComponentType componentType;

    public EncKdcRepPart() {
    }

    public EncKdcRepPart(EncryptionKey key, LastRequest lastReq, int nonce, KerberosTime keyExpiration, TicketFlags flags, KerberosTime authtime, KerberosTime starttime, KerberosTime endtime, KerberosTime renewTill, KerberosPrincipal serverPrincipal, HostAddresses caddr, MessageComponentType componentType) {
        this.key = key;
        this.lastRequest = lastReq;
        this.nonce = nonce;
        this.keyExpiration = keyExpiration;
        this.flags = flags;
        this.authTime = authtime;
        this.startTime = starttime;
        this.endTime = endtime;
        this.renewTill = renewTill;
        this.serverPrincipal = serverPrincipal;
        this.clientAddresses = caddr;
        this.componentType = componentType;
    }

    public KerberosTime getAuthTime() {
        return this.authTime;
    }

    public HostAddresses getClientAddresses() {
        return this.clientAddresses;
    }

    public KerberosTime getEndTime() {
        return this.endTime;
    }

    public TicketFlags getFlags() {
        return this.flags;
    }

    public EncryptionKey getKey() {
        return this.key;
    }

    public KerberosTime getKeyExpiration() {
        return this.keyExpiration;
    }

    public LastRequest getLastRequest() {
        return this.lastRequest;
    }

    public int getNonce() {
        return this.nonce;
    }

    public KerberosTime getRenewTill() {
        return this.renewTill;
    }

    public KerberosPrincipal getServerPrincipal() {
        return this.serverPrincipal;
    }

    public String getServerRealm() {
        return this.serverPrincipal.getRealm();
    }

    public KerberosTime getStartTime() {
        return this.startTime;
    }

    public MessageComponentType getComponentType() {
        return this.componentType;
    }

    public void setAuthTime(KerberosTime time) {
        this.authTime = time;
    }

    public void setClientAddresses(HostAddresses addresses) {
        this.clientAddresses = addresses;
    }

    public void setEndTime(KerberosTime time) {
        this.endTime = time;
    }

    public void setFlags(TicketFlags flags) {
        this.flags = flags;
    }

    public void setKey(EncryptionKey key) {
        this.key = key;
    }

    public void setKeyExpiration(KerberosTime expiration) {
        this.keyExpiration = expiration;
    }

    public void setLastRequest(LastRequest request) {
        this.lastRequest = request;
    }

    public void setNonce(int nonce) {
        this.nonce = nonce;
    }

    public void setRenewTill(KerberosTime till) {
        this.renewTill = till;
    }

    public void setServerPrincipal(KerberosPrincipal principal) {
        this.serverPrincipal = principal;
    }

    public void setStartTime(KerberosTime time) {
        this.startTime = time;
    }
}

