/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.internal.InternalAddRequest;
import org.apache.directory.shared.ldap.message.internal.InternalLdapResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddHandler
extends LdapRequestHandler<InternalAddRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(AddHandler.class);

    @Override
    public void handle(LdapSession session, InternalAddRequest req) {
        LOG.debug("Handling request: {}", (Object)req);
        InternalLdapResult result = req.getResultResponse().getLdapResult();
        try {
            CoreSession coreSession = session.getCoreSession();
            coreSession.add(req);
            result.setResultCode(ResultCodeEnum.SUCCESS);
            session.getIoSession().write(req.getResultResponse());
        }
        catch (Exception e) {
            this.handleException(session, req, e);
        }
    }
}

