/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.tools;

import java.util.UUID;
import org.apache.directory.server.xdbm.ForwardIndexEntry;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.shared.ldap.csn.CsnFactory;
import org.apache.directory.shared.ldap.entry.DefaultServerEntry;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.entry.client.DefaultClientAttribute;
import org.apache.directory.shared.ldap.entry.client.DefaultClientEntry;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.SchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreUtils {
    private static final CsnFactory CSN_FACTORY = new CsnFactory(0);

    public static void loadExampleData(Store<ServerEntry, Long> store, SchemaManager schemaManager) throws Exception {
        store.setSuffixDn("o=Good Times Co.");
        DN suffixDn = new DN("o=Good Times Co.");
        suffixDn.normalize(schemaManager.getNormalizerMapping());
        store.init(schemaManager);
        DefaultServerEntry entry = new DefaultServerEntry(schemaManager, suffixDn);
        entry.add("objectClass", "organization");
        entry.add("o", "Good Times Co.");
        entry.add("postalCode", "1");
        entry.add("postOfficeBox", "1");
        StoreUtils.injectEntryInStore(store, entry);
        DN dn = new DN("ou=Sales,o=Good Times Co.");
        dn.normalize(schemaManager.getNormalizerMapping());
        entry = new DefaultServerEntry(schemaManager, dn);
        entry.add("objectClass", "top", "organizationalUnit");
        entry.add("ou", "Sales");
        entry.add("postalCode", "1");
        entry.add("postOfficeBox", "1");
        StoreUtils.injectEntryInStore(store, entry);
        dn = new DN("ou=Board of Directors,o=Good Times Co.");
        dn.normalize(schemaManager.getNormalizerMapping());
        entry = new DefaultServerEntry(schemaManager, dn);
        entry.add("objectClass", "top", "organizationalUnit");
        entry.add("ou", "Board of Directors");
        entry.add("postalCode", "1");
        entry.add("postOfficeBox", "1");
        StoreUtils.injectEntryInStore(store, entry);
        dn = new DN("ou=Engineering,o=Good Times Co.");
        dn.normalize(schemaManager.getNormalizerMapping());
        entry = new DefaultServerEntry(schemaManager, dn);
        entry.add("objectClass", "top", "organizationalUnit");
        entry.add("ou", "Engineering");
        entry.add("postalCode", "2");
        entry.add("postOfficeBox", "2");
        StoreUtils.injectEntryInStore(store, entry);
        dn = new DN("cn=JOhnny WAlkeR,ou=Sales,o=Good Times Co.");
        dn.normalize(schemaManager.getNormalizerMapping());
        entry = new DefaultServerEntry(schemaManager, dn);
        entry.add("objectClass", "top", "person", "organizationalPerson");
        entry.add("ou", "Sales");
        entry.add("cn", "JOhnny WAlkeR");
        entry.add("sn", "WAlkeR");
        entry.add("postalCode", "3");
        entry.add("postOfficeBox", "3");
        StoreUtils.injectEntryInStore(store, entry);
        dn = new DN("cn=JIM BEAN,ou=Sales,o=Good Times Co.");
        dn.normalize(schemaManager.getNormalizerMapping());
        entry = new DefaultServerEntry(schemaManager, dn);
        entry.add("objectClass", "top", "person", "organizationalPerson");
        entry.add("ou", "Sales");
        entry.add("cn", "JIM BEAN");
        entry.add("surName", "BEAN");
        entry.add("postalCode", "4");
        entry.add("postOfficeBox", "4");
        StoreUtils.injectEntryInStore(store, entry);
        dn = new DN("ou=Apache,ou=Board of Directors,o=Good Times Co.");
        dn.normalize(schemaManager.getNormalizerMapping());
        entry = new DefaultServerEntry(schemaManager, dn);
        entry.add("objectClass", "top", "organizationalUnit");
        entry.add("ou", "Apache");
        entry.add("postalCode", "5");
        entry.add("postOfficeBox", "5");
        StoreUtils.injectEntryInStore(store, entry);
        dn = new DN("cn=Jack Daniels,ou=Engineering,o=Good Times Co.");
        dn.normalize(schemaManager.getNormalizerMapping());
        entry = new DefaultServerEntry(schemaManager, dn);
        entry.add("objectClass", "top", "person", "organizationalPerson");
        entry.add("ou", "Engineering");
        entry.add("cn", "Jack Daniels");
        entry.add("SN", "Daniels");
        entry.add("postalCode", "6");
        entry.add("postOfficeBox", "6");
        StoreUtils.injectEntryInStore(store, entry);
        dn = new DN("commonName=Jim Bean,ou=Apache,ou=Board of Directors,o=Good Times Co.");
        dn.normalize(schemaManager.getNormalizerMapping());
        entry = new DefaultServerEntry(schemaManager, dn);
        entry.add("objectClass", "top", "alias", "extensibleObject");
        entry.add("ou", "Apache");
        entry.add("commonName", "Jim Bean");
        entry.add("aliasedObjectName", "cn=Jim Bean,ou=Sales,o=Good Times Co.");
        StoreUtils.injectEntryInStore(store, entry);
        dn = new DN("commonName=Jim Bean,ou=Board of Directors,o=Good Times Co.");
        dn.normalize(schemaManager.getNormalizerMapping());
        entry = new DefaultServerEntry(schemaManager, dn);
        entry.add("objectClass", "top", "alias", "extensibleObject");
        entry.add("commonName", "Jim Bean");
        entry.add("aliasedObjectName", "cn=Jim Bean,ou=Sales,o=Good Times Co.");
        StoreUtils.injectEntryInStore(store, entry);
        dn = new DN("2.5.4.3=Johnny Walker,ou=Engineering,o=Good Times Co.");
        dn.normalize(schemaManager.getNormalizerMapping());
        entry = new DefaultServerEntry(schemaManager, dn);
        entry.add("objectClass", "top", "alias", "extensibleObject");
        entry.add("ou", "Engineering");
        entry.add("2.5.4.3", "Johnny Walker");
        entry.add("aliasedObjectName", "cn=Johnny Walker,ou=Sales,o=Good Times Co.");
        StoreUtils.injectEntryInStore(store, entry);
    }

    public Entry getAttributes(Store<Object, Long> store, Long id) throws Exception {
        DefaultClientEntry entry = new DefaultClientEntry();
        entry.put("_nDn", store.getEntryDn(id));
        entry.put("_upDn", store.getEntryUpdn(id));
        entry.put("_parent", Long.toString(store.getParentId(id)));
        for (Index<?, Object, Long> index : store.getUserIndices()) {
            IndexCursor<?, Object, Long> list = index.reverseCursor();
            ForwardIndexEntry recordForward = new ForwardIndexEntry();
            recordForward.setId(id);
            list.before(recordForward);
            while (list.next()) {
                IndexEntry rec = (IndexEntry)list.get();
                String val = rec.getValue().toString();
                String attrId = index.getAttribute().getName();
                EntryAttribute attr = entry.get(attrId);
                if (attr == null) {
                    attr = new DefaultClientAttribute(attrId);
                }
                attr.add(val);
                entry.put(attr);
            }
        }
        IndexCursor<String, Object, Long> list = store.getPresenceIndex().reverseCursor();
        ForwardIndexEntry recordForward = new ForwardIndexEntry();
        recordForward.setId(id);
        list.before(recordForward);
        StringBuffer val = new StringBuffer();
        while (list.next()) {
            IndexEntry rec = (IndexEntry)list.get();
            val.append("_existence[");
            val.append(rec.getValue().toString());
            val.append("]");
            String valStr = val.toString();
            EntryAttribute attr = entry.get(valStr);
            if (attr == null) {
                attr = new DefaultClientAttribute(valStr);
            }
            attr.add(rec.getId().toString());
            entry.put(attr);
            val.setLength(0);
        }
        IndexCursor<Long, Object, Long> children = store.getOneLevelIndex().forwardCursor();
        ForwardIndexEntry longRecordForward = new ForwardIndexEntry();
        recordForward.setId(id);
        children.before(longRecordForward);
        DefaultClientAttribute childAttr = new DefaultClientAttribute("_child");
        entry.put(childAttr);
        while (children.next()) {
            IndexEntry rec = (IndexEntry)children.get();
            childAttr.add(rec.getId().toString());
        }
        return entry;
    }

    public static void injectEntryInStore(Store<ServerEntry, Long> store, ServerEntry entry) throws Exception {
        entry.add("entryCSN", CSN_FACTORY.newInstance().toString());
        entry.add("entryUUID", UUID.randomUUID().toString());
        store.add(entry);
    }
}

