/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2.reponse;

import java.util.List;
import org.apache.directory.shared.dsmlv2.DsmlDecorator;
import org.apache.directory.shared.dsmlv2.ParserUtils;
import org.apache.directory.shared.dsmlv2.reponse.LdapResultEnum;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.LdapResultCodec;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapResultDsml
implements DsmlDecorator {
    private LdapResultCodec result;
    private LdapMessageCodec message;

    public LdapResultDsml(LdapResultCodec result, LdapMessageCodec message) {
        this.result = result;
        this.message = message;
    }

    @Override
    public Element toDsml(Element root) {
        List<LdapURL> referals;
        String matchedDN;
        int requestID = this.message.getMessageId();
        if (requestID != 0) {
            root.addAttribute("requestID", "" + requestID);
        }
        if (!(matchedDN = this.result.getMatchedDN()).equals("")) {
            root.addAttribute("matchedDN", matchedDN);
        }
        ParserUtils.addControls(root, this.message.getControls());
        Element resultCodeElement = root.addElement("resultCode");
        resultCodeElement.addAttribute("code", "" + this.result.getResultCode().getResultCode());
        resultCodeElement.addAttribute("descr", LdapResultEnum.getResultCodeDescr(this.result.getResultCode()));
        String errorMessage = this.result.getErrorMessage();
        if (errorMessage != null && !errorMessage.equals("")) {
            Element errorMessageElement = root.addElement("errorMessage");
            errorMessageElement.addText(errorMessage);
        }
        if ((referals = this.result.getReferrals()) != null) {
            for (int i = 0; i < referals.size(); ++i) {
                Element referalElement = root.addElement("referal");
                referalElement.addText(referals.get(i).toString());
            }
        }
        return root;
    }

    public void initReferrals() {
        this.result.initReferrals();
    }

    public String getErrorMessage() {
        return this.result.getErrorMessage();
    }

    public void setErrorMessage(String errorMessage) {
        this.result.setErrorMessage(errorMessage);
    }

    public String getMatchedDN() {
        return this.result.getMatchedDN();
    }

    public void setMatchedDN(DN matchedDN) {
        this.result.setMatchedDN(matchedDN);
    }

    public List<LdapURL> getReferrals() {
        return this.result.getReferrals();
    }

    public void addReferral(LdapURL referral) {
        this.result.addReferral(referral);
    }

    public ResultCodeEnum getResultCode() {
        return this.result.getResultCode();
    }

    public void setResultCode(ResultCodeEnum resultCode) {
        this.result.setResultCode(resultCode);
    }
}

