/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.asn1.codec.stateful.EncoderCallback;
import org.apache.directory.shared.asn1.codec.stateful.EncoderMonitor;
import org.apache.directory.shared.asn1.codec.stateful.StatefulEncoder;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.add.AddRequestCodec;
import org.apache.directory.shared.ldap.message.spi.Provider;
import org.apache.directory.shared.ldap.message.spi.ProviderEncoder;
import org.apache.directory.shared.ldap.message.spi.ProviderException;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapEncoder
implements ProviderEncoder {
    private static Logger log = LoggerFactory.getLogger(LdapEncoder.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    final Provider provider;
    private EncoderCallback encodeCallback;

    public LdapEncoder(Provider provider) {
        this.provider = provider;
        this.encodeCallback = new OutputCallback();
    }

    public void encodeBlocking(Object lock, OutputStream out, Object obj) throws ProviderException {
        try {
            if (IS_DEBUG) {
                log.debug("Encoding this LdapMessage : " + obj);
            }
            ((OutputCallback)this.encodeCallback).attach(out);
            this.encodeCallback.encodeOccurred(null, ((LdapMessageCodec)obj).encode());
        }
        catch (EncoderException e) {
            log.error(I18n.err("ERR_04065", obj, e.getLocalizedMessage()));
            ProviderException pe = new ProviderException(this.provider, I18n.err("ERR_04065", obj, e.getLocalizedMessage()));
            throw pe;
        }
    }

    public ByteBuffer encodeBlocking(Object obj) throws ProviderException {
        try {
            if (IS_DEBUG) {
                log.debug("Encoding this LdapMessage : " + obj);
            }
            ByteBuffer pdu = ((LdapMessageCodec)obj).encode();
            if (IS_DEBUG) {
                log.debug("Encoded PDU : " + StringTools.dumpBytes(pdu.array()));
            }
            pdu.flip();
            return pdu;
        }
        catch (EncoderException e) {
            log.error(I18n.err("ERR_04065", obj, e.getLocalizedMessage()));
            ProviderException pe = new ProviderException(this.provider, I18n.err("ERR_04065", obj, e.getLocalizedMessage()));
            throw pe;
        }
    }

    public byte[] encodeToArray(Object obj) throws ProviderException {
        try {
            if (IS_DEBUG) {
                log.debug("Encoding this LdapMessage : " + obj);
            }
            byte[] pdu = ((LdapMessageCodec)obj).encode().array();
            if (IS_DEBUG) {
                log.debug("Encoded PDU : " + StringTools.dumpBytes(pdu));
            }
            return pdu;
        }
        catch (EncoderException e) {
            log.error(I18n.err("ERR_04065", obj, e.getLocalizedMessage()));
            ProviderException pe = new ProviderException(this.provider, I18n.err("ERR_04065", obj, e.getLocalizedMessage()));
            throw pe;
        }
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void encode(Object obj) throws EncoderException {
        ByteBuffer encoded = this.encodeBlocking(obj);
        this.encodeCallback.encodeOccurred(null, encoded);
    }

    public void setCallback(EncoderCallback cb) {
        this.encodeCallback = cb;
    }

    public void setEncoderMonitor(EncoderMonitor monitor) {
    }

    private static ByteBuffer encodeAsn1(AddRequestCodec addRequest) {
        return null;
    }

    private static ByteBuffer encodeAsn1(LdapMessageCodec message) throws EncoderException {
        ByteBuffer buffer = null;
        switch (message.getMessageType()) {
            case ABANDON_REQUEST: {
                return LdapEncoder.encodeAsn1(message);
            }
        }
        return buffer;
    }

    class OutputCallback
    implements EncoderCallback {
        private WritableByteChannel channel = null;

        OutputCallback() {
        }

        public void encodeOccurred(StatefulEncoder encoder, Object encoded) {
            try {
                ((ByteBuffer)encoded).flip();
                this.channel.write((ByteBuffer)encoded);
            }
            catch (IOException e) {
                ProviderException pe = new ProviderException(LdapEncoder.this.provider, I18n.err("ERR_04065", "", e.getLocalizedMessage()));
                throw pe;
            }
        }

        void attach(WritableByteChannel channel) {
            this.channel = channel;
        }

        void attach(OutputStream out) {
            this.channel = Channels.newChannel(out);
        }
    }
}

