/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.bind;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.codec.bind.LdapAuthentication;
import org.apache.directory.shared.ldap.codec.bind.SaslCredentials;
import org.apache.directory.shared.ldap.codec.bind.SimpleAuthentication;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.util.StringTools;

public class BindRequestCodec
extends LdapMessageCodec {
    private int version;
    private DN name;
    private LdapAuthentication authentication;
    private int bindRequestLength;

    public MessageTypeEnum getMessageType() {
        return MessageTypeEnum.BIND_REQUEST;
    }

    public String getMessageTypeName() {
        return "BIND_REQUEST";
    }

    public LdapAuthentication getAuthentication() {
        return this.authentication;
    }

    public SimpleAuthentication getSimpleAuthentication() {
        return (SimpleAuthentication)this.authentication;
    }

    public SaslCredentials getSaslAuthentication() {
        return (SaslCredentials)this.authentication;
    }

    public void setAuthentication(LdapAuthentication authentication) {
        this.authentication = authentication;
    }

    public DN getName() {
        return this.name;
    }

    public void setName(DN name) {
        this.name = name;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isLdapV3() {
        return this.version == 3;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    protected int computeLengthProtocolOp() {
        this.bindRequestLength = 3;
        this.bindRequestLength += 1 + TLV.getNbBytes(DN.getNbBytes(this.name)) + DN.getNbBytes(this.name);
        this.bindRequestLength += this.authentication.computeLength();
        return 1 + TLV.getNbBytes(this.bindRequestLength) + this.bindRequestLength;
    }

    protected void encodeProtocolOp(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)96);
            buffer.put(TLV.getBytes(this.bindRequestLength));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err("ERR_04005", new Object[0]));
        }
        Value.encode(buffer, this.version);
        Value.encode(buffer, DN.getBytes(this.name));
        this.authentication.encode(buffer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    BindRequest\n");
        sb.append("        Version : '").append(this.version).append("'\n");
        if (null == this.name || StringTools.isEmpty(this.name.getNormName())) {
            sb.append("        Name : anonymous");
        } else {
            sb.append("        Name : '").append(this.name).append("'\n");
            if (this.authentication instanceof SimpleAuthentication) {
                sb.append("        Simple authentication : '").append(this.authentication).append('\'');
            } else {
                sb.append(this.authentication);
            }
        }
        return this.toString(sb.toString());
    }
}

