/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.controls.replication.syncInfoValue;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.controls.AbstractControl;
import org.apache.directory.shared.ldap.codec.controls.replication.syncInfoValue.SyncInfoValueControlDecoder;
import org.apache.directory.shared.ldap.codec.controls.replication.syncInfoValue.SyncInfoValueTags;
import org.apache.directory.shared.ldap.message.control.replication.SynchronizationInfoEnum;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncInfoValueControl
extends AbstractControl {
    public static final String CONTROL_OID = "1.3.6.1.4.1.4203.1.9.1.4";
    private SynchronizationInfoEnum type;
    private byte[] cookie;
    private boolean refreshDone = true;
    private boolean refreshDeletes = false;
    private List<byte[]> syncUUIDs;
    private int syncUUIDsLength;
    private int syncInfoValueLength;

    public SyncInfoValueControl(SynchronizationInfoEnum type) {
        super(CONTROL_OID);
        this.decoder = new SyncInfoValueControlDecoder();
        this.type = type;
        if (type == SynchronizationInfoEnum.SYNC_ID_SET) {
            this.syncUUIDs = new ArrayList<byte[]>();
        }
    }

    public SynchronizationInfoEnum getType() {
        return this.type;
    }

    public void setType(SynchronizationInfoEnum type) {
        this.type = type;
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public void setCookie(byte[] cookie) {
        this.cookie = cookie;
    }

    public boolean isRefreshDone() {
        return this.refreshDone;
    }

    public void setRefreshDone(boolean refreshDone) {
        this.refreshDone = refreshDone;
    }

    public boolean isRefreshDeletes() {
        return this.refreshDeletes;
    }

    public void setRefreshDeletes(boolean refreshDeletes) {
        this.refreshDeletes = refreshDeletes;
    }

    public List<byte[]> getSyncUUIDs() {
        return this.syncUUIDs;
    }

    public void setSyncUUIDs(List<byte[]> syncUUIDs) {
        this.syncUUIDs = syncUUIDs;
    }

    public void addSyncUUID(byte[] syncUUID) {
        this.syncUUIDs.add(syncUUID);
    }

    @Override
    public int computeLength() {
        this.syncInfoValueLength = 0;
        switch (this.type) {
            case NEW_COOKIE: {
                this.syncInfoValueLength = this.cookie != null ? 1 + TLV.getNbBytes(this.cookie.length) + this.cookie.length : 2;
                this.valueLength = this.syncInfoValueLength;
                return super.computeLength(this.valueLength);
            }
            case REFRESH_DELETE: 
            case REFRESH_PRESENT: {
                if (this.cookie != null) {
                    this.syncInfoValueLength = 1 + TLV.getNbBytes(this.cookie.length) + this.cookie.length;
                }
                if (!this.refreshDone) {
                    this.syncInfoValueLength += 3;
                }
                this.valueLength = 1 + TLV.getNbBytes(this.syncInfoValueLength) + this.syncInfoValueLength;
                return super.computeLength(this.valueLength);
            }
            case SYNC_ID_SET: {
                if (this.cookie != null) {
                    this.syncInfoValueLength = 1 + TLV.getNbBytes(this.cookie.length) + this.cookie.length;
                }
                if (this.refreshDeletes) {
                    this.syncInfoValueLength += 3;
                }
                this.syncUUIDsLength = 0;
                if (this.syncUUIDs.size() != 0) {
                    for (byte[] syncUUID : this.syncUUIDs) {
                        int uuidLength = 1 + TLV.getNbBytes(syncUUID.length) + syncUUID.length;
                        this.syncUUIDsLength += uuidLength;
                    }
                }
                this.syncInfoValueLength += 1 + TLV.getNbBytes(this.syncUUIDsLength) + this.syncUUIDsLength;
                this.valueLength = 1 + TLV.getNbBytes(this.syncInfoValueLength) + this.syncInfoValueLength;
                return super.computeLength(this.valueLength);
            }
        }
        return 1 + TLV.getNbBytes(this.syncInfoValueLength) + this.syncInfoValueLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err("ERR_04023", new Object[0]));
        }
        super.encode(buffer);
        buffer.put((byte)4);
        buffer.put(TLV.getBytes(this.valueLength));
        switch (this.type) {
            case NEW_COOKIE: {
                buffer.put((byte)SyncInfoValueTags.NEW_COOKIE_TAG.getValue());
                if (this.cookie == null || this.cookie.length == 0) {
                    buffer.put((byte)0);
                    break;
                }
                buffer.put(TLV.getBytes(this.cookie.length));
                buffer.put(this.cookie);
                break;
            }
            case REFRESH_DELETE: {
                buffer.put((byte)SyncInfoValueTags.REFRESH_DELETE_TAG.getValue());
                buffer.put(TLV.getBytes(this.syncInfoValueLength));
                if (this.cookie != null) {
                    Value.encode(buffer, this.cookie);
                }
                if (this.refreshDone) break;
                Value.encode(buffer, this.refreshDone);
                break;
            }
            case REFRESH_PRESENT: {
                buffer.put((byte)SyncInfoValueTags.REFRESH_PRESENT_TAG.getValue());
                buffer.put(TLV.getBytes(this.syncInfoValueLength));
                if (this.cookie != null) {
                    Value.encode(buffer, this.cookie);
                }
                if (this.refreshDone) break;
                Value.encode(buffer, this.refreshDone);
                break;
            }
            case SYNC_ID_SET: {
                buffer.put((byte)SyncInfoValueTags.SYNC_ID_SET_TAG.getValue());
                buffer.put(TLV.getBytes(this.syncInfoValueLength));
                if (this.cookie != null) {
                    Value.encode(buffer, this.cookie);
                }
                if (this.refreshDeletes) {
                    Value.encode(buffer, this.refreshDeletes);
                }
                buffer.put((byte)49);
                buffer.put(TLV.getBytes(this.syncUUIDsLength));
                if (this.syncUUIDs.size() == 0) break;
                for (byte[] syncUUID : this.syncUUIDs) {
                    Value.encode(buffer, syncUUID);
                }
                break;
            }
        }
        return buffer;
    }

    @Override
    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                switch (this.type) {
                    case NEW_COOKIE: {
                        buffer.put((byte)SyncInfoValueTags.NEW_COOKIE_TAG.getValue());
                        if (this.cookie == null || this.cookie.length == 0) {
                            buffer.put((byte)0);
                            break;
                        }
                        buffer.put(TLV.getBytes(this.cookie.length));
                        buffer.put(this.cookie);
                        break;
                    }
                    case REFRESH_DELETE: {
                        buffer.put((byte)SyncInfoValueTags.REFRESH_DELETE_TAG.getValue());
                        buffer.put(TLV.getBytes(this.syncInfoValueLength));
                        if (this.cookie != null) {
                            Value.encode(buffer, this.cookie);
                        }
                        if (this.refreshDone) break;
                        Value.encode(buffer, this.refreshDone);
                        break;
                    }
                    case REFRESH_PRESENT: {
                        buffer.put((byte)SyncInfoValueTags.REFRESH_PRESENT_TAG.getValue());
                        buffer.put(TLV.getBytes(this.syncInfoValueLength));
                        if (this.cookie != null) {
                            Value.encode(buffer, this.cookie);
                        }
                        if (this.refreshDone) break;
                        Value.encode(buffer, this.refreshDone);
                        break;
                    }
                    case SYNC_ID_SET: {
                        buffer.put((byte)SyncInfoValueTags.SYNC_ID_SET_TAG.getValue());
                        buffer.put(TLV.getBytes(this.syncInfoValueLength));
                        if (this.cookie != null) {
                            Value.encode(buffer, this.cookie);
                        }
                        if (this.refreshDeletes) {
                            Value.encode(buffer, this.refreshDeletes);
                        }
                        buffer.put((byte)49);
                        buffer.put(TLV.getBytes(this.syncUUIDsLength));
                        if (this.syncUUIDs.size() == 0) break;
                        for (byte[] syncUUID : this.syncUUIDs) {
                            Value.encode(buffer, syncUUID);
                        }
                        break;
                    }
                }
                this.value = buffer.array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    SyncInfoValue control :\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        switch (this.type) {
            case NEW_COOKIE: {
                sb.append("        newCookie : '").append(StringTools.dumpBytes(this.cookie)).append("'\n");
                break;
            }
            case REFRESH_DELETE: {
                sb.append("        refreshDelete : \n");
                if (this.cookie != null) {
                    sb.append("            cookie : '").append(StringTools.dumpBytes(this.cookie)).append("'\n");
                }
                sb.append("            refreshDone : ").append(this.refreshDone).append('\n');
                break;
            }
            case REFRESH_PRESENT: {
                sb.append("        refreshPresent : \n");
                if (this.cookie != null) {
                    sb.append("            cookie : '").append(StringTools.dumpBytes(this.cookie)).append("'\n");
                }
                sb.append("            refreshDone : ").append(this.refreshDone).append('\n');
                break;
            }
            case SYNC_ID_SET: {
                sb.append("        syncIdSet : \n");
                if (this.cookie != null) {
                    sb.append("            cookie : '").append(StringTools.dumpBytes(this.cookie)).append("'\n");
                }
                sb.append("            refreshDeletes : ").append(this.refreshDeletes).append('\n');
                sb.append("            syncUUIDS : ");
                if (this.syncUUIDs.size() != 0) {
                    boolean isFirst = true;
                    for (byte[] syncUUID : this.syncUUIDs) {
                        if (isFirst) {
                            isFirst = false;
                        } else {
                            sb.append(", ");
                        }
                        sb.append(syncUUID);
                    }
                    sb.append('\n');
                    break;
                }
                sb.append("empty\n");
            }
        }
        return sb.toString();
    }
}

