/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.del;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.name.DN;

public class DelRequestCodec
extends LdapMessageCodec {
    private DN entry;

    public MessageTypeEnum getMessageType() {
        return MessageTypeEnum.DEL_REQUEST;
    }

    public String getMessageTypeName() {
        return "DEL_REQUEST";
    }

    public DN getEntry() {
        return this.entry;
    }

    public void setEntry(DN entry) {
        this.entry = entry;
    }

    protected int computeLengthProtocolOp() {
        return 1 + TLV.getNbBytes(DN.getNbBytes(this.entry)) + DN.getNbBytes(this.entry);
    }

    protected void encodeProtocolOp(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)74);
            buffer.put(TLV.getBytes(DN.getNbBytes(this.entry)));
            buffer.put(DN.getBytes(this.entry));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err("ERR_04005", new Object[0]));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Del request\n");
        sb.append("        Entry : '").append(this.entry).append('\'');
        return this.toString(sb.toString());
    }
}

