/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.extended.operations.cancel;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.IntegerDecoder;
import org.apache.directory.shared.asn1.util.IntegerDecoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.extended.operations.cancel.Cancel;
import org.apache.directory.shared.ldap.codec.extended.operations.cancel.CancelContainer;
import org.apache.directory.shared.ldap.codec.extended.operations.cancel.CancelStatesEnum;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CancelGrammar
extends AbstractGrammar {
    static final Logger LOG = LoggerFactory.getLogger(CancelGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static IGrammar instance = new CancelGrammar();

    private CancelGrammar() {
        this.name = CancelGrammar.class.getName();
        this.statesEnum = CancelStatesEnum.getInstance();
        this.transitions = new GrammarTransition[3][256];
        this.transitions[0][48] = new GrammarTransition(0, 1, 48, new GrammarAction("Init Cancel"){

            public void action(IAsn1Container container) {
                CancelContainer cancelContainer = (CancelContainer)container;
                Cancel cancel = new Cancel();
                cancelContainer.setCancel(cancel);
            }
        });
        this.transitions[1][2] = new GrammarTransition(1, 2, 2, new GrammarAction("Stores CancelId"){

            public void action(IAsn1Container container) throws DecoderException {
                CancelContainer cancelContainer = (CancelContainer)container;
                Value value = cancelContainer.getCurrentTLV().getValue();
                try {
                    int cancelId = IntegerDecoder.parse(value, 0, Integer.MAX_VALUE);
                    if (IS_DEBUG) {
                        LOG.debug("CancelId = " + cancelId);
                    }
                    cancelContainer.getCancel().setCancelId(cancelId);
                    cancelContainer.grammarEndAllowed(true);
                }
                catch (IntegerDecoderException e) {
                    String msg = I18n.err("ERR_04031", StringTools.dumpBytes(value.getData()));
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

