/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.LdapResponseCodec;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;

public class SearchResultDoneCodec
extends LdapResponseCodec {
    public MessageTypeEnum getMessageType() {
        return MessageTypeEnum.SEARCH_RESULT_DONE;
    }

    public String getMessageTypeName() {
        return "SEARCH_RESULT_DONE";
    }

    protected int computeLengthProtocolOp() {
        int ldapResponseLength = this.computeLdapResultLength();
        return 1 + TLV.getNbBytes(ldapResponseLength) + ldapResponseLength;
    }

    protected void encodeProtocolOp(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)101);
            buffer.put(TLV.getBytes(this.getLdapResponseLength()));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err("ERR_04005", new Object[0]));
        }
        super.encode(buffer);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Search Result Done\n");
        sb.append(super.toString());
        return sb.toString();
    }
}

