/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.csn;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.csn.InvalidCSNException;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Csn
implements Serializable,
Comparable<Csn> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(Csn.class);
    private final long timestamp;
    private final int replicaId;
    private final int operationNumber;
    private final int changeCount;
    private transient String csnStr;
    private transient byte[] bytes;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final String[] PADDING_6 = new String[]{"00000", "0000", "000", "00", "0", ""};
    private static final String[] PADDING_3 = new String[]{"00", "0", ""};

    public Csn(long timestamp, int changeCount, int replicaId, int operationNumber) {
        this.timestamp = timestamp;
        this.replicaId = replicaId;
        this.operationNumber = operationNumber;
        this.changeCount = changeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Csn(String value) throws InvalidCSNException {
        if (StringTools.isEmpty(value)) {
            String message = I18n.err("ERR_04114", new Object[0]);
            LOG.error(message);
            throw new InvalidCSNException(message);
        }
        if (value.length() != 40) {
            String message = I18n.err("ERR_04115", new Object[0]);
            LOG.error(message);
            throw new InvalidCSNException(message);
        }
        int sepTS = value.indexOf(35);
        if (sepTS < 0) {
            String message = I18n.err("ERR_04116", new Object[0]);
            LOG.error(message);
            throw new InvalidCSNException(message);
        }
        String timestampStr = value.substring(0, sepTS).trim();
        if (timestampStr.length() != 22) {
            String message = I18n.err("ERR_04117", new Object[0]);
            LOG.error(message);
            throw new InvalidCSNException(message);
        }
        String realTimestamp = timestampStr.substring(0, 14);
        long tempTimestamp = 0L;
        SimpleDateFormat simpleDateFormat = sdf;
        synchronized (simpleDateFormat) {
            try {
                tempTimestamp = sdf.parse(realTimestamp).getTime();
            }
            catch (ParseException pe) {
                String message = I18n.err("ERR_04118", timestampStr);
                LOG.error(message);
                throw new InvalidCSNException(message);
            }
        }
        int millis = 0;
        try {
            millis = Integer.valueOf(timestampStr.substring(15, 21));
        }
        catch (NumberFormatException nfe) {
            String message = I18n.err("ERR_04119", new Object[0]);
            LOG.error(message);
            throw new InvalidCSNException(message);
        }
        this.timestamp = tempTimestamp += (long)(millis / 1000);
        int sepCC = value.indexOf(35, sepTS + 1);
        if (sepCC < 0) {
            String message = I18n.err("ERR_04110", value);
            LOG.error(message);
            throw new InvalidCSNException(message);
        }
        String changeCountStr = value.substring(sepTS + 1, sepCC).trim();
        try {
            this.changeCount = Integer.parseInt(changeCountStr, 16);
        }
        catch (NumberFormatException nfe) {
            String message = I18n.err("ERR_04121", changeCountStr);
            LOG.error(message);
            throw new InvalidCSNException(message);
        }
        int sepRI = value.indexOf(35, sepCC + 1);
        if (sepRI < 0) {
            String message = I18n.err("ERR_04122", value);
            LOG.error(message);
            throw new InvalidCSNException(message);
        }
        String replicaIdStr = value.substring(sepCC + 1, sepRI).trim();
        if (StringTools.isEmpty(replicaIdStr)) {
            String message = I18n.err("ERR_04123", new Object[0]);
            LOG.error(message);
            throw new InvalidCSNException(message);
        }
        try {
            this.replicaId = Integer.parseInt(replicaIdStr, 16);
        }
        catch (NumberFormatException nfe) {
            String message = I18n.err("ERR_04124", replicaIdStr);
            LOG.error(message);
            throw new InvalidCSNException(message);
        }
        if (sepCC == value.length()) {
            String message = I18n.err("ERR_04125", new Object[0]);
            LOG.error(message);
            throw new InvalidCSNException(message);
        }
        String operationNumberStr = value.substring(sepRI + 1).trim();
        try {
            this.operationNumber = Integer.parseInt(operationNumberStr, 16);
        }
        catch (NumberFormatException nfe) {
            String message = I18n.err("ERR_04126", operationNumberStr);
            LOG.error(message);
            throw new InvalidCSNException(message);
        }
        this.csnStr = value;
        this.bytes = StringTools.getBytesUtf8(this.csnStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValid(String value) {
        if (StringTools.isEmpty(value)) {
            return false;
        }
        if (value.length() != 40) {
            return false;
        }
        int sepTS = value.indexOf(35);
        if (sepTS < 0) {
            return false;
        }
        String timestampStr = value.substring(0, sepTS).trim();
        if (timestampStr.length() != 22) {
            return false;
        }
        String realTimestamp = timestampStr.substring(0, 14);
        SimpleDateFormat simpleDateFormat = sdf;
        synchronized (simpleDateFormat) {
            try {
                sdf.parse(realTimestamp).getTime();
            }
            catch (ParseException pe) {
                return false;
            }
        }
        String millisStr = timestampStr.substring(15, 21);
        if (StringTools.isEmpty(millisStr)) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            if (StringTools.isDigit(millisStr, i)) continue;
            return false;
        }
        try {
            Integer.valueOf(millisStr);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        int sepCC = value.indexOf(35, sepTS + 1);
        if (sepCC < 0) {
            return false;
        }
        String changeCountStr = value.substring(sepTS + 1, sepCC).trim();
        if (StringTools.isEmpty(changeCountStr)) {
            return false;
        }
        if (changeCountStr.length() != 6) {
            return false;
        }
        try {
            for (int i = 0; i < 6; ++i) {
                if (StringTools.isHex(changeCountStr, i)) continue;
                return false;
            }
            Integer.parseInt(changeCountStr, 16);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        int sepRI = value.indexOf(35, sepCC + 1);
        if (sepRI < 0) {
            return false;
        }
        String replicaIdStr = value.substring(sepCC + 1, sepRI).trim();
        if (StringTools.isEmpty(replicaIdStr)) {
            return false;
        }
        if (replicaIdStr.length() != 3) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (StringTools.isHex(replicaIdStr, i)) continue;
            return false;
        }
        try {
            Integer.parseInt(replicaIdStr, 16);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        if (sepCC == value.length()) {
            return false;
        }
        String operationNumberStr = value.substring(sepRI + 1).trim();
        if (operationNumberStr.length() != 6) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            if (StringTools.isHex(operationNumberStr, i)) continue;
            return false;
        }
        try {
            Integer.parseInt(operationNumberStr, 16);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    Csn(byte[] value) {
        this.csnStr = StringTools.utf8ToString(value);
        Csn csn = new Csn(this.csnStr);
        this.timestamp = csn.timestamp;
        this.changeCount = csn.changeCount;
        this.replicaId = csn.replicaId;
        this.operationNumber = csn.operationNumber;
        this.bytes = StringTools.getBytesUtf8(this.csnStr);
    }

    public byte[] getBytes() {
        if (this.bytes == null) {
            this.bytes = StringTools.getBytesUtf8(this.csnStr);
        }
        byte[] copy = new byte[this.bytes.length];
        System.arraycopy(this.bytes, 0, copy, 0, this.bytes.length);
        return copy;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getChangeCount() {
        return this.changeCount;
    }

    public int getReplicaId() {
        return this.replicaId;
    }

    public int getOperationNumber() {
        return this.operationNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.csnStr == null) {
            StringBuilder buf = new StringBuilder(40);
            SimpleDateFormat simpleDateFormat = sdf;
            synchronized (simpleDateFormat) {
                buf.append(sdf.format(new Date(this.timestamp)));
            }
            long millis = this.timestamp % 1000L * 1000L;
            String millisStr = Long.toString(millis);
            buf.append('.').append(PADDING_6[millisStr.length() - 1]).append(millisStr).append("Z#");
            String countStr = Integer.toHexString(this.changeCount);
            buf.append(PADDING_6[countStr.length() - 1]).append(countStr);
            buf.append('#');
            String replicaIdStr = Integer.toHexString(this.replicaId);
            buf.append(PADDING_3[replicaIdStr.length() - 1]).append(replicaIdStr);
            buf.append('#');
            String operationNumberStr = Integer.toHexString(this.operationNumber);
            buf.append(PADDING_6[operationNumberStr.length() - 1]).append(operationNumberStr);
            this.csnStr = buf.toString();
        }
        return this.csnStr;
    }

    public int hashCode() {
        int h = 37;
        h = h * 17 + (int)(this.timestamp ^ this.timestamp >>> 32);
        h = h * 17 + this.changeCount;
        h = h * 17 + this.replicaId;
        h = h * 17 + this.operationNumber;
        return h;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Csn)) {
            return false;
        }
        Csn that = (Csn)o;
        return this.timestamp == that.timestamp && this.changeCount == that.changeCount && this.replicaId == that.replicaId && this.operationNumber == that.operationNumber;
    }

    @Override
    public int compareTo(Csn csn) {
        int replicaIdCompareResult;
        if (csn == null) {
            return 1;
        }
        if (this.timestamp < csn.timestamp) {
            return -1;
        }
        if (this.timestamp > csn.timestamp) {
            return 1;
        }
        if (this.changeCount < csn.changeCount) {
            return -1;
        }
        if (this.changeCount > csn.changeCount) {
            return 1;
        }
        int n = this.replicaId < csn.replicaId ? -1 : (replicaIdCompareResult = this.replicaId > csn.replicaId ? 1 : 0);
        if (replicaIdCompareResult != 0) {
            return replicaIdCompareResult;
        }
        if (this.operationNumber < csn.operationNumber) {
            return -1;
        }
        if (this.operationNumber > csn.operationNumber) {
            return 1;
        }
        return 0;
    }
}

