/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.ldif;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.StringValue;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientModification;
import org.apache.directory.shared.ldap.entry.client.DefaultClientAttribute;
import org.apache.directory.shared.ldap.entry.client.DefaultClientEntry;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.ldif.ChangeType;
import org.apache.directory.shared.ldap.ldif.LdifUtils;
import org.apache.directory.shared.ldap.message.control.Control;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdifEntry
implements Cloneable,
Externalizable {
    private static final long serialVersionUID = 2L;
    public static final Modification[] EMPTY_MODS = new Modification[0];
    private ChangeType changeType = ChangeType.Add;
    private List<Modification> modificationList = new LinkedList<Modification>();
    private Map<String, Modification> modificationItems = new HashMap<String, Modification>();
    private String newSuperior;
    private String newRdn;
    private boolean deleteOldRdn;
    private Entry entry = new DefaultClientEntry(null);
    private Control control = null;

    public void setDn(DN dn) {
        this.entry.setDn((DN)dn.clone());
    }

    public void setDn(String dn) throws LdapInvalidDnException {
        this.entry.setDn(new DN(dn));
    }

    public void setChangeType(ChangeType changeType) {
        this.changeType = changeType;
    }

    public void setChangeType(String changeType) {
        if ("add".equals(changeType)) {
            this.changeType = ChangeType.Add;
        } else if ("modify".equals(changeType)) {
            this.changeType = ChangeType.Modify;
        } else if ("moddn".equals(changeType)) {
            this.changeType = ChangeType.ModDn;
        } else if ("modrdn".equals(changeType)) {
            this.changeType = ChangeType.ModRdn;
        } else if ("delete".equals(changeType)) {
            this.changeType = ChangeType.Delete;
        }
    }

    public void addModificationItem(Modification modification) {
        if (this.changeType == ChangeType.Modify) {
            this.modificationList.add(modification);
            this.modificationItems.put(modification.getAttribute().getId(), modification);
        }
    }

    public void addModificationItem(ModificationOperation modOp, EntryAttribute attr) {
        if (this.changeType == ChangeType.Modify) {
            ClientModification item = new ClientModification(modOp, attr);
            this.modificationList.add(item);
            this.modificationItems.put(attr.getId(), item);
        }
    }

    public void addModificationItem(ModificationOperation modOp, String id, Object value) {
        if (this.changeType == ChangeType.Modify) {
            EntryAttribute attr = null;
            if (value == null) {
                value = new StringValue((String)null);
                attr = new DefaultClientAttribute(id, (Value)value);
            } else {
                attr = (EntryAttribute)value;
            }
            ClientModification item = new ClientModification(modOp, attr);
            this.modificationList.add(item);
            this.modificationItems.put(id, item);
        }
    }

    public void addAttribute(EntryAttribute attr) throws LdapException {
        this.entry.put(attr);
    }

    public void addAttribute(String id, Object value) throws LdapException {
        if (value instanceof String) {
            this.entry.add(id, (String)value);
        } else {
            this.entry.add(id, new byte[][]{(byte[])value});
        }
    }

    public List<EntryAttribute> removeAttribute(String ... ids) {
        if (this.entry.containsAttribute(ids)) {
            return this.entry.removeAttributes(ids);
        }
        return null;
    }

    public void putAttribute(String id, Object value) throws LdapException {
        if (value instanceof String) {
            this.entry.add(id, (String)value);
        } else {
            this.entry.add(id, new byte[][]{(byte[])value});
        }
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public List<Modification> getModificationItems() {
        return this.modificationList;
    }

    public Modification[] getModificationItemsArray() {
        return this.modificationList.toArray(EMPTY_MODS);
    }

    public DN getDn() {
        return this.entry.getDn();
    }

    public int size() {
        return this.modificationList.size();
    }

    public EntryAttribute get(String attributeId) {
        if ("dn".equalsIgnoreCase(attributeId)) {
            return new DefaultClientAttribute("dn", this.entry.getDn().getName());
        }
        return this.entry.get(attributeId);
    }

    public Entry getEntry() {
        if (this.isEntry()) {
            return this.entry;
        }
        return null;
    }

    public boolean isDeleteOldRdn() {
        return this.deleteOldRdn;
    }

    public void setDeleteOldRdn(boolean deleteOldRdn) {
        this.deleteOldRdn = deleteOldRdn;
    }

    public String getNewRdn() {
        return this.newRdn;
    }

    public void setNewRdn(String newRdn) {
        this.newRdn = newRdn;
    }

    public String getNewSuperior() {
        return this.newSuperior;
    }

    public void setNewSuperior(String newSuperior) {
        this.newSuperior = newSuperior;
    }

    public boolean isChangeAdd() {
        return this.changeType == ChangeType.Add;
    }

    public boolean isChangeDelete() {
        return this.changeType == ChangeType.Delete;
    }

    public boolean isChangeModDn() {
        return this.changeType == ChangeType.ModDn;
    }

    public boolean isChangeModRdn() {
        return this.changeType == ChangeType.ModRdn;
    }

    public boolean isChangeModify() {
        return this.changeType == ChangeType.Modify;
    }

    public boolean isEntry() {
        return this.changeType == ChangeType.Add;
    }

    public Control getControl() {
        return this.control;
    }

    public void setControl(Control control) {
        this.control = control;
    }

    public LdifEntry clone() throws CloneNotSupportedException {
        LdifEntry clone = (LdifEntry)super.clone();
        if (this.modificationList != null) {
            for (Modification modif : this.modificationList) {
                ClientModification modifClone = new ClientModification(modif.getOperation(), modif.getAttribute().clone());
                clone.modificationList.add(modifClone);
            }
        }
        if (this.modificationItems != null) {
            for (String key : this.modificationItems.keySet()) {
                Modification modif = this.modificationItems.get(key);
                ClientModification modifClone = new ClientModification(modif.getOperation(), modif.getAttribute().clone());
                clone.modificationItems.put(key, modifClone);
            }
        }
        if (this.entry != null) {
            clone.entry = this.entry.clone();
        }
        return clone;
    }

    private String dumpAttributes() {
        StringBuffer sb = new StringBuffer();
        for (EntryAttribute attribute : this.entry) {
            if (attribute == null) {
                sb.append("        Null attribute\n");
                continue;
            }
            sb.append("        ").append(attribute.getId()).append(":\n");
            for (Value value : attribute) {
                if (!value.isBinary()) {
                    sb.append("            ").append(value.getString()).append('\n');
                    continue;
                }
                sb.append("            ").append(StringTools.dumpBytes(value.getBytes())).append('\n');
            }
        }
        return sb.toString();
    }

    private String dumpModificationItems() {
        StringBuffer sb = new StringBuffer();
        for (Modification modif : this.modificationList) {
            sb.append("            Operation: ");
            switch (modif.getOperation()) {
                case ADD_ATTRIBUTE: {
                    sb.append("ADD\n");
                    break;
                }
                case REMOVE_ATTRIBUTE: {
                    sb.append("REMOVE\n");
                    break;
                }
                case REPLACE_ATTRIBUTE: {
                    sb.append("REPLACE \n");
                    break;
                }
            }
            EntryAttribute attribute = modif.getAttribute();
            sb.append("                Attribute: ").append(attribute.getId()).append('\n');
            if (attribute.size() == 0) continue;
            for (Value value : attribute) {
                if (!value.isBinary()) {
                    sb.append("                ").append(value.getString()).append('\n');
                    continue;
                }
                sb.append("                ").append(StringTools.dumpBytes(value.getBytes())).append('\n');
            }
        }
        return sb.toString();
    }

    public String toString() {
        try {
            return LdifUtils.convertToLdif(this);
        }
        catch (LdapException ne) {
            return null;
        }
    }

    public int hashCode() {
        int result = 37;
        if (this.entry.getDn() != null) {
            result = result * 17 + this.entry.getDn().hashCode();
        }
        if (this.changeType != null) {
            result = result * 17 + this.changeType.hashCode();
            switch (this.changeType) {
                case Add: {
                    if (this.entry == null) break;
                    result = result * 17 + this.entry.hashCode();
                    break;
                }
                case Delete: {
                    break;
                }
                case Modify: {
                    if (this.modificationList == null) break;
                    result = result * 17 + ((Object)this.modificationList).hashCode();
                    for (Modification modification : this.modificationList) {
                        result = result * 17 + modification.hashCode();
                    }
                    break;
                }
                case ModDn: 
                case ModRdn: {
                    result = result * 17 + (this.deleteOldRdn ? 1 : -1);
                    if (this.newRdn != null) {
                        result = result * 17 + this.newRdn.hashCode();
                    }
                    if (this.newSuperior == null) break;
                    result = result * 17 + this.newSuperior.hashCode();
                    break;
                }
            }
        }
        if (this.control != null) {
            result = result * 17 + this.control.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        DN dnEntry;
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof LdifEntry)) {
            return false;
        }
        LdifEntry otherEntry = (LdifEntry)o;
        DN thisDn = this.entry.getDn();
        if (!thisDn.equals(dnEntry = otherEntry.getDn())) {
            return false;
        }
        if (this.changeType != otherEntry.changeType) {
            return false;
        }
        switch (this.changeType) {
            case Add: {
                if (this.entry == null) {
                    if (otherEntry.entry == null) break;
                    return false;
                }
                if (otherEntry.entry == null) {
                    return false;
                }
                if (this.entry.size() != otherEntry.entry.size()) {
                    return false;
                }
                if (this.entry.equals(otherEntry.entry)) break;
                return false;
            }
            case Delete: {
                break;
            }
            case Modify: {
                if (this.modificationList == null) {
                    if (otherEntry.modificationList == null) break;
                    return false;
                }
                if (otherEntry.modificationList == null) {
                    return false;
                }
                if (this.modificationList.size() != otherEntry.modificationList.size()) {
                    return false;
                }
                int i = 0;
                for (Modification modification : this.modificationList) {
                    if (!modification.equals(otherEntry.modificationList.get(i))) {
                        return false;
                    }
                    ++i;
                }
                break;
            }
            case ModDn: 
            case ModRdn: {
                if (this.deleteOldRdn != otherEntry.deleteOldRdn) {
                    return false;
                }
                try {
                    RDN thisNewRdn = new RDN(this.newRdn);
                    RDN entryNewRdn = new RDN(otherEntry.newRdn);
                    if (!thisNewRdn.equals(entryNewRdn)) {
                        return false;
                    }
                }
                catch (LdapInvalidDnException ine) {
                    return false;
                }
                try {
                    DN thisNewSuperior = new DN(this.newSuperior);
                    DN entryNewSuperior = new DN(otherEntry.newSuperior);
                    if (!thisNewSuperior.equals(entryNewSuperior)) {
                        return false;
                    }
                    break;
                }
                catch (LdapInvalidDnException ine) {
                    return false;
                }
            }
        }
        if (this.control != null) {
            return this.control.equals(otherEntry.control);
        }
        return otherEntry.control == null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int type = in.readInt();
        this.changeType = ChangeType.getChangeType(type);
        this.entry = (Entry)in.readObject();
        switch (this.changeType) {
            case Add: 
            case Delete: {
                break;
            }
            case ModDn: 
            case ModRdn: {
                this.deleteOldRdn = in.readBoolean();
                if (in.readBoolean()) {
                    this.newRdn = in.readUTF();
                }
                if (!in.readBoolean()) break;
                this.newSuperior = in.readUTF();
                break;
            }
            case Modify: {
                int nbModifs = in.readInt();
                for (int i = 0; i < nbModifs; ++i) {
                    int operation = in.readInt();
                    String modStr = in.readUTF();
                    DefaultClientAttribute value = (DefaultClientAttribute)in.readObject();
                    this.addModificationItem(ModificationOperation.getOperation(operation), modStr, value);
                }
                break;
            }
        }
        if (in.available() > 0) {
            this.control = (Control)in.readObject();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.changeType.getChangeType());
        out.writeObject(this.entry);
        switch (this.changeType) {
            case Add: 
            case Delete: {
                break;
            }
            case ModDn: 
            case ModRdn: {
                out.writeBoolean(this.deleteOldRdn);
                if (this.newRdn != null) {
                    out.writeBoolean(true);
                    out.writeUTF(this.newRdn);
                } else {
                    out.writeBoolean(false);
                }
                if (this.newSuperior != null) {
                    out.writeBoolean(true);
                    out.writeUTF(this.newSuperior);
                    break;
                }
                out.writeBoolean(false);
                break;
            }
            case Modify: {
                out.writeInt(this.modificationList.size());
                for (Modification modification : this.modificationList) {
                    out.writeInt(modification.getOperation().getValue());
                    out.writeUTF(modification.getAttribute().getId());
                    EntryAttribute attribute = modification.getAttribute();
                    out.writeObject(attribute);
                }
                break;
            }
        }
        if (this.control != null) {
            out.writeObject(this.control);
        }
        out.flush();
    }
}

