/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messaging;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.DefaultCarbonMessage;
import org.wso2.carbon.messaging.Header;
import org.wso2.carbon.messaging.MapCarbonMessage;
import org.wso2.carbon.messaging.TextCarbonMessage;

public class MessageUtil {
    public static CarbonMessage cloneCarbonMessageWithOutData(CarbonMessage carbonMessage) {
        DefaultCarbonMessage newCarbonMessage = new DefaultCarbonMessage(carbonMessage.isBufferContent());
        List<Header> transportHeaders = carbonMessage.getHeaders().getClone();
        newCarbonMessage.setHeaders(transportHeaders);
        Map<String, Object> propertiesMap = carbonMessage.getProperties();
        propertiesMap.forEach((key, value) -> newCarbonMessage.setProperty((String)key, value));
        newCarbonMessage.setWriter(carbonMessage.getWriter());
        newCarbonMessage.setFaultHandlerStack(carbonMessage.getFaultHandlerStack());
        return newCarbonMessage;
    }

    public static CarbonMessage cloneCarbonMessageWithData(CarbonMessage carbonMessage) {
        DefaultCarbonMessage newCarbonMessage = new DefaultCarbonMessage(carbonMessage.isBufferContent());
        List<Header> transportHeaders = carbonMessage.getHeaders().getClone();
        newCarbonMessage.setHeaders(transportHeaders);
        Map<String, Object> propertiesMap = carbonMessage.getProperties();
        propertiesMap.forEach((key, value) -> newCarbonMessage.setProperty((String)key, value));
        newCarbonMessage.setWriter(carbonMessage.getWriter());
        newCarbonMessage.setFaultHandlerStack(carbonMessage.getFaultHandlerStack());
        carbonMessage.getCopyOfFullMessageBody().forEach(buffer -> newCarbonMessage.addMessageBody((ByteBuffer)buffer));
        newCarbonMessage.setEndOfMsgAdded(true);
        return newCarbonMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer deepCopy(ByteBuffer orig) {
        int pos = orig.position();
        int lim = orig.limit();
        try {
            orig.position(0).limit(orig.capacity());
            ByteBuffer toReturn = MessageUtil.deepCopyVisible(orig);
            toReturn.position(pos).limit(lim);
            ByteBuffer byteBuffer = toReturn;
            return byteBuffer;
        }
        finally {
            orig.position(pos).limit(lim);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer deepCopyVisible(ByteBuffer orig) {
        int pos = orig.position();
        try {
            ByteBuffer toReturn = orig.isDirect() ? ByteBuffer.allocateDirect(orig.remaining()) : ByteBuffer.allocate(orig.remaining());
            toReturn.put(orig);
            toReturn.order(orig.order());
            ByteBuffer byteBuffer = (ByteBuffer)toReturn.position(0);
            return byteBuffer;
        }
        finally {
            orig.position(pos);
        }
    }

    public static MapCarbonMessage createMapMessageWithoutData(CarbonMessage carbonMessage) {
        MapCarbonMessage mapCarbonMessage = new MapCarbonMessage();
        mapCarbonMessage.setHeaders(new ArrayList<Header>(carbonMessage.headers.getAll()));
        carbonMessage.getProperties().forEach(mapCarbonMessage::setProperty);
        mapCarbonMessage.setWriter(carbonMessage.getWriter());
        mapCarbonMessage.setFaultHandlerStack(carbonMessage.getFaultHandlerStack());
        return mapCarbonMessage;
    }

    public static TextCarbonMessage createTextMessageWithData(CarbonMessage message) {
        TextCarbonMessage textCarbonMessage = new TextCarbonMessage(message.getMessageDataSource().getMessageAsString());
        textCarbonMessage.setHeaders(new ArrayList<Header>(message.headers.getAll()));
        message.getProperties().forEach(textCarbonMessage::setProperty);
        textCarbonMessage.setWriter(message.getWriter());
        textCarbonMessage.setFaultHandlerStack(message.getFaultHandlerStack());
        return textCarbonMessage;
    }
}

