/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.core.reporter.impl;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import java.util.concurrent.TimeUnit;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import org.wso2.carbon.metrics.core.reporter.ScheduledReporter;
import org.wso2.carbon.metrics.core.reporter.impl.AbstractReporter;

public class Slf4jReporter
extends AbstractReporter
implements ScheduledReporter {
    private final MetricRegistry metricRegistry;
    private final MetricFilter metricFilter;
    private final String loggerName;
    private final String markerName;
    private final long pollingPeriod;
    private com.codahale.metrics.Slf4jReporter slf4jReporter;

    public Slf4jReporter(String name, MetricRegistry metricRegistry, MetricFilter metricFilter, String loggerName, String markerName, long pollingPeriod) {
        super(name);
        this.metricRegistry = metricRegistry;
        this.metricFilter = metricFilter;
        this.loggerName = loggerName;
        this.markerName = markerName;
        this.pollingPeriod = pollingPeriod;
    }

    @Override
    public void report() {
        if (this.slf4jReporter != null) {
            this.slf4jReporter.report();
        }
    }

    @Override
    public void startReporter() {
        Slf4jReporter.Builder builder = com.codahale.metrics.Slf4jReporter.forRegistry(this.metricRegistry).filter(this.metricFilter).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).outputTo(LoggerFactory.getLogger(this.loggerName));
        if (this.markerName != null) {
            builder.markWith(MarkerFactory.getMarker(this.markerName));
        }
        this.slf4jReporter = builder.build();
        this.slf4jReporter.start(this.pollingPeriod, TimeUnit.SECONDS);
    }

    @Override
    public void stopReporter() {
        if (this.slf4jReporter != null) {
            this.slf4jReporter.stop();
            this.slf4jReporter = null;
        }
    }
}

