/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.jdbc.core.config.model;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.core.config.model.ScheduledReporterConfig;
import org.wso2.carbon.metrics.core.reporter.ReporterBuildException;
import org.wso2.carbon.metrics.core.reporter.ReporterBuilder;
import org.wso2.carbon.metrics.core.utils.Utils;
import org.wso2.carbon.metrics.jdbc.core.config.model.DataSourceConfig;
import org.wso2.carbon.metrics.jdbc.core.config.model.JdbcScheduledCleanupConfig;
import org.wso2.carbon.metrics.jdbc.core.reporter.impl.JdbcReporter;

public class JdbcReporterConfig
extends ScheduledReporterConfig
implements ReporterBuilder<JdbcReporter> {
    private static final Logger logger = LoggerFactory.getLogger(JdbcReporterConfig.class);
    private String source = Utils.getDefaultSource();
    private DataSourceConfig dataSource = new DataSourceConfig();

    public JdbcReporterConfig() {
        super("JDBC");
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public DataSourceConfig getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSourceConfig dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public Optional<JdbcReporter> build(MetricRegistry metricRegistry, MetricFilter metricFilter) throws ReporterBuildException {
        DataSource jdbcDataSource;
        if (!this.isEnabled()) {
            return Optional.empty();
        }
        String dataSourceName = this.dataSource.getDataSourceName();
        if (this.dataSource.isLookupDataSource()) {
            if (dataSourceName == null || dataSourceName.trim().isEmpty()) {
                throw new ReporterBuildException("Data Source Name is not specified for JDBC Reporting.");
            }
            try {
                jdbcDataSource = (DataSource)InitialContext.doLookup(dataSourceName);
            }
            catch (NamingException e) {
                throw new ReporterBuildException(String.format("Error when looking up the Data Source: '%s'.", dataSourceName), e);
            }
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Creating JDBC reporter for Metrics with source '%s', data source '%s' and %d seconds polling period", this.source, dataSourceName, this.getPollingPeriod()));
            }
        } else {
            Map<String, String> dataSourcePropertiesMap = this.dataSource.getDataSourceProperties();
            if (dataSourcePropertiesMap.isEmpty()) {
                throw new ReporterBuildException("Metrics Datasource Properties not found!");
            }
            Properties properties = new Properties();
            properties.putAll(dataSourcePropertiesMap);
            if (logger.isDebugEnabled()) {
                logger.debug("Creating Metrics Datasource");
            }
            HikariConfig hikariConfig = new HikariConfig(properties);
            jdbcDataSource = new HikariDataSource(hikariConfig);
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Creating JDBC reporter for Metrics with source '%s' and %d seconds polling period", this.source, this.getPollingPeriod()));
            }
        }
        JdbcScheduledCleanupConfig scheduledCleanup = this.dataSource.getScheduledCleanup();
        return Optional.of(new JdbcReporter(this.getName(), metricRegistry, this.getFilter(metricFilter), this.source, jdbcDataSource, this.getPollingPeriod(), scheduledCleanup.isEnabled(), scheduledCleanup.getDaysToKeep(), scheduledCleanup.getScheduledCleanupPeriod()));
    }
}

