/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.AbstractSessionManager;
import org.wso2.msf4j.Session;

public class PersistentSessionManager
extends AbstractSessionManager {
    private static final Logger log = LoggerFactory.getLogger(PersistentSessionManager.class);
    private static final String SESSION_DIR = ".sessions";

    public PersistentSessionManager() {
        File dir = new File(SESSION_DIR);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("Cannot create .tmp directory");
        }
    }

    @Override
    public void loadSessions(Map<String, Session> sessions) {
        File dir = new File(SESSION_DIR);
        if (!dir.exists()) {
            return;
        }
        String path = Paths.get(SESSION_DIR, new String[0]).toString();
        ((Stream)Arrays.stream(new File(path).listFiles()).parallel()).forEach(file -> {
            Session session = this.readSession(file.getName());
            if (System.currentTimeMillis() - session.getLastAccessedTime() >= (long)session.getMaxInactiveInterval() * 60L * 1000L && !file.delete()) {
                log.warn("Couldn't delete expired session file " + file.getAbsolutePath());
            } else {
                sessions.put(session.getId(), session);
            }
        });
    }

    /*
     * Exception decompiling
     */
    @Override
    public Session readSession(String sessionId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void saveSession(Session session) {
        try (FileOutputStream fout = new FileOutputStream(Paths.get(SESSION_DIR, session.getId()).toString());
             ObjectOutputStream oos = new ObjectOutputStream(fout);){
            oos.writeObject(session);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot save session " + session.getId(), e);
        }
    }

    @Override
    public void deleteSession(Session session) {
        String pathname = Paths.get(SESSION_DIR, session.getId()).toString();
        if (!new File(pathname).delete()) {
            throw new IllegalStateException("File " + pathname + " deletion failed");
        }
    }

    @Override
    public void updateSession(Session session) {
        this.saveSession(session);
    }
}

