/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.analytics.metrics;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.core.Counter;
import org.wso2.carbon.metrics.core.Meter;
import org.wso2.carbon.metrics.core.MetricAnnotation;
import org.wso2.carbon.metrics.core.Timer;
import org.wso2.carbon.metrics.core.annotation.Counted;
import org.wso2.carbon.metrics.core.annotation.Metered;
import org.wso2.carbon.metrics.core.annotation.Timed;
import org.wso2.msf4j.Interceptor;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.Response;
import org.wso2.msf4j.ServiceMethodInfo;
import org.wso2.msf4j.analytics.metrics.Metrics;

@Component(name="org.wso2.msf4j.analytics.metrics.MetricsInterceptor", service={Interceptor.class})
public class MetricsInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(MetricsInterceptor.class);
    private Map<Method, MethodInterceptors> map = new ConcurrentHashMap<Method, MethodInterceptors>();

    public MetricsInterceptor() {
        if (logger.isDebugEnabled()) {
            logger.debug("Creating Metrics Interceptor");
        }
    }

    private Timed getTimedAnnotation(Method method) {
        Timed annotation = method.getAnnotation(Timed.class);
        if (annotation == null) {
            annotation = method.getDeclaringClass().getAnnotation(Timed.class);
        }
        return annotation;
    }

    private Metered getMeteredAnnotation(Method method) {
        Metered annotation = method.getAnnotation(Metered.class);
        if (annotation == null) {
            annotation = method.getDeclaringClass().getAnnotation(Metered.class);
        }
        return annotation;
    }

    private Counted getCountedAnnotation(Method method) {
        Counted annotation = method.getAnnotation(Counted.class);
        if (annotation == null) {
            annotation = method.getDeclaringClass().getAnnotation(Counted.class);
        }
        return annotation;
    }

    @Override
    public boolean preCall(Request request, Response responder, ServiceMethodInfo serviceMethodInfo) throws Exception {
        Method method = serviceMethodInfo.getMethod();
        MethodInterceptors methodInterceptors = this.map.get(method);
        if (methodInterceptors == null || !methodInterceptors.annotationScanned) {
            Counted counted;
            Metered metered;
            CopyOnWriteArrayList<Interceptor> interceptors = new CopyOnWriteArrayList<Interceptor>();
            Timed timed = this.getTimedAnnotation(method);
            if (timed != null) {
                Timer timer = MetricAnnotation.timer(Metrics.getInstance().getMetricService(), timed, method);
                TimerInterceptor interceptor = new TimerInterceptor(timer);
                interceptors.add(interceptor);
            }
            if ((metered = this.getMeteredAnnotation(method)) != null) {
                Meter meter = MetricAnnotation.meter(Metrics.getInstance().getMetricService(), metered, method);
                MeterInterceptor interceptor = new MeterInterceptor(meter);
                interceptors.add(interceptor);
            }
            if ((counted = this.getCountedAnnotation(method)) != null) {
                Counter counter = MetricAnnotation.counter(Metrics.getInstance().getMetricService(), counted, method);
                CounterInterceptor interceptor = new CounterInterceptor(counter, counted.monotonic());
                interceptors.add(interceptor);
            }
            methodInterceptors = new MethodInterceptors(true, interceptors);
            this.map.put(method, methodInterceptors);
        }
        return methodInterceptors.preCall(request, responder, serviceMethodInfo);
    }

    @Override
    public void postCall(Request request, int status, ServiceMethodInfo serviceMethodInfo) throws Exception {
        Method method = serviceMethodInfo.getMethod();
        MethodInterceptors methodInterceptors = this.map.get(method);
        if (methodInterceptors != null) {
            methodInterceptors.postCall(request, status, serviceMethodInfo);
        }
    }

    private static class CounterInterceptor
    implements Interceptor {
        private final Counter counter;
        private final boolean monotonic;

        private CounterInterceptor(Counter counter, boolean monotonic) {
            this.counter = counter;
            this.monotonic = monotonic;
        }

        @Override
        public boolean preCall(Request request, Response responder, ServiceMethodInfo serviceMethodInfo) {
            this.counter.inc();
            return true;
        }

        @Override
        public void postCall(Request request, int status, ServiceMethodInfo serviceMethodInfo) {
            if (!this.monotonic) {
                this.counter.dec();
            }
        }
    }

    private static class MeterInterceptor
    implements Interceptor {
        private final Meter meter;

        private MeterInterceptor(Meter meter) {
            this.meter = meter;
        }

        @Override
        public boolean preCall(Request request, Response responder, ServiceMethodInfo serviceMethodInfo) {
            this.meter.mark();
            return true;
        }

        @Override
        public void postCall(Request request, int status, ServiceMethodInfo serviceMethodInfo) {
        }
    }

    private static class TimerInterceptor
    implements Interceptor {
        private final Timer timer;
        private static final String TIMER_CONTEXT = "TIMER_CONTEXT";

        private TimerInterceptor(Timer timer) {
            this.timer = timer;
        }

        @Override
        public boolean preCall(Request request, Response responder, ServiceMethodInfo serviceMethodInfo) {
            Timer.Context context = this.timer.start();
            serviceMethodInfo.setAttribute(TIMER_CONTEXT, context);
            return true;
        }

        @Override
        public void postCall(Request request, int status, ServiceMethodInfo serviceMethodInfo) {
            Timer.Context context = (Timer.Context)serviceMethodInfo.getAttribute(TIMER_CONTEXT);
            context.stop();
        }
    }

    private static class MethodInterceptors
    implements Interceptor {
        private final boolean annotationScanned;
        private Interceptor[] interceptors;

        MethodInterceptors(boolean annotationScanned, List<Interceptor> interceptors) {
            this.annotationScanned = annotationScanned;
            if (!interceptors.isEmpty()) {
                this.interceptors = interceptors.toArray(new Interceptor[interceptors.size()]);
            }
        }

        @Override
        public boolean preCall(Request request, Response responder, ServiceMethodInfo serviceMethodInfo) throws Exception {
            if (this.interceptors != null) {
                for (Interceptor interceptor : this.interceptors) {
                    interceptor.preCall(request, responder, serviceMethodInfo);
                }
            }
            return true;
        }

        @Override
        public void postCall(Request request, int status, ServiceMethodInfo serviceMethodInfo) throws Exception {
            if (this.interceptors != null) {
                for (Interceptor interceptor : this.interceptors) {
                    interceptor.postCall(request, status, serviceMethodInfo);
                }
            }
        }
    }
}

