/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.internal.StringUtil;
import java.net.SocketAddress;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class HttpTraceLoggingHandler
extends LoggingHandler {
    private static final LogLevel LOG_LEVEL = LogLevel.TRACE;
    private static final String EVENT_REGISTERED = "REGISTERED";
    private static final String EVENT_CONNECT = "CONNECT";
    private static final String EVENT_INBOUND = "INBOUND";
    private static final String EVENT_OUTBOUND = "OUTBOUND";
    private static final String ID_0X = "[id: 0x";
    private String correlatedSourceId = "n/a";

    public HttpTraceLoggingHandler(LogLevel level) {
        super(level);
    }

    public HttpTraceLoggingHandler(Class<?> clazz) {
        super(clazz);
    }

    public HttpTraceLoggingHandler(Class<?> clazz, LogLevel level) {
        super(clazz, level);
    }

    public HttpTraceLoggingHandler(String name) {
        super(name, LOG_LEVEL);
    }

    public HttpTraceLoggingHandler(String name, LogLevel level) {
        super(name, level);
    }

    public void setCorrelatedSourceId(String correlatedSourceId) {
        this.correlatedSourceId = "0x" + correlatedSourceId;
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx, EVENT_INBOUND, msg));
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx, EVENT_OUTBOUND, msg));
        }
        ctx.write(msg, promise);
    }

    @Override
    protected String format(ChannelHandlerContext ctx, String eventName, Object arg1, Object arg2) {
        String arg1Str = String.valueOf(arg1);
        String arg2Str = String.valueOf(arg2);
        StringBuilder stringBuilder = new StringBuilder(arg1Str.length() + 2 + arg2Str.length());
        return this.format(ctx, eventName, stringBuilder.append(arg1Str).append(", ").append(arg2Str));
    }

    @Override
    protected String format(ChannelHandlerContext ctx, String eventName) {
        String channelId = ctx.channel().id().asShortText();
        String socketInfo = HttpTraceLoggingHandler.buildSocketInfo(ctx.channel().localAddress(), ctx.channel().remoteAddress());
        StringBuilder stringBuilder = new StringBuilder(7 + channelId.length() + 14 + this.correlatedSourceId.length() + socketInfo.length() + 2 + eventName.length());
        if (EVENT_REGISTERED.equals(eventName) || EVENT_CONNECT.equals(eventName)) {
            return stringBuilder.append(ID_0X).append(channelId).append("] ").append(eventName).toString();
        }
        return stringBuilder.append(ID_0X).append(channelId).append(", correlatedSource: ").append(this.correlatedSourceId).append(socketInfo).append("] ").append(eventName).toString();
    }

    @Override
    protected String format(ChannelHandlerContext ctx, String eventName, Object msg) {
        String msgStr;
        String channelId = ctx.channel().id().asShortText();
        String socketInfo = HttpTraceLoggingHandler.buildSocketInfo(ctx.channel().localAddress(), ctx.channel().remoteAddress());
        try {
            msgStr = msg instanceof ByteBuf ? HttpTraceLoggingHandler.formatPayload((ByteBuf)msg) : (msg instanceof ByteBufHolder ? HttpTraceLoggingHandler.formatPayload((ByteBufHolder)msg) : String.valueOf(msg));
        }
        catch (CharacterCodingException e) {
            msgStr = "<< Payload could not be decoded >>";
        }
        StringBuilder stringBuilder = new StringBuilder(7 + channelId.length() + 14 + this.correlatedSourceId.length() + socketInfo.length() + 2 + eventName.length() + 2 + msgStr.length());
        if (EVENT_REGISTERED.equals(eventName) || EVENT_CONNECT.equals(eventName)) {
            return stringBuilder.append(ID_0X).append(channelId).append("] ").append(eventName).append(": ").append(msgStr).toString();
        }
        return stringBuilder.append(ID_0X).append(channelId).append(", correlatedSource: ").append(this.correlatedSourceId).append(socketInfo).append("] ").append(eventName).append(": ").append(msgStr).toString();
    }

    private static String formatPayload(ByteBuf msg) throws CharacterCodingException {
        int length = msg.readableBytes();
        if (length == 0) {
            return " 0B";
        }
        int rows = length / 16 + (length % 16 == 0 ? 0 : 1) + 4;
        StringBuilder stringBuilder = new StringBuilder(13 + rows * 80);
        stringBuilder.append(length).append('B').append(StringUtil.NEWLINE);
        HttpTraceLoggingHandler.appendPayload(stringBuilder, msg);
        return stringBuilder.toString();
    }

    private static String formatPayload(ByteBufHolder msg) throws CharacterCodingException {
        String msgStr = msg.toString();
        ByteBuf content = msg.content();
        int length = content.readableBytes();
        if (length == 0) {
            return msgStr + ", 0B";
        }
        int rows = length / 16 + (length % 16 == 0 ? 0 : 1) + 4;
        StringBuilder stringBuilder = new StringBuilder(2 + msgStr.length() + 2 + 10 + 1 + 2 + rows * 80);
        stringBuilder.append(msgStr).append(", ").append(length).append('B').append(StringUtil.NEWLINE);
        HttpTraceLoggingHandler.appendPayload(stringBuilder, content);
        return stringBuilder.toString();
    }

    private static String buildSocketInfo(SocketAddress local, SocketAddress remote) {
        StringBuilder stringBuilder = new StringBuilder();
        if (local != null) {
            stringBuilder.append(", host:").append(local.toString()).append(" - ");
        }
        if (remote != null) {
            stringBuilder.append("remote:").append(remote.toString());
        }
        return stringBuilder.toString();
    }

    private static void appendPayload(StringBuilder stringBuilder, ByteBuf content) throws CharacterCodingException {
        CharsetDecoder decoder = Charset.forName("UTF8").newDecoder();
        CharBuffer buffer = decoder.decode(content.nioBuffer());
        stringBuilder.append(buffer);
    }
}

