/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.config.provider;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.ConfigurationRuntimeException;
import org.wso2.carbon.config.ConfigurationUtils;
import org.wso2.carbon.config.annotation.Configuration;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.config.provider.ImmutablePair;
import org.wso2.carbon.config.reader.ConfigFileReader;
import org.wso2.carbon.secvault.SecureVault;
import org.wso2.carbon.secvault.exception.SecureVaultException;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.introspector.BeanAccess;

public class ConfigProviderImpl
implements ConfigProvider {
    private static final Logger logger = LoggerFactory.getLogger(ConfigProviderImpl.class.getName());
    private static final String CONFIG_LEVEL_SEPARATOR = "_";
    private static final String NAMESPACE_LEVEL_SEPERATOR = "__";
    private static final String CONFIG_NAMESPACE_WORD_SEPERATOR = ".";
    private static final int CONFIG_MIN_ELEMENT_COUNT = 2;
    private static final String[] UNIQUE_ATTRIBUTE_NAMES = new String[]{"ID", "NAME"};
    private static final String UNIQUE_ATTRIBUTE_SPECIFIER = "UNIQUE";
    private Map<String, String> deploymentConfigs = null;
    private static final String PLACEHOLDER_REGEX = "(.*?)(\\$\\{(" + ConfigProviderImpl.getPlaceholderString() + "):([^,]+?)((,)(.+?))?\\})(.*?)";
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile(PLACEHOLDER_REGEX);
    private ConfigFileReader configFileReader;
    private SecureVault secureVault;

    public ConfigProviderImpl(ConfigFileReader configFileReader, SecureVault secureVault) {
        this.configFileReader = configFileReader;
        this.secureVault = secureVault;
    }

    @Override
    public <T> T getConfigurationObject(Class<T> configClass) throws ConfigurationException {
        T configObject;
        Configuration configuration;
        String namespace = null;
        if (configClass.isAnnotationPresent(Configuration.class) && !"NULL".equals((configuration = configClass.getAnnotation(Configuration.class)).namespace())) {
            namespace = configuration.namespace();
        }
        this.loadDeploymentConfiguration(this.configFileReader);
        String yamlConfigString = this.deploymentConfigs.get(namespace);
        if (logger.isDebugEnabled()) {
            logger.debug("class name: " + configClass.getSimpleName() + " | new configurations: \n" + yamlConfigString);
        }
        if (yamlConfigString != null && !yamlConfigString.isEmpty()) {
            String yamlProcessedString = this.processPlaceholder(yamlConfigString);
            yamlProcessedString = ConfigurationUtils.substituteVariables(yamlProcessedString);
            configObject = this.getConfigurationObject(configClass, configClass.getClassLoader(), yamlProcessedString);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Deployment configuration mapping doesn't exist: creating configuration instance with default values");
            }
            try {
                configObject = configClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ConfigurationException("Error while creating configuration instance: " + configClass.getSimpleName(), e);
            }
        }
        return this.overrideConfigWithSystemVars(namespace, configObject);
    }

    @Override
    public Object getConfigurationObject(String namespace) throws ConfigurationException {
        this.loadDeploymentConfiguration(this.configFileReader);
        if (this.deploymentConfigs.containsKey(namespace)) {
            String configString = this.deploymentConfigs.get(namespace);
            String processedString = this.processPlaceholder(configString);
            processedString = ConfigurationUtils.substituteVariables(processedString);
            Yaml yaml = new Yaml();
            return yaml.load(processedString);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("configuration doesn't exist for the namespace: {} in deployment yaml   . Hence return null object", (Object)namespace);
        }
        return null;
    }

    @Override
    public <T> T getConfigurationObject(String namespace, Class<T> configClass) throws ConfigurationException {
        this.loadDeploymentConfiguration(this.configFileReader);
        if (namespace != null && this.deploymentConfigs.containsKey(namespace)) {
            String configString = this.deploymentConfigs.get(namespace);
            String processedString = this.processPlaceholder(configString);
            processedString = ConfigurationUtils.substituteVariables(processedString);
            return this.overrideConfigWithSystemVars(namespace, this.getConfigurationObject(configClass, configClass.getClassLoader(), processedString));
        }
        return this.getConfigurationObject(configClass);
    }

    private Map<String, String> filterVariables(String namespace, Map<String, String> variables) {
        HashMap<String, String> filteredVariableMap = new HashMap<String, String>();
        variables.entrySet().forEach(entry -> {
            String[] splicedEnvironmentVariableParts;
            String environmentVariableNameSpacePart = namespace.toUpperCase().replace(CONFIG_NAMESPACE_WORD_SEPERATOR, CONFIG_LEVEL_SEPARATOR) + NAMESPACE_LEVEL_SEPERATOR;
            if (((String)entry.getKey()).toUpperCase().startsWith(environmentVariableNameSpacePart) && (splicedEnvironmentVariableParts = ((String)entry.getKey()).split(environmentVariableNameSpacePart, 2)).length == 2 && !splicedEnvironmentVariableParts[1].trim().isEmpty() && !splicedEnvironmentVariableParts[1].toUpperCase().endsWith(UNIQUE_ATTRIBUTE_SPECIFIER.toUpperCase())) {
                filteredVariableMap.putIfAbsent((String)entry.getKey(), (String)entry.getValue());
            }
        });
        return filteredVariableMap;
    }

    private Map<String, String> getSystemVariables(String namespace) {
        if (namespace == null || namespace.trim().length() == 0) {
            return new HashMap<String, String>();
        }
        Map<String, String> envVariables = this.filterVariables(namespace, System.getenv());
        Map<String, String> systemProperties = this.filterVariables(namespace, System.getProperties().entrySet().stream().collect(Collectors.toMap(entry -> entry.getKey().toString(), entry -> entry.getValue().toString())));
        HashMap<String, String> mergedMap = new HashMap<String, String>();
        mergedMap.putAll(systemProperties);
        mergedMap.putAll(envVariables);
        return mergedMap;
    }

    private <T> T overrideConfigWithSystemVars(String namespace, T configClass) throws ConfigurationException {
        Map<String, String> systemVariables = this.getSystemVariables(namespace);
        for (Map.Entry<String, String> entry : systemVariables.entrySet()) {
            String systemVarKey = entry.getKey();
            String environmentVariableNameSpacePart = namespace.toUpperCase(Locale.ENGLISH).replace(CONFIG_NAMESPACE_WORD_SEPERATOR, CONFIG_LEVEL_SEPARATOR) + NAMESPACE_LEVEL_SEPERATOR;
            String configKey = systemVarKey.split(environmentVariableNameSpacePart)[1];
            String value = entry.getValue();
            ArrayList<String> configKeyElements = new ArrayList<String>(Arrays.asList(configKey.split(CONFIG_LEVEL_SEPARATOR)));
            this.overrideConfigWithSystemVariable(configClass, null, configKeyElements, value, systemVarKey);
        }
        return configClass;
    }

    private <T> Object overrideConfigWithSystemVariable(T configClass, Field field, List<String> configKeyElements, String value, String systemVarKey) throws ConfigurationException {
        String configElement = configKeyElements.get(0);
        if (configKeyElements.size() == 1) {
            this.setFieldValue(configClass, configElement, value);
            configKeyElements.remove(configElement);
            return configClass;
        }
        if (this.isPositiveInteger(configElement)) {
            if (configClass instanceof Collection) {
                String configFieldName = configKeyElements.get(1);
                configKeyElements.remove(configElement);
                ImmutablePair<String, String> uniqueVarEntry = this.getUniqueSystemVarEntry(systemVarKey);
                String uniqueVarKey = uniqueVarEntry.getFirst();
                String uniqueVarValue = uniqueVarEntry.getSecond();
                Optional<Object> configObjectOptional = ((Collection)configClass).stream().filter(element -> {
                    try {
                        Field uniqueField = this.getClassField(element, uniqueVarKey);
                        Object castedUniqueEnvValue = this.castToWrapperType(uniqueField, uniqueVarValue);
                        return this.getFieldValue(element, uniqueField).equals(castedUniqueEnvValue);
                    }
                    catch (ConfigurationException e) {
                        return false;
                    }
                }).findFirst();
                if (configObjectOptional.isPresent()) {
                    Object configObject = configObjectOptional.get();
                    Field configField = this.getClassField(configObject, configFieldName);
                    ((Collection)configClass).remove(configObject);
                    ((Collection)configClass).add(this.overrideConfigWithSystemVariable(configObject, configField, configKeyElements, value, systemVarKey));
                } else {
                    Class<?> parameterizeType = this.getCollectionType(field);
                    Object parameterizeTypeObj = this.createInstanceFromClass(parameterizeType);
                    Field configField = this.getClassField(parameterizeTypeObj, configFieldName);
                    ((Collection)configClass).add(this.overrideConfigWithSystemVariable(parameterizeTypeObj, configField, configKeyElements, value, systemVarKey));
                }
                return configClass;
            }
            throw new ConfigurationException(String.format(Locale.ENGLISH, "Cannot determine the array type of the system variable %s, element %s", systemVarKey, configElement));
        }
        Field configField = this.getClassField(configClass, configElement);
        Object configElementObject = this.getFieldValue(configClass, configElement);
        configKeyElements.remove(configElement);
        this.setFieldValue(configClass, configElement, this.overrideConfigWithSystemVariable(configElementObject, configField, configKeyElements, value, systemVarKey));
        return configClass;
    }

    private Object createInstanceFromClass(Class<?> type) throws ConfigurationException {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = type.getDeclaredConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            constructor.setAccessible(true);
            try {
                return constructor.newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                throw new ConfigurationException(String.format(Locale.ENGLISH, "Error occurred in instantiating an instance from %s", type.getName()));
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException(String.format(Locale.ENGLISH, "Cannot access default constructor in %s", type.getName()));
            }
            catch (InvocationTargetException e) {
                throw new ConfigurationException(String.format(Locale.ENGLISH, "Error occurred when invoking default constructor in %s", type.getName()));
            }
        }
        throw new ConfigurationException(String.format(Locale.ENGLISH, "Default constructor not found in %s", type.getName()));
    }

    private ImmutablePair<String, String> getUniqueSystemVarEntry(String systemVarKey) throws ConfigurationException {
        String uniqueVarKey;
        for (String uniqueKey : UNIQUE_ATTRIBUTE_NAMES) {
            uniqueVarKey = systemVarKey.substring(0, systemVarKey.lastIndexOf(CONFIG_LEVEL_SEPARATOR)) + CONFIG_LEVEL_SEPARATOR + uniqueKey;
            String uniqueVarValue = this.getSystemVariableValue(uniqueVarKey);
            if (uniqueVarValue == null) continue;
            return ImmutablePair.of(uniqueKey, uniqueVarValue);
        }
        String uniqueVarKeySegment = systemVarKey.substring(0, systemVarKey.lastIndexOf(CONFIG_LEVEL_SEPARATOR));
        String arrayGroupString = uniqueVarKeySegment.substring(systemVarKey.lastIndexOf(CONFIG_LEVEL_SEPARATOR) - 1);
        String uniqueVarKeySpecifier = (uniqueVarKeySegment = uniqueVarKeySegment.substring(0, uniqueVarKeySegment.lastIndexOf(CONFIG_LEVEL_SEPARATOR))) + CONFIG_LEVEL_SEPARATOR + UNIQUE_ATTRIBUTE_SPECIFIER;
        String uniqueVarKeySpecifierValue = this.getSystemVariableValue(uniqueVarKeySpecifier);
        if (uniqueVarKeySpecifierValue == null) {
            throw new ConfigurationException(String.format(Locale.ENGLISH, "Locating unique system variable key for system variable %s from default attributes %s failed. Custom unique system variable key %s is not specified as well.", systemVarKey, Arrays.toString(UNIQUE_ATTRIBUTE_NAMES), uniqueVarKeySpecifier));
        }
        uniqueVarKey = uniqueVarKeySegment + CONFIG_LEVEL_SEPARATOR + arrayGroupString + CONFIG_LEVEL_SEPARATOR + uniqueVarKeySpecifierValue;
        String uniqueEnvValue = this.getSystemVariableValue(uniqueVarKey);
        if (uniqueEnvValue == null) {
            throw new ConfigurationException(String.format(Locale.ENGLISH, "Value for unique system variable %s is null when overriding system variable %s", uniqueVarKey, systemVarKey));
        }
        return ImmutablePair.of(uniqueVarKeySpecifierValue, uniqueEnvValue);
    }

    private String getSystemVariableValue(String systemVariableKey) throws ConfigurationException {
        if (System.getenv(systemVariableKey) != null) {
            return System.getenv(systemVariableKey);
        }
        return System.getProperty(systemVariableKey);
    }

    private boolean isPositiveInteger(String configKeyElement) {
        try {
            return Integer.parseInt(configKeyElement) >= 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private Class<?> getCollectionType(Field field) {
        ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
        return (Class)parameterizedType.getActualTypeArguments()[0];
    }

    private <T> T getConfigurationObject(Class<T> configClass, ClassLoader classLoader, String yamlString) {
        Yaml yaml = new Yaml(new CustomClassLoaderConstructor(configClass, classLoader));
        yaml.setBeanAccess(BeanAccess.FIELD);
        return yaml.loadAs(yamlString, configClass);
    }

    private <T> Field getClassField(T classObject, String fieldName) throws ConfigurationException {
        if (!SourceVersion.isName(fieldName)) {
            throw new ConfigurationException(String.format(Locale.ENGLISH, "Field name %s is not valid", fieldName));
        }
        String lowerCaseConfigKey = fieldName.toLowerCase(Locale.ENGLISH);
        Optional<Field> field = Arrays.stream(classObject.getClass().getDeclaredFields()).filter(fieldEntry -> fieldEntry.getName().toLowerCase(Locale.ENGLISH).equals(lowerCaseConfigKey)).findFirst();
        if (!field.isPresent()) {
            throw new ConfigurationException(String.format(Locale.ENGLISH, "Field %s not found in %s", fieldName, classObject.getClass()));
        }
        field.get().setAccessible(true);
        return field.get();
    }

    private <T> void setFieldValue(T classObject, String configKey, Object value) throws ConfigurationException {
        Field field = this.getClassField(classObject, configKey);
        if (field.getType().isPrimitive()) {
            value = this.castToWrapperType(field, value.toString());
        }
        try {
            field.set(classObject, value);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(String.format(Locale.ENGLISH, "Error in overriding deployment config value with system config key %s value", configKey));
        }
    }

    private <T> Object getFieldValue(T classObject, Field field) throws ConfigurationException {
        try {
            return field.get(classObject);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(String.format(Locale.ENGLISH, "Error in obtaining value for field %s in %s", field.getName(), classObject.getClass()));
        }
    }

    private <T> Object getFieldValue(T classObject, String fieldName) throws ConfigurationException {
        Field field = this.getClassField(classObject, fieldName);
        return this.getFieldValue(classObject, field);
    }

    private Object castToWrapperType(Field field, String value) {
        Class<Serializable> fieldType = field.getType();
        if (fieldType.isAssignableFrom(Short.TYPE)) {
            return Short.parseShort(value);
        }
        if (fieldType.isAssignableFrom(Integer.TYPE)) {
            return Integer.parseInt(value);
        }
        if (fieldType.isAssignableFrom(Long.TYPE)) {
            return Long.parseLong(value);
        }
        if (fieldType.isAssignableFrom(Float.TYPE)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (fieldType.isAssignableFrom(Double.TYPE)) {
            return Double.parseDouble(value);
        }
        if (fieldType.isAssignableFrom(Boolean.TYPE)) {
            return Boolean.parseBoolean(value);
        }
        if (fieldType.isAssignableFrom(Character.TYPE)) {
            return Character.valueOf(value.charAt(0));
        }
        if (fieldType.isAssignableFrom(Byte.TYPE)) {
            return Byte.parseByte(value);
        }
        return value;
    }

    private void loadDeploymentConfiguration(ConfigFileReader configFileReader) throws ConfigurationException {
        if (this.deploymentConfigs == null) {
            this.deploymentConfigs = configFileReader.getDeploymentConfiguration();
        }
    }

    private static String getPlaceholderString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Placeholder placeholder : Placeholder.values()) {
            stringBuilder.append(placeholder.getValue()).append("|");
        }
        String value = stringBuilder.substring(0, stringBuilder.length() - 1);
        logger.debug("PlaceHolders String: {}", (Object)value);
        return value;
    }

    private String processPlaceholder(String inputString) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(inputString);
        block12: while (matcher.find()) {
            String key = matcher.group(3);
            String value = matcher.group(4);
            String defaultValue = matcher.group(7);
            switch (key) {
                case "env": {
                    inputString = ConfigProviderImpl.processValue(System::getenv, value, inputString, defaultValue, Placeholder.ENV);
                    continue block12;
                }
                case "sys": {
                    inputString = ConfigProviderImpl.processValue(System::getProperty, value, inputString, defaultValue, Placeholder.SYS);
                    continue block12;
                }
                case "sec": {
                    try {
                        SecureVault secureVault = this.getSecureVault().orElseThrow(() -> new ConfigurationRuntimeException("Secure Vault service is not available"));
                        String newValue = new String(secureVault.resolve(value));
                        inputString = inputString.replaceFirst(PLACEHOLDER_REGEX, "$1" + ConfigurationUtils.escapeSpecialCharacters(newValue) + "$8");
                        continue block12;
                    }
                    catch (SecureVaultException e) {
                        throw new ConfigurationRuntimeException("Unable to resolve the given alias", e);
                    }
                }
            }
            String msg = String.format("Unsupported placeholder: %s", key);
            logger.error(msg);
            throw new ConfigurationRuntimeException(msg);
        }
        return inputString;
    }

    private static String processValue(Function<String, String> func, String key, String inputString, String defaultValue, Placeholder type) {
        String newValue = func.apply(key);
        if (newValue != null) {
            return inputString.replaceFirst(PLACEHOLDER_REGEX, "$1" + ConfigurationUtils.escapeSpecialCharacters(newValue) + "$8");
        }
        if (defaultValue != null) {
            return inputString.replaceFirst(PLACEHOLDER_REGEX, "$1" + ConfigurationUtils.escapeSpecialCharacters(defaultValue) + "$8");
        }
        String msg = Placeholder.ENV.getValue().equals(type.getValue()) ? String.format("Environment variable %s not found. Placeholder: %s", key, inputString) : (Placeholder.SYS.getValue().equals(type.getValue()) ? String.format("System property %s not found. Placeholder: %s", key, inputString) : String.format("Unsupported placeholder type: %s", type.getValue()));
        logger.error(msg);
        throw new ConfigurationRuntimeException(msg);
    }

    private Optional<SecureVault> getSecureVault() {
        return Optional.ofNullable(this.secureVault);
    }

    private static enum Placeholder {
        SYS("sys"),
        ENV("env"),
        SEC("sec");

        private String value;

        private Placeholder(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

