/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent;

import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.carbon.databridge.agent.AgentHolder;
import org.wso2.carbon.databridge.agent.DataEndpointAgent;
import org.wso2.carbon.databridge.agent.conf.DataEndpointConfiguration;
import org.wso2.carbon.databridge.agent.endpoint.DataEndpoint;
import org.wso2.carbon.databridge.agent.endpoint.DataEndpointGroup;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAgentConfigurationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAuthenticationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointConfigurationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointException;
import org.wso2.carbon.databridge.agent.exception.EventQueueFullException;
import org.wso2.carbon.databridge.agent.util.DataPublisherUtil;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.exception.TransportException;

public class DataPublisher {
    private static final Logger log = Logger.getLogger(DataPublisher.class);
    private ArrayList<DataEndpointGroup> endpointGroups = new ArrayList();
    private DataEndpointAgent dataEndpointAgent;
    private static final int FAILED_EVENT_LOG_INTERVAL = 10000;
    private long lastFailedEventTime;
    private long failedEventCount;

    public DataPublisher(String receiverURLSet, String username, String password) throws DataEndpointAgentConfigurationException, DataEndpointException, DataEndpointConfigurationException, DataEndpointAuthenticationException, TransportException {
        this.dataEndpointAgent = AgentHolder.getInstance().getDefaultDataEndpointAgent();
        this.processEndpoints(this.dataEndpointAgent, receiverURLSet, DataPublisherUtil.getDefaultAuthURLSet(receiverURLSet), username, password);
        this.dataEndpointAgent.addDataPublisher(this);
    }

    public DataPublisher(String type, String receiverURLSet, String authURLSet, String username, String password) throws DataEndpointAgentConfigurationException, DataEndpointException, DataEndpointConfigurationException, DataEndpointAuthenticationException, TransportException {
        this.dataEndpointAgent = type == null ? AgentHolder.getInstance().getDefaultDataEndpointAgent() : AgentHolder.getInstance().getDataEndpointAgent(type);
        if (authURLSet == null) {
            authURLSet = DataPublisherUtil.getDefaultAuthURLSet(receiverURLSet);
        }
        this.processEndpoints(this.dataEndpointAgent, receiverURLSet, authURLSet, username, password);
        this.dataEndpointAgent.addDataPublisher(this);
    }

    private void processEndpoints(DataEndpointAgent dataEndpointAgent, String receiverURLSet, String authURLSet, String username, String password) throws DataEndpointConfigurationException, DataEndpointAgentConfigurationException, DataEndpointException, DataEndpointAuthenticationException, TransportException {
        ArrayList<Object[]> receiverURLGroups = DataPublisherUtil.getEndpointGroups(receiverURLSet);
        ArrayList<Object[]> authURLGroups = DataPublisherUtil.getEndpointGroups(authURLSet);
        DataPublisherUtil.validateURLs(receiverURLGroups, authURLGroups);
        for (int i = 0; i < receiverURLGroups.size(); ++i) {
            Object[] receiverGroup = receiverURLGroups.get(i);
            Object[] authGroup = authURLGroups.get(i);
            boolean failOver = (Boolean)receiverGroup[0];
            DataEndpointGroup endpointGroup = failOver ? new DataEndpointGroup(DataEndpointGroup.HAType.FAILOVER, dataEndpointAgent) : new DataEndpointGroup(DataEndpointGroup.HAType.LOADBALANCE, dataEndpointAgent);
            for (int j = 1; j < receiverGroup.length; ++j) {
                DataEndpointConfiguration endpointConfiguration = new DataEndpointConfiguration((String)receiverGroup[j], (String)authGroup[j], username, password, dataEndpointAgent.getTransportPool(), dataEndpointAgent.getSecuredTransportPool(), dataEndpointAgent.getAgentConfiguration().getBatchSize(), dataEndpointAgent.getAgentConfiguration().getCorePoolSize(), dataEndpointAgent.getAgentConfiguration().getMaxPoolSize(), dataEndpointAgent.getAgentConfiguration().getKeepAliveTimeInPool());
                DataEndpoint dataEndpoint = dataEndpointAgent.getNewDataEndpoint();
                dataEndpoint.initialize(endpointConfiguration);
                endpointGroup.addDataEndpoint(dataEndpoint);
            }
            this.endpointGroups.add(endpointGroup);
        }
    }

    public void publish(Event event) {
        for (DataEndpointGroup endpointGroup : this.endpointGroups) {
            endpointGroup.publish(event);
        }
    }

    public void publish(String streamId, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray) {
        this.publish(new Event(streamId, System.currentTimeMillis(), metaDataArray, correlationDataArray, payloadDataArray));
    }

    public void publish(String streamId, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray, Map<String, String> arbitraryDataMap) {
        this.publish(new Event(streamId, System.currentTimeMillis(), metaDataArray, correlationDataArray, payloadDataArray, arbitraryDataMap));
    }

    public void publish(String streamId, long timeStamp, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray) {
        this.publish(new Event(streamId, timeStamp, metaDataArray, correlationDataArray, payloadDataArray));
    }

    public void publish(String streamId, long timeStamp, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray, Map<String, String> arbitraryDataMap) {
        this.publish(new Event(streamId, timeStamp, metaDataArray, correlationDataArray, payloadDataArray, arbitraryDataMap));
    }

    private void onEventQueueFull(DataEndpointGroup endpointGroup, Event event) {
        ++this.failedEventCount;
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastFailedEventTime > 10000L) {
            log.warn("Event queue is full, unable to process the event for endpoint group " + endpointGroup.toString() + ", " + this.failedEventCount + " events dropped so far.");
            this.lastFailedEventTime = currentTime;
        }
        if (log.isDebugEnabled()) {
            log.debug("Dropped Event: " + event.toString() + " for the endpoint group " + endpointGroup.toString());
        }
    }

    public boolean tryPublish(Event event) {
        boolean sent = true;
        for (DataEndpointGroup endpointGroup : this.endpointGroups) {
            try {
                endpointGroup.tryPublish(event);
                sent = true;
            }
            catch (EventQueueFullException e) {
                this.onEventQueueFull(endpointGroup, event);
                sent = false;
            }
        }
        return sent;
    }

    public boolean tryPublish(Event event, long timeoutMS) {
        boolean sent = true;
        for (DataEndpointGroup endpointGroup : this.endpointGroups) {
            try {
                endpointGroup.tryPublish(event, timeoutMS);
            }
            catch (EventQueueFullException e) {
                this.onEventQueueFull(endpointGroup, event);
                sent = false;
            }
        }
        return sent;
    }

    public boolean tryPublish(String streamId, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray, long timeoutMS) {
        return this.tryPublish(new Event(streamId, System.currentTimeMillis(), metaDataArray, correlationDataArray, payloadDataArray), timeoutMS);
    }

    public boolean tryPublish(String streamId, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray, Map<String, String> arbitraryDataMap, long timeoutMS) {
        return this.tryPublish(new Event(streamId, System.currentTimeMillis(), metaDataArray, correlationDataArray, payloadDataArray, arbitraryDataMap), timeoutMS);
    }

    public boolean tryPublish(String streamId, long timeStamp, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray, long timeoutMS) {
        return this.tryPublish(new Event(streamId, timeStamp, metaDataArray, correlationDataArray, payloadDataArray), timeoutMS);
    }

    public boolean tryPublish(String streamId, long timeStamp, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray, Map<String, String> arbitraryDataMap, long timeoutMS) {
        return this.tryPublish(new Event(streamId, timeStamp, metaDataArray, correlationDataArray, payloadDataArray, arbitraryDataMap), timeoutMS);
    }

    public boolean tryPublish(String streamId, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray) {
        return this.tryPublish(new Event(streamId, System.currentTimeMillis(), metaDataArray, correlationDataArray, payloadDataArray));
    }

    public boolean tryPublish(String streamId, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray, Map<String, String> arbitraryDataMap) {
        return this.tryPublish(new Event(streamId, System.currentTimeMillis(), metaDataArray, correlationDataArray, payloadDataArray, arbitraryDataMap));
    }

    public boolean tryPublish(String streamId, long timeStamp, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray) {
        return this.tryPublish(new Event(streamId, timeStamp, metaDataArray, correlationDataArray, payloadDataArray));
    }

    public boolean tryPublish(String streamId, long timeStamp, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray, Map<String, String> arbitraryDataMap) {
        return this.tryPublish(new Event(streamId, timeStamp, metaDataArray, correlationDataArray, payloadDataArray, arbitraryDataMap));
    }

    public void shutdown() throws DataEndpointException {
        for (DataEndpointGroup dataEndpointGroup : this.endpointGroups) {
            dataEndpointGroup.shutdown();
        }
        this.dataEndpointAgent.shutDown(this);
    }

    public void shutdownWithAgent() throws DataEndpointException {
        this.shutdown();
        AgentHolder.shutdown();
    }
}

