/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.internal;

import org.apache.log4j.Logger;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.databridge.agent.internal.DataAgentServiceValueHolder;

@Component(name="org.wso2.carbon.databridge.agent.internal.DataAgentDS", immediate=true)
public class DataAgentDS {
    private static final Logger log = Logger.getLogger(DataAgentDS.class);

    @Activate
    protected void start() throws Exception {
        try {
            log.info("Successfully deployed Agent Server ");
        }
        catch (RuntimeException e) {
            log.error("Error in starting Agent Server ", e);
        }
    }

    @Deactivate
    protected void stop() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Successfully stopped agent server");
        }
    }

    @Reference(name="carbon.config.provider", service=ConfigProvider.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unregisterConfigProvider")
    protected void registerConfigProvider(ConfigProvider configProvider) {
        DataAgentServiceValueHolder.setConfigProvider(configProvider);
    }

    protected void unregisterConfigProvider(ConfigProvider configProvider) {
        DataAgentServiceValueHolder.setConfigProvider(null);
    }
}

