/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.analytics;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.ConfigProviderFactory;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.msf4j.analytics.internal.DataHolder;

public class AnalyticUtils {
    private static final Logger logger = LoggerFactory.getLogger(AnalyticUtils.class);
    private static final String DEPLOYMENT_YAML_SYS_PROPERTY = "msf4j.conf";
    private static final String DEPLOYMENT_YAML_FILE = "deployment.yaml";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ConfigProvider getConfigurationProvider() {
        String deploymentYamlPath;
        ConfigProvider configProvider;
        block21: {
            configProvider = DataHolder.getInstance().getConfigProvider();
            if (configProvider != null) return configProvider;
            if (DataHolder.getInstance().getBundleContext() != null) {
                throw new RuntimeException("Failed to populate HTTPMonitoringConfig Configuration. Config Provider is Null.");
            }
            deploymentYamlPath = System.getProperty(DEPLOYMENT_YAML_SYS_PROPERTY);
            if (deploymentYamlPath == null || deploymentYamlPath.isEmpty()) {
                logger.info("System property 'msf4j.conf' is not set. Default deployment.yaml file will be used.");
                deploymentYamlPath = DEPLOYMENT_YAML_FILE;
                try (InputStream configInputStream = AnalyticUtils.class.getClassLoader().getResourceAsStream(DEPLOYMENT_YAML_FILE);){
                    if (configInputStream == null) {
                        throw new RuntimeException("Couldn't find " + deploymentYamlPath);
                    }
                    if (Files.notExists(Paths.get(deploymentYamlPath, new String[0]), new LinkOption[0])) {
                        Files.copy(configInputStream, Paths.get(deploymentYamlPath, new String[0]), new CopyOption[0]);
                    }
                    break block21;
                }
                catch (IOException e) {
                    throw new RuntimeException("Couldn't read configuration from file " + deploymentYamlPath, e);
                }
            }
            if (!Files.exists(Paths.get(deploymentYamlPath, new String[0]), new LinkOption[0])) {
                throw new RuntimeException("Couldn't find " + deploymentYamlPath);
            }
        }
        try {
            configProvider = ConfigProviderFactory.getConfigProvider(Paths.get(deploymentYamlPath, new String[0]), null);
            DataHolder.getInstance().setConfigProvider(configProvider);
            return configProvider;
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Error loading deployment.yaml Configuration", e);
        }
    }
}

