/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.examples.petstore.transaction;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.core.annotation.Timed;
import org.wso2.msf4j.analytics.httpmonitoring.HTTPMonitored;
import org.wso2.msf4j.examples.petstore.util.model.Order;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@HTTPMonitored
@Path(value="/transaction")
public class TxnService {
    private static final Logger log = LoggerFactory.getLogger(TxnService.class);
    private static String REDIS_MASTER_HOST = System.getenv("REDIS_MASTER_HOST");
    private static int REDIS_MASTER_PORT = Integer.parseInt(System.getenv("REDIS_MASTER_PORT"));
    private static final JedisPool pool;

    @POST
    @Consumes(value={"application/json"})
    @Timed
    public Response addOrder(Order order) {
        String orderId = order.getId();
        try (Jedis jedis = pool.getResource();){
            String orderKey;
            if (!jedis.smembers("petstore:transaction:orders").contains(orderId)) {
                jedis.sadd("petstore:transaction:orders", orderId);
            }
            if (jedis.get(orderKey = "petstore:transaction:order." + orderId) != null) {
                Response response = Response.status(Response.Status.CONFLICT).entity("Order with ID " + orderId + " already exists").build();
                return response;
            }
            jedis.set(orderKey, new Gson().toJson(order));
            log.info("Added order");
            Response response = Response.status(Response.Status.OK).entity(new Gson().toJson(orderId)).build();
            return response;
        }
    }

    @GET
    @Path(value="/all")
    @Produces(value={"application/json"})
    @Timed
    public List<Order> getOrders(String txnId) {
        try (Jedis jedis = pool.getResource();){
            Set<String> orderKeys = jedis.smembers("petstore:transaction:orders");
            ArrayList<Order> result = new ArrayList<Order>(orderKeys.size());
            for (String orderKey : orderKeys) {
                String orderValue = jedis.get(orderKey);
                result.add(new Gson().fromJson(orderValue, Order.class));
            }
            ArrayList<Order> arrayList = result;
            return arrayList;
        }
    }

    static {
        log.info("Using Redis master:" + REDIS_MASTER_HOST + ":" + REDIS_MASTER_PORT);
        pool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), REDIS_MASTER_HOST, REDIS_MASTER_PORT);
    }
}

