/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoop;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.SocketAddress;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.Constants;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contract.config.ChunkConfig;
import org.wso2.transport.http.netty.contract.config.KeepAliveConfig;
import org.wso2.transport.http.netty.contract.exceptions.ClientClosedConnectionException;
import org.wso2.transport.http.netty.contract.exceptions.ServerConnectorException;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.listener.states.ListenerReqRespStateManager;
import org.wso2.transport.http.netty.contractimpl.listener.states.ReceivingHeaders;
import org.wso2.transport.http.netty.internal.HandlerExecutor;
import org.wso2.transport.http.netty.internal.HttpTransportContextHolder;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class SourceHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SourceHandler.class);
    private HttpCarbonMessage inboundRequestMsg;
    private final Map<Integer, HttpCarbonMessage> requestSet = new ConcurrentHashMap<Integer, HttpCarbonMessage>();
    private HandlerExecutor handlerExecutor;
    private Map<String, GenericObjectPool> targetChannelPool;
    private ChunkConfig chunkConfig;
    private KeepAliveConfig keepAliveConfig;
    private ServerConnectorFuture serverConnectorFuture;
    private String interfaceId;
    private String serverName;
    private boolean idleTimeout;
    private ChannelGroup allChannels;
    protected ChannelHandlerContext ctx;
    private SocketAddress remoteAddress;
    private boolean connectedState;
    private boolean pipeliningEnabled;
    private long pipeliningLimit;
    private long sequenceId = 1L;
    private final Queue holdingQueue = new PriorityQueue(3);
    private EventExecutorGroup pipeliningGroup;

    public SourceHandler(ServerConnectorFuture serverConnectorFuture, String interfaceId, ChunkConfig chunkConfig, KeepAliveConfig keepAliveConfig, String serverName, ChannelGroup allChannels, boolean pipeliningEnabled, long pipeliningLimit, EventExecutorGroup pipeliningGroup) {
        this.serverConnectorFuture = serverConnectorFuture;
        this.interfaceId = interfaceId;
        this.chunkConfig = chunkConfig;
        this.keepAliveConfig = keepAliveConfig;
        this.targetChannelPool = new ConcurrentHashMap<String, GenericObjectPool>();
        this.idleTimeout = false;
        this.serverName = serverName;
        this.allChannels = allChannels;
        this.pipeliningEnabled = pipeliningEnabled;
        this.pipeliningLimit = pipeliningLimit;
        this.pipeliningGroup = pipeliningGroup;
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            ListenerReqRespStateManager listenerReqRespStateManager;
            this.setConnectedState(false);
            this.inboundRequestMsg = Util.createInboundReqCarbonMsg((HttpRequest)msg, ctx, this);
            if ((long)this.requestSet.size() > this.pipeliningLimit) {
                LOG.warn("Pipelining request limit exceeded hence closing the channel {}", (Object)ctx.channel().id());
                this.closeChannel(ctx);
                return;
            }
            this.requestSet.put(this.inboundRequestMsg.hashCode(), this.inboundRequestMsg);
            this.inboundRequestMsg.listenerReqRespStateManager = listenerReqRespStateManager = new ListenerReqRespStateManager();
            this.setRequestProperties();
            this.setSequenceNumber();
            listenerReqRespStateManager.state = new ReceivingHeaders(listenerReqRespStateManager, this);
            listenerReqRespStateManager.readInboundRequestHeaders(this.inboundRequestMsg, (HttpRequest)msg);
        } else if (this.inboundRequestMsg != null) {
            this.inboundRequestMsg.listenerReqRespStateManager.readInboundRequestBody(msg);
        } else {
            LOG.warn("Inconsistent state detected : inboundRequestMsg is null for channel read event");
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        this.setConnectedState(true);
        this.ctx = ctx;
        this.allChannels.add(ctx.channel());
        this.setPipeliningProperties();
        this.handlerExecutor = HttpTransportContextHolder.getInstance().getHandlerExecutor();
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtSourceConnectionInitiation(Integer.toString(ctx.hashCode()));
        }
        this.remoteAddress = ctx.channel().remoteAddress();
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        if (!this.idleTimeout) {
            if (!this.requestSet.isEmpty()) {
                this.requestSet.forEach((key, inboundMsg) -> inboundMsg.listenerReqRespStateManager.handleAbruptChannelClosure(this.serverConnectorFuture));
            } else if (this.connectedState) {
                this.notifyErrorListenerAtConnectedState("Remote client closed the connection before initiating inbound request");
            }
        }
        this.closeTargetChannels();
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtSourceConnectionTermination(Integer.toString(ctx.hashCode()));
            this.handlerExecutor = null;
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.closeChannel(ctx);
        LOG.warn("Exception occurred in SourceHandler : {}", (Object)cause.getMessage());
    }

    private void closeTargetChannels() {
        this.targetChannelPool.forEach((hostPortKey, genericObjectPool) -> {
            try {
                this.targetChannelPool.remove(hostPortKey).close();
            }
            catch (Exception e) {
                LOG.error("Couldn't close target channel socket connections", e);
            }
        });
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof IdleStateEvent) {
            this.idleTimeout = true;
            if (!this.requestSet.isEmpty()) {
                this.requestSet.forEach((key, inboundMsg) -> {
                    ChannelFuture outboundRespFuture = inboundMsg.listenerReqRespStateManager.handleIdleTimeoutConnectionClosure(this.serverConnectorFuture, ctx);
                    if (outboundRespFuture == null) {
                        this.closeChannel(ctx);
                    }
                });
            } else {
                this.closeChannel(ctx);
                if (this.connectedState) {
                    this.notifyErrorListenerAtConnectedState("Idle timeout triggered before initiating inbound request");
                }
            }
            String channelId = ctx.channel().id().asShortText();
            LOG.debug("Idle timeout has reached hence closing the connection {}", (Object)channelId);
        } else {
            this.logTheErrorMsg(ctx, evt);
        }
    }

    private void logTheErrorMsg(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof HttpServerUpgradeHandler.UpgradeEvent) {
            LOG.debug("Server upgrade event received");
        } else if (evt instanceof SslCloseCompletionEvent) {
            LOG.debug("SSL close completion event received");
            this.setConnectedState(false);
            this.closeChannel(ctx);
        } else if (evt instanceof ChannelInputShutdownReadComplete) {
            LOG.debug("Input side of the connection is already shutdown");
        } else {
            LOG.warn("Unexpected user event {} triggered", evt);
        }
    }

    private void closeChannel(ChannelHandlerContext ctx) {
        ctx.close();
    }

    private void notifyErrorListenerAtConnectedState(String errorMsg) {
        try {
            this.serverConnectorFuture.notifyErrorListener(new ClientClosedConnectionException(errorMsg));
            LOG.debug(errorMsg);
        }
        catch (ServerConnectorException e) {
            LOG.error("Error while notifying error state to server-connector listener");
        }
    }

    private void setRequestProperties() {
        this.inboundRequestMsg.setPipeliningEnabled(this.pipeliningEnabled);
        String connectionHeaderValue = this.inboundRequestMsg.getHeader(HttpHeaderNames.CONNECTION.toString());
        String httpVersion = this.inboundRequestMsg.getHttpVersion();
        this.inboundRequestMsg.setKeepAlive(Util.isKeepAliveConnection(this.keepAliveConfig, connectionHeaderValue, httpVersion));
    }

    private void setPipeliningProperties() {
        if (this.ctx.channel().attr(Constants.MAX_RESPONSES_ALLOWED_TO_BE_QUEUED).get() == null) {
            this.ctx.channel().attr(Constants.MAX_RESPONSES_ALLOWED_TO_BE_QUEUED).set(this.pipeliningLimit);
        }
        if (this.ctx.channel().attr(Constants.RESPONSE_QUEUE).get() == null) {
            this.ctx.channel().attr(Constants.RESPONSE_QUEUE).set(this.holdingQueue);
        }
        if (this.ctx.channel().attr(Constants.NEXT_SEQUENCE_NUMBER).get() == null) {
            this.ctx.channel().attr(Constants.NEXT_SEQUENCE_NUMBER).set(1L);
        }
        if (this.ctx.channel().attr(Constants.PIPELINING_EXECUTOR).get() == null) {
            this.ctx.channel().attr(Constants.PIPELINING_EXECUTOR).set(this.pipeliningGroup);
        }
    }

    private void setSequenceNumber() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sequence id of the request is set to : {}", (Object)this.sequenceId);
        }
        this.inboundRequestMsg.setSequenceId(this.sequenceId);
        ++this.sequenceId;
    }

    public EventLoop getEventLoop() {
        return this.ctx.channel().eventLoop();
    }

    public Map<String, GenericObjectPool> getTargetChannelPool() {
        return this.targetChannelPool;
    }

    public ChannelHandlerContext getInboundChannelContext() {
        return this.ctx;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getInterfaceId() {
        return this.interfaceId;
    }

    public ServerConnectorFuture getServerConnectorFuture() {
        return this.serverConnectorFuture;
    }

    public ChunkConfig getChunkConfig() {
        return this.chunkConfig;
    }

    public KeepAliveConfig getKeepAliveConfig() {
        return this.keepAliveConfig;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setConnectedState(boolean connectedState) {
        this.connectedState = connectedState;
    }

    public void removeRequestEntry(HttpCarbonMessage inboundRequestMsg) {
        this.requestSet.remove(inboundRequestMsg.hashCode());
    }

    public void resetInboundRequestMsg() {
        this.inboundRequestMsg = null;
    }
}

