/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCounted;
import java.util.LinkedList;

public class ResponseEntityBodySizeValidator
extends ChannelInboundHandlerAdapter {
    private long maxEntityBodySize;
    private long currentSize;
    private HttpResponse inboundResponse;
    private LinkedList<HttpContent> fullContent;

    public ResponseEntityBodySizeValidator(long maxEntityBodySize) {
        this.maxEntityBodySize = maxEntityBodySize;
        this.fullContent = new LinkedList();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (ctx.channel().isActive()) {
            if (msg instanceof HttpResponse) {
                this.inboundResponse = (HttpResponse)msg;
                if (this.isContentLengthInvalid(this.inboundResponse, this.maxEntityBodySize)) {
                    this.releaseContentAndNotifyError();
                    return;
                }
                ctx.channel().read();
            } else {
                HttpContent inboundContent = (HttpContent)msg;
                this.currentSize += (long)inboundContent.content().readableBytes();
                this.fullContent.add(inboundContent);
                if (this.currentSize > this.maxEntityBodySize) {
                    this.releaseContentAndNotifyError();
                } else if (msg instanceof LastHttpContent) {
                    super.channelRead(ctx, this.inboundResponse);
                    while (!this.fullContent.isEmpty()) {
                        super.channelRead(ctx, this.fullContent.pop());
                    }
                } else {
                    ctx.channel().read();
                }
            }
        }
    }

    private void releaseContentAndNotifyError() {
        this.fullContent.forEach(ReferenceCounted::release);
        this.fullContent.forEach(httpContent -> this.fullContent.remove(httpContent));
        throw new RuntimeException("Response max entity body size exceeds: Entity body is larger than " + this.maxEntityBodySize + " bytes. ");
    }

    private boolean isContentLengthInvalid(HttpMessage start, long maxContentLength) {
        try {
            return HttpUtil.getContentLength(start, -1L) > maxContentLength;
        }
        catch (NumberFormatException var4) {
            return false;
        }
    }
}

