/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.criteria.predicate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.hibernate.jpa.criteria.CriteriaBuilderImpl;
import org.hibernate.jpa.criteria.ParameterContainer;
import org.hibernate.jpa.criteria.ParameterRegistry;
import org.hibernate.jpa.criteria.Renderable;
import org.hibernate.jpa.criteria.compile.RenderingContext;
import org.hibernate.jpa.criteria.predicate.AbstractPredicateImpl;
import org.hibernate.jpa.criteria.predicate.NegatedPredicateWrapper;
import org.hibernate.jpa.criteria.predicate.PredicateImplementor;

public class CompoundPredicate
extends AbstractPredicateImpl
implements Serializable {
    private Predicate.BooleanOperator operator;
    private final List<Expression<Boolean>> expressions = new ArrayList<Expression<Boolean>>();

    public CompoundPredicate(CriteriaBuilderImpl criteriaBuilder, Predicate.BooleanOperator operator) {
        super(criteriaBuilder);
        this.operator = operator;
    }

    public CompoundPredicate(CriteriaBuilderImpl criteriaBuilder, Predicate.BooleanOperator operator, Expression<Boolean> ... expressions) {
        this(criteriaBuilder, operator);
        this.applyExpressions(expressions);
    }

    public CompoundPredicate(CriteriaBuilderImpl criteriaBuilder, Predicate.BooleanOperator operator, List<Expression<Boolean>> expressions) {
        this(criteriaBuilder, operator);
        this.applyExpressions(expressions);
    }

    private void applyExpressions(Expression<Boolean> ... expressions) {
        this.applyExpressions(Arrays.asList(expressions));
    }

    private void applyExpressions(List<Expression<Boolean>> expressions) {
        this.expressions.clear();
        this.expressions.addAll(expressions);
    }

    @Override
    public Predicate.BooleanOperator getOperator() {
        return this.operator;
    }

    @Override
    public List<Expression<Boolean>> getExpressions() {
        return this.expressions;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        for (Expression<Boolean> expression : this.getExpressions()) {
            ParameterContainer.Helper.possibleParameter(expression, registry);
        }
    }

    @Override
    public String render(RenderingContext renderingContext) {
        return this.render(this.isNegated(), renderingContext);
    }

    @Override
    public boolean isJunction() {
        return true;
    }

    @Override
    public String render(boolean isNegated, RenderingContext renderingContext) {
        return CompoundPredicate.render(this, renderingContext);
    }

    private String operatorTextWithSeparator() {
        return CompoundPredicate.operatorTextWithSeparator(this.getOperator());
    }

    @Override
    public String renderProjection(RenderingContext renderingContext) {
        return this.render(renderingContext);
    }

    @Override
    public Predicate not() {
        return new NegatedPredicateWrapper(this);
    }

    private void toggleOperator() {
        this.operator = CompoundPredicate.reverseOperator(this.operator);
    }

    public static Predicate.BooleanOperator reverseOperator(Predicate.BooleanOperator operator) {
        return operator == Predicate.BooleanOperator.AND ? Predicate.BooleanOperator.OR : Predicate.BooleanOperator.AND;
    }

    public static String render(PredicateImplementor predicate, RenderingContext renderingContext) {
        if (!predicate.isJunction()) {
            throw new IllegalStateException("CompoundPredicate.render should only be used to render junctions");
        }
        if (predicate.getExpressions().isEmpty()) {
            boolean implicitTrue = predicate.getOperator() == Predicate.BooleanOperator.AND;
            return implicitTrue ? "1=1" : "0=1";
        }
        if (predicate.getExpressions().size() == 1) {
            return ((Renderable)((Object)predicate.getExpressions().get(0))).render(renderingContext);
        }
        StringBuilder buffer = new StringBuilder();
        String sep = "";
        for (Expression<Boolean> expression : predicate.getExpressions()) {
            buffer.append(sep).append("( ").append(((Renderable)((Object)expression)).render(renderingContext)).append(" )");
            sep = CompoundPredicate.operatorTextWithSeparator(predicate.getOperator());
        }
        return buffer.toString();
    }

    private static String operatorTextWithSeparator(Predicate.BooleanOperator operator) {
        return operator == Predicate.BooleanOperator.AND ? " and " : " or ";
    }
}

