/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.example.dao;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import org.wso2.msf4j.example.model.User;

public abstract class AbstractRepository<T> {
    private EntityManagerFactory emf;

    public AbstractRepository(EntityManagerFactory emf) {
        this.emf = emf;
    }

    protected EntityManager getEntityManager() {
        return this.emf.createEntityManager();
    }

    protected void create(T t) {
        EntityManager manager = this.getEntityManager();
        manager.getTransaction().begin();
        manager.persist(t);
        manager.getTransaction().commit();
        manager.close();
    }

    protected void remove(T t) {
        EntityManager manager = this.getEntityManager();
        manager.getTransaction().begin();
        manager.remove(t);
        manager.getTransaction().commit();
        manager.close();
    }

    protected User find(long id) {
        return this.getEntityManager().find(User.class, id);
    }

    protected List<T> findAll(Class<T> clazz) {
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery<T> cq = cb.createQuery(clazz);
        Root<T> rootEntry = cq.from(clazz);
        CriteriaQuery<T> all = cq.select(rootEntry);
        TypedQuery<T> allQuery = this.getEntityManager().createQuery(all);
        return allQuery.getResultList();
    }
}

