/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.message;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.BufferFactory;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

public class HttpMessageDataStreamer {
    private static final Logger LOG = LoggerFactory.getLogger(HttpMessageDataStreamer.class);
    private HTTPCarbonMessage httpCarbonMessage;
    private ByteBufferInputStream byteBufferInputStream;
    private ByteBufferOutputStream byteBufferOutputStream;

    public HttpMessageDataStreamer(HTTPCarbonMessage httpCarbonMessage) {
        this.httpCarbonMessage = httpCarbonMessage;
    }

    public OutputStream getOutputStream() {
        if (this.byteBufferOutputStream == null) {
            this.byteBufferOutputStream = new ByteBufferOutputStream();
        }
        return this.byteBufferOutputStream;
    }

    private InputStream createInputStreamIfNull() {
        if (this.byteBufferInputStream == null) {
            this.byteBufferInputStream = new ByteBufferInputStream();
        }
        return this.byteBufferInputStream;
    }

    public InputStream getInputStream() {
        String contentEncodingHeader = this.httpCarbonMessage.getHeader("Content-Encoding");
        if (contentEncodingHeader != null) {
            this.httpCarbonMessage.removeHeader("Content-Encoding");
            try {
                if (contentEncodingHeader.equalsIgnoreCase("gzip")) {
                    return new GZIPInputStream(this.createInputStreamIfNull());
                }
                if (contentEncodingHeader.equalsIgnoreCase("deflate")) {
                    return new InflaterInputStream(this.createInputStreamIfNull());
                }
                LOG.warn("Unknown Content-Encoding: " + contentEncodingHeader);
            }
            catch (IOException e) {
                LOG.error("Error while creating inputStream for content-encoding: " + contentEncodingHeader, e);
            }
        }
        return this.createInputStreamIfNull();
    }

    protected class ByteBufferOutputStream
    extends OutputStream {
        private ByteBuffer buffer;

        protected ByteBufferOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            if (this.buffer == null) {
                this.buffer = BufferFactory.getInstance().getBuffer();
            }
            if (this.buffer.hasRemaining()) {
                this.buffer.put((byte)b);
            } else {
                this.buffer.flip();
                HttpMessageDataStreamer.this.httpCarbonMessage.addHttpContent(new DefaultHttpContent(Unpooled.wrappedBuffer(this.buffer)));
                this.buffer = BufferFactory.getInstance().getBuffer();
                this.buffer.put((byte)b);
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.buffer != null && this.buffer.position() > 0) {
                this.buffer.flip();
                HttpMessageDataStreamer.this.httpCarbonMessage.addHttpContent(new DefaultHttpContent(Unpooled.wrappedBuffer(this.buffer)));
                this.buffer = BufferFactory.getInstance().getBuffer();
            }
        }

        @Override
        public void close() {
            try {
                this.flush();
                HttpMessageDataStreamer.this.httpCarbonMessage.addHttpContent(new DefaultLastHttpContent());
                super.close();
            }
            catch (IOException e) {
                LOG.error("Error while closing output stream but underlying resources are reset", e);
            }
            finally {
                HttpMessageDataStreamer.this.byteBufferOutputStream = null;
                this.buffer = null;
            }
        }
    }

    protected class ByteBufferInputStream
    extends InputStream {
        private int count;
        private boolean chunkFinished = true;
        private int limit;
        private ByteBuffer byteBuffer;
        private HttpContent httpContent;

        protected ByteBufferInputStream() {
        }

        @Override
        public int read() throws IOException {
            HttpMessageDataStreamer.this.httpCarbonMessage.setAlreadyRead(true);
            if (this.httpContent instanceof LastHttpContent && this.chunkFinished) {
                return -1;
            }
            if (this.chunkFinished) {
                this.httpContent = HttpMessageDataStreamer.this.httpCarbonMessage.getHttpContent();
                this.byteBuffer = this.httpContent.content().nioBuffer();
                this.count = 0;
                this.limit = this.byteBuffer.limit();
                if (this.limit == 0) {
                    return -1;
                }
                this.chunkFinished = false;
            }
            ++this.count;
            if (this.count == this.limit) {
                int value = this.byteBuffer.get() & 0xFF;
                this.chunkFinished = true;
                this.byteBuffer = null;
                this.httpContent.release();
                return value;
            }
            return this.byteBuffer.get() & 0xFF;
        }
    }
}

