/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityGraph;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceException;
import javax.persistence.SynchronizationType;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.transaction.SystemException;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.ejb.AbstractEntityManagerImpl;
import org.hibernate.engine.spi.SessionBuilderImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SessionOwner;
import org.hibernate.internal.SessionImpl;
import org.hibernate.jpa.graph.internal.EntityGraphImpl;
import org.hibernate.jpa.internal.EntityManagerFactoryImpl;
import org.hibernate.jpa.internal.EntityManagerMessageLogger;
import org.hibernate.jpa.internal.HEMLogging;
import org.hibernate.resource.transaction.backend.jta.internal.synchronization.AfterCompletionAction;
import org.hibernate.resource.transaction.backend.jta.internal.synchronization.ExceptionMapper;
import org.hibernate.resource.transaction.backend.jta.internal.synchronization.ManagedFlushChecker;

public class EntityManagerImpl
extends AbstractEntityManagerImpl
implements SessionOwner {
    public static final EntityManagerMessageLogger LOG = HEMLogging.messageLogger(EntityManagerImpl.class.getName());
    protected Session session;
    protected boolean open = true;
    protected boolean discardOnClose;
    private Class sessionInterceptorClass;

    public EntityManagerImpl(EntityManagerFactoryImpl entityManagerFactory, PersistenceContextType pcType, SynchronizationType synchronizationType, PersistenceUnitTransactionType transactionType, boolean discardOnClose, Class sessionInterceptorClass, Map properties) {
        super(entityManagerFactory, pcType, synchronizationType, transactionType, properties);
        this.discardOnClose = discardOnClose;
        Object localSessionInterceptor = null;
        if (properties != null) {
            localSessionInterceptor = properties.get("hibernate.ejb.interceptor.session_scoped");
        }
        if (localSessionInterceptor != null) {
            if (localSessionInterceptor instanceof Class) {
                sessionInterceptorClass = localSessionInterceptor;
            } else if (localSessionInterceptor instanceof String) {
                ClassLoaderService cls = entityManagerFactory.getSessionFactory().getServiceRegistry().getService(ClassLoaderService.class);
                try {
                    sessionInterceptorClass = cls.classForName(localSessionInterceptor);
                }
                catch (ClassLoadingException e) {
                    throw new PersistenceException("Unable to instanciate interceptor: " + localSessionInterceptor, e);
                }
            } else {
                throw new PersistenceException("Unable to instanciate interceptor: " + localSessionInterceptor);
            }
        }
        this.sessionInterceptorClass = sessionInterceptorClass;
        this.postInit();
    }

    @Override
    protected void checkOpen() {
        this.checkOpen(true);
    }

    @Override
    public void checkOpen(boolean markForRollbackIfClosed) {
        if (!this.isOpen()) {
            if (markForRollbackIfClosed) {
                this.markForRollbackOnly();
            }
            throw new IllegalStateException("EntityManager is closed");
        }
    }

    @Override
    public Session getSession() {
        this.checkOpen();
        return this.internalGetSession();
    }

    @Override
    protected Session getRawSession() {
        return this.internalGetSession();
    }

    @Override
    protected Session internalGetSession() {
        if (this.session == null) {
            SessionBuilderImplementor sessionBuilder = this.internalGetEntityManagerFactory().getSessionFactory().withOptions();
            sessionBuilder.owner(this);
            if (this.sessionInterceptorClass != null) {
                try {
                    Interceptor interceptor = (Interceptor)this.sessionInterceptorClass.newInstance();
                    sessionBuilder.interceptor(interceptor);
                }
                catch (InstantiationException e) {
                    throw new PersistenceException("Unable to instantiate session interceptor: " + this.sessionInterceptorClass, e);
                }
                catch (IllegalAccessException e) {
                    throw new PersistenceException("Unable to instantiate session interceptor: " + this.sessionInterceptorClass, e);
                }
                catch (ClassCastException e) {
                    throw new PersistenceException("Session interceptor does not implement Interceptor: " + this.sessionInterceptorClass, e);
                }
            }
            sessionBuilder.autoJoinTransactions(this.getSynchronizationType() == SynchronizationType.SYNCHRONIZED);
            this.session = sessionBuilder.openSession();
        }
        return this.session;
    }

    @Override
    public void close() {
        this.checkEntityManagerFactory();
        this.checkOpen();
        if ((this.discardOnClose || !this.isTransactionInProgress()) && this.session != null) {
            this.session.close();
        }
        this.open = false;
    }

    @Override
    public boolean isOpen() {
        this.checkEntityManagerFactory();
        try {
            if (this.open) {
                this.internalGetSession().isOpen();
            }
            return this.open;
        }
        catch (HibernateException he) {
            this.throwPersistenceException(he);
            return false;
        }
    }

    @Override
    public <T> EntityGraph<T> createEntityGraph(Class<T> rootType) {
        this.checkOpen();
        return new EntityGraphImpl<T>(null, this.getMetamodel().entity(rootType), this.getEntityManagerFactory());
    }

    @Override
    public EntityGraph<?> createEntityGraph(String graphName) {
        this.checkOpen();
        EntityGraphImpl named = this.getEntityManagerFactory().findEntityGraphByName(graphName);
        if (named == null) {
            return null;
        }
        return named.makeMutableCopy();
    }

    @Override
    public EntityGraph<?> getEntityGraph(String graphName) {
        this.checkOpen();
        EntityGraphImpl named = this.getEntityManagerFactory().findEntityGraphByName(graphName);
        if (named == null) {
            throw new IllegalArgumentException("Could not locate EntityGraph with given name : " + graphName);
        }
        return named;
    }

    @Override
    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> entityClass) {
        this.checkOpen();
        return this.getEntityManagerFactory().findEntityGraphsByType(entityClass);
    }

    @Override
    public boolean shouldAutoCloseSession() {
        return !this.isOpen();
    }

    @Override
    public ExceptionMapper getExceptionMapper() {
        return new CallbackExceptionMapperImpl();
    }

    @Override
    public AfterCompletionAction getAfterCompletionAction() {
        return new AfterCompletionActionImpl();
    }

    @Override
    public ManagedFlushChecker getManagedFlushChecker() {
        return new ManagedFlushCheckerImpl();
    }

    private void checkEntityManagerFactory() {
        if (!this.internalGetEntityManagerFactory().isOpen()) {
            this.open = false;
        }
    }

    private boolean isManualFlushMode(FlushMode mode) {
        return FlushMode.MANUAL == mode;
    }

    private class ManagedFlushCheckerImpl
    implements ManagedFlushChecker {
        private ManagedFlushCheckerImpl() {
        }

        @Override
        public boolean shouldDoManagedFlush(SessionImpl session) {
            return !session.isClosed() && !EntityManagerImpl.this.isManualFlushMode(session.getFlushMode());
        }
    }

    private class AfterCompletionActionImpl
    implements AfterCompletionAction {
        private AfterCompletionActionImpl() {
        }

        @Override
        public void doAction(boolean successful) {
            if (((SessionImplementor)((Object)EntityManagerImpl.this.session)).isClosed()) {
                LOG.trace("Session was closed; nothing to do");
                return;
            }
            if (!successful && EntityManagerImpl.this.getTransactionType() == PersistenceUnitTransactionType.JTA) {
                EntityManagerImpl.this.session.clear();
            }
        }
    }

    private class CallbackExceptionMapperImpl
    implements ExceptionMapper {
        private CallbackExceptionMapperImpl() {
        }

        @Override
        public RuntimeException mapStatusCheckFailure(String message, SystemException systemException) {
            throw new PersistenceException(message, systemException);
        }

        @Override
        public RuntimeException mapManagedFlushFailure(String message, RuntimeException failure) {
            if (HibernateException.class.isInstance(failure)) {
                throw EntityManagerImpl.this.convert(failure);
            }
            if (PersistenceException.class.isInstance(failure)) {
                throw failure;
            }
            throw new PersistenceException(message, failure);
        }
    }
}

