/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.jdbc.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.ConnectionAcquisitionMode;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.ResourceClosedException;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.resource.jdbc.ResourceRegistry;
import org.hibernate.resource.jdbc.internal.AbstractLogicalConnectionImplementor;
import org.hibernate.resource.jdbc.internal.ResourceRegistryStandardImpl;
import org.hibernate.resource.jdbc.spi.JdbcObserver;
import org.hibernate.resource.jdbc.spi.JdbcSessionContext;
import org.hibernate.resource.jdbc.spi.LogicalConnectionImplementor;
import org.jboss.logging.Logger;

public class LogicalConnectionManagedImpl
extends AbstractLogicalConnectionImplementor {
    private static final Logger log = Logger.getLogger(LogicalConnectionManagedImpl.class);
    private final transient JdbcConnectionAccess jdbcConnectionAccess;
    private final transient JdbcObserver observer;
    private final transient SqlExceptionHelper sqlExceptionHelper;
    private final transient ConnectionReleaseMode connectionReleaseMode;
    private transient Connection physicalConnection;
    private boolean closed;
    boolean initiallyAutoCommit;

    public LogicalConnectionManagedImpl(JdbcConnectionAccess jdbcConnectionAccess, JdbcSessionContext jdbcSessionContext) {
        this(jdbcConnectionAccess, jdbcSessionContext, new ResourceRegistryStandardImpl());
    }

    public LogicalConnectionManagedImpl(JdbcConnectionAccess jdbcConnectionAccess, JdbcSessionContext jdbcSessionContext, ResourceRegistry resourceRegistry) {
        this.jdbcConnectionAccess = jdbcConnectionAccess;
        this.observer = jdbcSessionContext.getObserver();
        this.sqlExceptionHelper = jdbcSessionContext.getServiceRegistry().getService(JdbcServices.class).getSqlExceptionHelper();
        this.connectionReleaseMode = jdbcSessionContext.getConnectionReleaseMode();
        this.resourceRegistry = resourceRegistry;
        if (jdbcSessionContext.getConnectionAcquisitionMode() == ConnectionAcquisitionMode.IMMEDIATELY) {
            if (jdbcSessionContext.getConnectionReleaseMode() != ConnectionReleaseMode.ON_CLOSE) {
                throw new IllegalStateException("Illegal combination of ConnectionAcquisitionMode#IMMEDIATELY with !ConnectionReleaseMode.ON_CLOSE");
            }
            this.acquireConnectionIfNeeded();
        }
    }

    private LogicalConnectionManagedImpl(JdbcConnectionAccess jdbcConnectionAccess, JdbcSessionContext jdbcSessionContext, boolean closed) {
        this(jdbcConnectionAccess, jdbcSessionContext, new ResourceRegistryStandardImpl());
        this.closed = closed;
    }

    private Connection acquireConnectionIfNeeded() {
        if (this.physicalConnection == null) {
            this.observer.jdbcConnectionAcquisitionStart();
            try {
                this.physicalConnection = this.jdbcConnectionAccess.obtainConnection();
            }
            catch (SQLException e) {
                throw this.sqlExceptionHelper.convert(e, "Unable to acquire JDBC Connection");
            }
            finally {
                this.observer.jdbcConnectionAcquisitionEnd(this.physicalConnection);
            }
        }
        return this.physicalConnection;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public boolean isPhysicallyConnected() {
        return this.physicalConnection != null;
    }

    @Override
    public Connection getPhysicalConnection() {
        this.errorIfClosed();
        return this.acquireConnectionIfNeeded();
    }

    @Override
    public void afterStatement() {
        super.afterStatement();
        if (this.connectionReleaseMode == ConnectionReleaseMode.AFTER_STATEMENT) {
            if (this.getResourceRegistry().hasRegisteredResources()) {
                log.debug("Skipping aggressive release of JDBC Connection after-statement due to held resources");
            } else {
                log.debug("Initiating JDBC connection release from afterStatement");
                this.releaseConnection();
            }
        }
    }

    @Override
    public void afterTransaction() {
        super.afterTransaction();
        if (this.connectionReleaseMode != ConnectionReleaseMode.ON_CLOSE) {
            log.debug("Initiating JDBC connection release from afterTransaction");
            this.releaseConnection();
        }
    }

    @Override
    public Connection manualDisconnect() {
        if (this.closed) {
            throw new ResourceClosedException("Logical connection is closed");
        }
        Connection c = this.physicalConnection;
        this.releaseConnection();
        return c;
    }

    @Override
    public void manualReconnect(Connection suppliedConnection) {
        if (this.closed) {
            throw new ResourceClosedException("Logical connection is closed");
        }
        throw new IllegalStateException("Cannot manually reconnect unless Connection was originally supplied by user");
    }

    private void releaseConnection() {
        if (this.physicalConnection == null) {
            return;
        }
        this.observer.jdbcConnectionReleaseStart();
        try {
            if (!this.physicalConnection.isClosed()) {
                this.sqlExceptionHelper.logAndClearWarnings(this.physicalConnection);
            }
            this.jdbcConnectionAccess.releaseConnection(this.physicalConnection);
        }
        catch (SQLException e) {
            throw this.sqlExceptionHelper.convert(e, "Unable to release JDBC Connection");
        }
        finally {
            this.observer.jdbcConnectionReleaseEnd();
            this.physicalConnection = null;
            this.getResourceRegistry().releaseResources();
        }
    }

    @Override
    public LogicalConnectionImplementor makeShareableCopy() {
        this.errorIfClosed();
        return null;
    }

    @Override
    public void serialize(ObjectOutputStream oos) throws IOException {
        oos.writeBoolean(this.closed);
    }

    public static LogicalConnectionManagedImpl deserialize(ObjectInputStream ois, JdbcConnectionAccess jdbcConnectionAccess, JdbcSessionContext jdbcSessionContext) throws IOException, ClassNotFoundException {
        boolean isClosed = ois.readBoolean();
        return new LogicalConnectionManagedImpl(jdbcConnectionAccess, jdbcSessionContext, isClosed);
    }

    @Override
    public Connection close() {
        if (this.closed) {
            return null;
        }
        this.getResourceRegistry().releaseResources();
        log.trace("Closing logical connection");
        try {
            this.releaseConnection();
        }
        finally {
            this.closed = true;
            log.trace("Logical connection closed");
        }
        return null;
    }

    @Override
    protected Connection getConnectionForTransactionManagement() {
        return this.getPhysicalConnection();
    }

    @Override
    public void begin() {
        this.initiallyAutoCommit = LogicalConnectionManagedImpl.determineInitialAutoCommitMode(this.getConnectionForTransactionManagement());
        super.begin();
    }

    @Override
    protected void afterCompletion() {
        this.afterTransaction();
        this.resetConnection(this.initiallyAutoCommit);
        this.initiallyAutoCommit = false;
    }
}

