/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.jdbc.internal;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.resource.jdbc.ResourceRegistry;

public class ResourceRegistryStandardImpl
implements ResourceRegistry {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(ResourceRegistryStandardImpl.class);
    private final Map<Statement, Set<ResultSet>> xref = new HashMap<Statement, Set<ResultSet>>();
    private final Set<ResultSet> unassociatedResultSets = new HashSet<ResultSet>();
    private List<Blob> blobs;
    private List<Clob> clobs;
    private List<NClob> nclobs;
    private Statement lastQuery;

    @Override
    public boolean hasRegisteredResources() {
        return this.hasRegistered(this.xref) || this.hasRegistered(this.unassociatedResultSets) || this.hasRegistered(this.blobs) || this.hasRegistered(this.clobs) || this.hasRegistered(this.nclobs);
    }

    @Override
    public void register(Statement statement, boolean cancelable) {
        log.tracef("Registering statement [%s]", (Object)statement);
        if (this.xref.containsKey(statement)) {
            throw new HibernateException("JDBC Statement already registered");
        }
        this.xref.put(statement, null);
        if (cancelable) {
            this.lastQuery = statement;
        }
    }

    @Override
    public void release(Statement statement) {
        log.tracev("Releasing statement [{0}]", (Object)statement);
        if (log.isDebugEnabled() && !this.xref.containsKey(statement)) {
            log.unregisteredStatement();
        } else {
            Set<ResultSet> resultSets = this.xref.get(statement);
            if (resultSets != null) {
                this.closeAll(resultSets);
            }
            this.xref.remove(statement);
        }
        ResourceRegistryStandardImpl.close(statement);
        if (this.lastQuery == statement) {
            this.lastQuery = null;
        }
    }

    @Override
    public void release(ResultSet resultSet, Statement statement) {
        log.tracef("Releasing result set [%s]", (Object)resultSet);
        if (statement == null) {
            try {
                statement = resultSet.getStatement();
            }
            catch (SQLException e) {
                throw this.convert(e, "unable to access Statement from ResultSet");
            }
        }
        if (statement != null) {
            Set<ResultSet> resultSets = this.xref.get(statement);
            if (resultSets == null) {
                log.unregisteredStatement();
            } else {
                resultSets.remove(resultSet);
                if (resultSets.isEmpty()) {
                    this.xref.remove(statement);
                }
            }
        } else {
            boolean removed = this.unassociatedResultSets.remove(resultSet);
            if (!removed) {
                log.unregisteredResultSetWithoutStatement();
            }
        }
        ResourceRegistryStandardImpl.close(resultSet);
    }

    protected void closeAll(Set<ResultSet> resultSets) {
        for (ResultSet resultSet : resultSets) {
            ResourceRegistryStandardImpl.close(resultSet);
        }
        resultSets.clear();
    }

    public static void close(ResultSet resultSet) {
        log.tracef("Closing result set [%s]", (Object)resultSet);
        try {
            resultSet.close();
        }
        catch (SQLException e) {
            log.debugf("Unable to release JDBC result set [%s]", (Object)e.getMessage());
        }
        catch (Exception e) {
            log.debugf("Unable to release JDBC result set [%s]", (Object)e.getMessage());
        }
    }

    public static void close(Statement statement) {
        log.tracef("Closing prepared statement [%s]", (Object)statement);
        try {
            try {
                if (statement.getMaxRows() != 0) {
                    statement.setMaxRows(0);
                }
                if (statement.getQueryTimeout() != 0) {
                    statement.setQueryTimeout(0);
                }
            }
            catch (SQLException sqle) {
                if (log.isDebugEnabled()) {
                    log.debugf("Exception clearing maxRows/queryTimeout [%s]", (Object)sqle.getMessage());
                }
                return;
            }
            statement.close();
        }
        catch (SQLException e) {
            log.debugf("Unable to release JDBC statement [%s]", (Object)e.getMessage());
        }
        catch (Exception e) {
            log.debugf("Unable to release JDBC statement [%s]", (Object)e.getMessage());
        }
    }

    @Override
    public void register(ResultSet resultSet, Statement statement) {
        log.tracef("Registering result set [%s]", (Object)resultSet);
        if (statement == null) {
            try {
                statement = resultSet.getStatement();
            }
            catch (SQLException e) {
                throw this.convert(e, "unable to access Statement from ResultSet");
            }
        }
        if (statement != null) {
            Set<ResultSet> resultSets;
            if (log.isDebugEnabled() && !this.xref.containsKey(statement)) {
                log.debug("ResultSet statement was not registered (on register)");
            }
            if ((resultSets = this.xref.get(statement)) == null) {
                resultSets = new HashSet<ResultSet>();
                this.xref.put(statement, resultSets);
            }
            resultSets.add(resultSet);
        } else {
            this.unassociatedResultSets.add(resultSet);
        }
    }

    private JDBCException convert(SQLException e, String s) {
        return null;
    }

    @Override
    public void register(Blob blob) {
        if (this.blobs == null) {
            this.blobs = new ArrayList<Blob>();
        }
        this.blobs.add(blob);
    }

    @Override
    public void release(Blob blob) {
        if (this.blobs == null) {
            log.debug("Request to release Blob, but appears no Blobs have ever been registered");
            return;
        }
        this.blobs.remove(blob);
    }

    @Override
    public void register(Clob clob) {
        if (this.clobs == null) {
            this.clobs = new ArrayList<Clob>();
        }
        this.clobs.add(clob);
    }

    @Override
    public void release(Clob clob) {
        if (this.clobs == null) {
            log.debug("Request to release Clob, but appears no Clobs have ever been registered");
            return;
        }
        this.clobs.remove(clob);
    }

    @Override
    public void register(NClob nclob) {
        if (this.nclobs == null) {
            this.nclobs = new ArrayList<NClob>();
        }
        this.nclobs.add(nclob);
    }

    @Override
    public void release(NClob nclob) {
        if (this.nclobs == null) {
            log.debug("Request to release NClob, but appears no NClobs have ever been registered");
            return;
        }
        this.nclobs.remove(nclob);
    }

    @Override
    public void cancelLastQuery() {
        try {
            if (this.lastQuery != null) {
                this.lastQuery.cancel();
            }
        }
        catch (SQLException e) {
            throw this.convert(e, "Cannot cancel query");
        }
        finally {
            this.lastQuery = null;
        }
    }

    @Override
    public void releaseResources() {
        log.trace("Releasing JDBC resources");
        for (Map.Entry<Statement, Set<ResultSet>> entry : this.xref.entrySet()) {
            if (entry.getValue() != null) {
                this.closeAll(entry.getValue());
            }
            ResourceRegistryStandardImpl.close(entry.getKey());
        }
        this.xref.clear();
        this.closeAll(this.unassociatedResultSets);
        if (this.blobs != null) {
            for (Blob blob : this.blobs) {
                try {
                    blob.free();
                }
                catch (SQLException e) {
                    log.debugf("Unable to free JDBC Blob reference [%s]", (Object)e.getMessage());
                }
            }
            this.blobs.clear();
        }
        if (this.clobs != null) {
            for (Clob clob : this.clobs) {
                try {
                    clob.free();
                }
                catch (SQLException e) {
                    log.debugf("Unable to free JDBC Clob reference [%s]", (Object)e.getMessage());
                }
            }
            this.clobs.clear();
        }
        if (this.nclobs != null) {
            for (NClob nclob : this.nclobs) {
                try {
                    nclob.free();
                }
                catch (SQLException e) {
                    log.debugf("Unable to free JDBC NClob reference [%s]", (Object)e.getMessage());
                }
            }
            this.nclobs.clear();
        }
    }

    private boolean hasRegistered(Map resource) {
        return resource != null && !resource.isEmpty();
    }

    private boolean hasRegistered(Collection resource) {
        return resource != null && !resource.isEmpty();
    }
}

