/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.transaction.backend.jta.internal;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.transaction.spi.IsolationDelegate;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.jdbc.WorkExecutor;
import org.hibernate.jdbc.WorkExecutorVisitable;

public class JtaIsolationDelegate
implements IsolationDelegate {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(JtaIsolationDelegate.class);
    private final JdbcConnectionAccess connectionAccess;
    private final SqlExceptionHelper sqlExceptionHelper;
    private final TransactionManager transactionManager;

    public JtaIsolationDelegate(JdbcConnectionAccess connectionAccess, SqlExceptionHelper sqlExceptionHelper, TransactionManager transactionManager) {
        this.connectionAccess = connectionAccess;
        this.sqlExceptionHelper = sqlExceptionHelper;
        this.transactionManager = transactionManager;
    }

    protected JdbcConnectionAccess jdbcConnectionAccess() {
        return this.connectionAccess;
    }

    protected SqlExceptionHelper sqlExceptionHelper() {
        return this.sqlExceptionHelper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T delegateWork(WorkExecutorVisitable<T> work, boolean transacted) throws HibernateException {
        try {
            Transaction surroundingTransaction = this.transactionManager.suspend();
            LOG.debugf("Surrounding JTA transaction suspended [%s]", (Object)surroundingTransaction);
            boolean hadProblems = false;
            try {
                if (transacted) {
                    T t = this.doTheWorkInNewTransaction(work, this.transactionManager);
                    return t;
                }
                T t = this.doTheWorkInNoTransaction(work);
                return t;
            }
            catch (HibernateException e) {
                hadProblems = true;
                throw e;
            }
            finally {
                block15: {
                    try {
                        this.transactionManager.resume(surroundingTransaction);
                        LOG.debugf("Surrounding JTA transaction resumed [%s]", (Object)surroundingTransaction);
                    }
                    catch (Throwable t) {
                        if (hadProblems) break block15;
                        throw new HibernateException("Unable to resume previously suspended transaction", t);
                    }
                }
            }
        }
        catch (SystemException e) {
            throw new HibernateException("Unable to suspend current JTA transaction", e);
        }
    }

    private <T> T doTheWorkInNewTransaction(WorkExecutorVisitable<T> work, TransactionManager transactionManager) {
        try {
            transactionManager.begin();
            try {
                T result = this.doTheWork(work);
                transactionManager.commit();
                return result;
            }
            catch (Exception e) {
                try {
                    transactionManager.rollback();
                }
                catch (Exception ignore) {
                    LOG.unableToRollbackIsolatedTransaction(e, ignore);
                }
                throw new HibernateException("Could not apply work", e);
            }
        }
        catch (SystemException e) {
            throw new HibernateException("Unable to start isolated transaction", e);
        }
        catch (NotSupportedException e) {
            throw new HibernateException("Unable to start isolated transaction", e);
        }
    }

    private <T> T doTheWorkInNoTransaction(WorkExecutorVisitable<T> work) {
        return this.doTheWork(work);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T doTheWork(WorkExecutorVisitable<T> work) {
        try {
            Connection connection = this.jdbcConnectionAccess().obtainConnection();
            try {
                Object t = work.accept(new WorkExecutor(), connection);
                return t;
            }
            catch (HibernateException e) {
                throw e;
            }
            catch (Exception e) {
                throw new HibernateException("Unable to perform isolated work", e);
            }
            finally {
                try {
                    this.jdbcConnectionAccess().releaseConnection(connection);
                }
                catch (Throwable ignore) {
                    LOG.unableToReleaseIsolatedConnection(ignore);
                }
            }
        }
        catch (SQLException e) {
            throw this.sqlExceptionHelper().convert(e, "unable to obtain isolated JDBC connection");
        }
    }
}

