/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.startupresolver;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.wso2.carbon.kernel.internal.startupresolver.StartOrderResolverException;
import org.wso2.carbon.kernel.internal.startupresolver.beans.Capability;
import org.wso2.carbon.kernel.internal.startupresolver.beans.CapabilityProviderCapability;
import org.wso2.carbon.kernel.internal.startupresolver.beans.OSGiServiceCapability;
import org.wso2.carbon.kernel.internal.startupresolver.beans.StartupComponent;
import org.wso2.carbon.kernel.startupresolver.CapabilityProvider;
import org.wso2.carbon.kernel.startupresolver.RequiredCapabilityListener;
import org.wso2.carbon.kernel.startupresolver.manifest.ManifestElement;
import org.wso2.carbon.kernel.startupresolver.manifest.ManifestElementParserException;
import org.wso2.carbon.utils.StringUtils;

class StartupOrderResolverUtils {
    static Predicate<ManifestElement> capabilityProviderElementPredicate = manifestElement -> CapabilityProvider.class.getName().equals(StartupOrderResolverUtils.getObjectClassName(manifestElement));
    static Predicate<ManifestElement> requiredCapabilityListenerElementPredicate = manifestElement -> RequiredCapabilityListener.class.getName().equals(StartupOrderResolverUtils.getObjectClassName(manifestElement));

    private StartupOrderResolverUtils() {
        throw new AssertionError((Object)"Instantiating utility class...");
    }

    static Boolean isCarbonComponentHeaderPresent(Bundle bundle) {
        return AccessController.doPrivileged(() -> bundle.getHeaders().get("Carbon-Component") != null);
    }

    static List<ManifestElement> getManifestElements(Bundle bundle) {
        String headerValue = AccessController.doPrivileged(() -> (String)bundle.getHeaders().get("Carbon-Component"));
        try {
            return ManifestElement.parseHeader("Carbon-Component", headerValue, bundle);
        }
        catch (ManifestElementParserException e) {
            String message = "Error occurred while parsing the Carbon-Component header in bundle(" + bundle.getSymbolicName() + ":" + bundle.getVersion() + "). " + "Header value: " + headerValue;
            throw new StartOrderResolverException(message, e);
        }
    }

    static StartupComponent getStartupComponent(ManifestElement manifestElement) {
        String componentName = StringUtils.getNonEmptyStringAfterTrim(manifestElement.getAttribute("componentName")).orElseThrow(() -> new StartOrderResolverException("componentName attribute value is missing in " + manifestElement.getManifestHeaderName() + " header of bundle(" + manifestElement.getBundle().getSymbolicName() + ":" + manifestElement.getBundle().getVersion() + ")"));
        String requiredServices = StringUtils.getNonEmptyStringAfterTrim(manifestElement.getAttribute("requiredService")).orElseThrow(() -> new StartOrderResolverException("requiredService attribute value is missing in " + manifestElement.getManifestHeaderName() + " header of bundle(" + manifestElement.getBundle().getSymbolicName() + ":" + manifestElement.getBundle().getVersion() + ")"));
        String[] requiredServiceArray = requiredServices.split(",");
        List<String> requiredServicesList = Arrays.asList(requiredServiceArray).stream().map(String::trim).collect(Collectors.toList());
        StartupComponent startupComponent = new StartupComponent(componentName, manifestElement.getBundle());
        startupComponent.addRequiredServices(requiredServicesList);
        return startupComponent;
    }

    static CapabilityProviderCapability getCapabilityProviderCapability(ManifestElement manifestElement) {
        String providedCapabilityName = StringUtils.getNonEmptyStringAfterTrim(manifestElement.getAttribute("capabilityName")).orElseThrow(() -> new StartOrderResolverException("capabilityName attribute value is missing in " + manifestElement.getManifestHeaderName() + " header of bundle(" + manifestElement.getBundle().getSymbolicName() + ":" + manifestElement.getBundle().getVersion() + ")"));
        return new CapabilityProviderCapability(StartupOrderResolverUtils.getObjectClassName(manifestElement), Capability.CapabilityType.OSGi_SERVICE, Capability.CapabilityState.EXPECTED, providedCapabilityName, manifestElement.getBundle());
    }

    static List<OSGiServiceCapability> getOSGiServiceCapabilities(ManifestElement manifestElement) {
        int serviceCount = StringUtils.getNonEmptyStringAfterTrim(manifestElement.getAttribute("serviceCount")).map(serviceCountStr -> {
            try {
                return Integer.parseInt(serviceCountStr.trim());
            }
            catch (NumberFormatException e) {
                throw new StartOrderResolverException("Invalid value for serviceCount manifest attribute in bundle(" + manifestElement.getBundle().getSymbolicName() + ":" + manifestElement.getBundle().getVersion() + ")", e);
            }
        }).orElse(1);
        ArrayList<OSGiServiceCapability> osgiServiceCapabilityList = new ArrayList<OSGiServiceCapability>(serviceCount);
        IntStream.range(0, serviceCount).forEach(count -> {
            OSGiServiceCapability osgiServiceCapability = new OSGiServiceCapability(StartupOrderResolverUtils.getObjectClassName(manifestElement), Capability.CapabilityType.OSGi_SERVICE, Capability.CapabilityState.EXPECTED, manifestElement.getBundle(), true);
            StringUtils.getNonEmptyStringAfterTrim(manifestElement.getAttribute("requiredByComponentName")).ifPresent(requiredByComponentNameStr -> {
                osgiServiceCapability.setDirectDependency(false);
                StartupOrderResolverUtils.addRequiredByComponentNames(osgiServiceCapability, requiredByComponentNameStr);
            });
            StringUtils.getNonEmptyStringAfterTrim(manifestElement.getAttribute("dependentComponentName")).ifPresent(requiredByComponentNameStr -> {
                osgiServiceCapability.setDirectDependency(false);
                StartupOrderResolverUtils.addRequiredByComponentNames(osgiServiceCapability, requiredByComponentNameStr);
            });
            osgiServiceCapabilityList.add(osgiServiceCapability);
        });
        return osgiServiceCapabilityList;
    }

    static void logPendingComponentDetails(Logger logger2, List<StartupComponent> pendingComponents) {
        pendingComponents.forEach(startupComponent -> {
            List<Capability> pendingCapabilities = startupComponent.getPendingCapabilities();
            pendingCapabilities.forEach(provideCapability -> StartupOrderResolverUtils.logPendingCapabilityDetails(logger2, startupComponent, provideCapability));
        });
    }

    static void logPendingRequiredCapabilityListenerServiceDetails(Logger logger2, List<StartupComponent> componentsWithPendingListeners) {
        componentsWithPendingListeners.forEach(startupComponent -> logger2.warn("Waiting for a RequiredCapabilityListener OSGi Service from bundle({}:{}) with componentName: {}", startupComponent.getBundle().getSymbolicName(), startupComponent.getBundle().getVersion(), startupComponent.getName()));
    }

    static void logPendingCapabilityProviderServiceDetails(Logger logger2, List<CapabilityProviderCapability> pendingCapabilityProviderList) {
        pendingCapabilityProviderList.forEach(capabilityProvider -> {
            if (capabilityProvider.getState() == Capability.CapabilityState.EXPECTED) {
                logger2.warn("Waiting for a CapabilityProvider OSGi service to be registered from bundle({}:{}) with providedCapabilityName: {}. Refer the Startup Order Resolver documentation for more information.", capabilityProvider.getBundle().getSymbolicName(), capabilityProvider.getBundle().getVersion(), capabilityProvider.getProvidedCapabilityName());
            } else {
                logger2.warn("Looks like you've registered a CapabilityProvider OSGi service from bundle({}:{}) with the providedCapabilityName: {}, but you haven't declared it in the pom.xml using Carbon-Component manifest header. Refer the Startup Order Resolver documentation for more information.", capabilityProvider.getBundle().getSymbolicName(), capabilityProvider.getBundle().getVersion(), capabilityProvider.getProvidedCapabilityName());
            }
        });
    }

    private static void logPendingCapabilityDetails(Logger logger2, StartupComponent startupComponent, Capability provideCapability) {
        if (provideCapability.getState() == Capability.CapabilityState.EXPECTED) {
            logger2.warn("Startup component {} from bundle({}:{}) is in the pending state until Capability {} from bundle({}:{}) is available as an OSGi service. Refer the Startup Order Resolver documentation for information.", startupComponent.getName(), startupComponent.getBundle().getSymbolicName(), startupComponent.getBundle().getVersion(), provideCapability.getName(), provideCapability.getBundle().getSymbolicName(), provideCapability.getBundle().getVersion());
        } else {
            logger2.warn("Startup component {} from bundle({}:{}) is in the pending state, because of the Capability {} from bundle({}:{}). If you've registered this capability as an OSGi service, you need to declare it using the Carbon-Component manifest header. Refer the Startup Order Resolver documentation for information.", startupComponent.getName(), startupComponent.getBundle().getSymbolicName(), startupComponent.getBundle().getVersion(), provideCapability.getName(), provideCapability.getBundle().getSymbolicName(), provideCapability.getBundle().getVersion());
        }
    }

    private static String getObjectClassName(ManifestElement manifestElement) {
        return StringUtils.getNonEmptyStringAfterTrim(manifestElement.getAttribute("objectClass")).orElseThrow(() -> new StartOrderResolverException("objectClass cannot be empty. Bundle-SymbolicName: " + manifestElement.getBundle().getSymbolicName()));
    }

    private static void addRequiredByComponentNames(OSGiServiceCapability osgiServiceCapability, String requiredByComponentNameStr) {
        Arrays.asList(requiredByComponentNameStr.split(",")).stream().map(String::trim).filter(componentName -> componentName != null && componentName.length() > 0).forEach(osgiServiceCapability::setRequiredByComponentName);
    }
}

