/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.example.resource;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.wso2.msf4j.example.dao.UserRepository;
import org.wso2.msf4j.example.model.User;

@Path(value="/users")
public class UserResource {
    private UserRepository users;

    public UserResource(UserRepository users) {
        this.users = users;
    }

    @POST
    @Path(value="/fname/{fname}/lname/{lname}")
    public Response addUser(@PathParam(value="fname") String fname, @PathParam(value="lname") String lname) {
        User user = new User(fname, lname);
        this.users.createUser(user);
        return Response.accepted().build();
    }

    @GET
    @Path(value="/{id}")
    public Response getUser(@PathParam(value="id") long id) {
        User user = this.users.findUser(id);
        if (user != null) {
            return Response.status(Response.Status.ACCEPTED).entity(user).build();
        }
        return Response.status(Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/")
    public Response getUsers() {
        return Response.status(Response.Status.ACCEPTED).entity(this.users.findUsers()).build();
    }
}

