/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contract.websocket;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WsClientConnectorConfig {
    private final String remoteAddress;
    private List<String> subProtocols;
    private int idleTimeoutInSeconds;
    private boolean autoRead;
    private final Map<String, String> headers = new HashMap<String, String>();

    public WsClientConnectorConfig(String remoteAddress) {
        this.remoteAddress = remoteAddress;
        this.idleTimeoutInSeconds = -1;
        this.autoRead = true;
    }

    public WsClientConnectorConfig(String remoteAddress, List<String> subProtocols, int idleTimeoutInSeconds, boolean autoRead) {
        this.remoteAddress = remoteAddress;
        this.subProtocols = subProtocols;
        this.idleTimeoutInSeconds = idleTimeoutInSeconds;
        this.autoRead = autoRead;
    }

    public String getSubProtocolsAsCSV() {
        if (this.subProtocols == null) {
            return null;
        }
        String subProtocolsAsCSV = "";
        for (String subProtocol : this.subProtocols) {
            subProtocolsAsCSV = subProtocolsAsCSV.concat(subProtocol + ",");
        }
        subProtocolsAsCSV = subProtocolsAsCSV.substring(0, subProtocolsAsCSV.length() - 1);
        return subProtocolsAsCSV;
    }

    public void setSubProtocols(String[] subProtocols) {
        if (subProtocols == null || subProtocols.length == 0) {
            this.subProtocols = null;
            return;
        }
        this.subProtocols = Arrays.asList(subProtocols);
    }

    public void setSubProtocols(List<String> subProtocols) {
        if (subProtocols == null || subProtocols.size() == 0) {
            this.subProtocols = null;
            return;
        }
        this.subProtocols = subProtocols;
    }

    public boolean isAutoRead() {
        return this.autoRead;
    }

    public void setAutoRead(boolean autoRead) {
        this.autoRead = autoRead;
    }

    public List<String> getSubProtocols() {
        return this.subProtocols;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void addHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public boolean containsHeader(String key) {
        return this.headers.containsKey(key);
    }

    public int getIdleTimeoutInMillis() {
        return this.idleTimeoutInSeconds;
    }

    public void setIdleTimeoutInMillis(int idleTimeoutInSeconds) {
        this.idleTimeoutInSeconds = idleTimeoutInSeconds;
    }
}

