/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messaging;

import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(BufferFactory.class);
    private static BufferFactory preConfiguredBufferFactory;
    private static BufferFactory defaultBufferFactory;
    private Queue<ByteBuffer> byteBufferQueue = new ConcurrentLinkedQueue<ByteBuffer>();
    private int bufferSize = 8192;

    public BufferFactory(int bufferSize) {
        LOGGER.debug("Creating BufferFactory with BufferSize " + bufferSize);
        this.bufferSize = bufferSize;
    }

    private BufferFactory() {
        LOGGER.debug("Creating BufferFactory with default BufferSize " + this.bufferSize);
    }

    public ByteBuffer getBuffer() {
        ByteBuffer byteBuffer = null;
        byteBuffer = this.byteBufferQueue.isEmpty() ? ByteBuffer.allocate(this.bufferSize) : this.byteBufferQueue.poll();
        return byteBuffer;
    }

    public void release(ByteBuffer buffer) {
        buffer.clear();
        this.byteBufferQueue.add(buffer);
    }

    public static synchronized BufferFactory createInstance(int bufferSize) {
        preConfiguredBufferFactory = new BufferFactory(bufferSize);
        return preConfiguredBufferFactory;
    }

    public static BufferFactory getInstance() {
        if (preConfiguredBufferFactory == null) {
            return defaultBufferFactory;
        }
        return preConfiguredBufferFactory;
    }

    static {
        defaultBufferFactory = new BufferFactory();
    }
}

