/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.util;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import io.swagger.converter.ModelConverters;
import io.swagger.models.Model;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.PropertyBuilder;
import io.swagger.util.AllowableValues;
import io.swagger.util.AllowableValuesUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterProcessor {
    static Logger LOGGER = LoggerFactory.getLogger(ParameterProcessor.class);

    public static Parameter applyAnnotations(Swagger swagger, Parameter parameter, Type type, List<Annotation> annotations) {
        AnnotationsHelper helper = new AnnotationsHelper(annotations);
        if (helper.isContext()) {
            return null;
        }
        ParamWrapper<?> param = helper.getApiParam();
        if (param.isHidden()) {
            return null;
        }
        String defaultValue = helper.getDefaultValue();
        if (parameter instanceof AbstractSerializableParameter) {
            AbstractSerializableParameter p = (AbstractSerializableParameter)parameter;
            if (param.isRequired()) {
                p.setRequired(true);
            }
            if (StringUtils.isNotEmpty(param.getName())) {
                p.setName(param.getName());
            }
            if (StringUtils.isNotEmpty(param.getDescription())) {
                p.setDescription(param.getDescription());
            }
            if (StringUtils.isNotEmpty(param.getExample())) {
                p.setExample(param.getExample());
            }
            if (StringUtils.isNotEmpty(param.getAccess())) {
                p.setAccess(param.getAccess());
            }
            if (StringUtils.isNotEmpty(param.getDataType())) {
                if ("java.io.File".equalsIgnoreCase(param.getDataType())) {
                    p.setProperty(new FileProperty());
                } else {
                    p.setType(param.getDataType());
                }
            }
            if (helper.getMinItems() != null) {
                p.setMinItems(helper.getMinItems());
            }
            if (helper.getMaxItems() != null) {
                p.setMaxItems(helper.getMaxItems());
            }
            if (helper.isRequired() != null) {
                p.setRequired(true);
            }
            AllowableValues allowableValues = AllowableValuesUtils.create(param.getAllowableValues());
            if (p.getItems() != null || param.isAllowMultiple()) {
                EnumMap<PropertyBuilder.PropertyId, Object> args;
                if (p.getItems() == null) {
                    args = new EnumMap<PropertyBuilder.PropertyId, Object>(PropertyBuilder.PropertyId.class);
                    args.put(PropertyBuilder.PropertyId.DEFAULT, p.getDefaultValue());
                    p.setDefaultValue(null);
                    args.put(PropertyBuilder.PropertyId.ENUM, p.getEnum());
                    p.setEnum(null);
                    args.put(PropertyBuilder.PropertyId.MINIMUM, (Object)p.getMinimum());
                    p.setMinimum(null);
                    args.put(PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM, (Object)p.isExclusiveMinimum());
                    p.setExclusiveMinimum(null);
                    args.put(PropertyBuilder.PropertyId.MAXIMUM, (Object)p.getMaximum());
                    p.setMaximum(null);
                    args.put(PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM, (Object)p.isExclusiveMaximum());
                    args.put(PropertyBuilder.PropertyId.EXAMPLE, p.getExample());
                    p.setExclusiveMaximum(null);
                    Property items = PropertyBuilder.build(p.getType(), p.getFormat(), args);
                    ((AbstractSerializableParameter)((AbstractSerializableParameter)p.type("array")).format(null)).items(items);
                }
                args = new EnumMap(PropertyBuilder.PropertyId.class);
                if (StringUtils.isNotEmpty(defaultValue)) {
                    args.put(PropertyBuilder.PropertyId.DEFAULT, defaultValue);
                }
                if (allowableValues != null) {
                    args.putAll(allowableValues.asPropertyArguments());
                } else {
                    if (helper.getMin() != null) {
                        args.put(PropertyBuilder.PropertyId.MINIMUM, helper.getMin());
                    }
                    if (helper.getMax() != null) {
                        args.put(PropertyBuilder.PropertyId.MAXIMUM, (Object)helper.getMax());
                    }
                }
                PropertyBuilder.merge(p.getItems(), args);
            } else {
                if (StringUtils.isNotEmpty(defaultValue)) {
                    p.setDefaultValue(defaultValue);
                }
                if (allowableValues != null) {
                    ParameterProcessor.processAllowedValues(allowableValues, p);
                } else {
                    ParameterProcessor.processJsr303Annotations(helper, p);
                }
            }
        } else {
            Property property;
            BodyParameter bp = new BodyParameter();
            if (helper.getApiParam() != null) {
                String value;
                String mediaType;
                Example example;
                ParamWrapper<ApiParam> apiParam;
                ParamWrapper<?> pw = helper.getApiParam();
                if (pw instanceof ApiParamWrapper) {
                    apiParam = (ApiParamWrapper)pw;
                    example = ((ApiParamWrapper)apiParam).getExamples();
                    if (example != null && example.value() != null) {
                        for (ExampleProperty ex : example.value()) {
                            mediaType = ex.mediaType();
                            value = ex.value();
                            if (mediaType.isEmpty() || value.isEmpty()) continue;
                            bp.example(mediaType.trim(), value.trim());
                        }
                    }
                } else if (pw instanceof ApiImplicitParamWrapper && (example = ((ApiImplicitParamWrapper)(apiParam = (ApiImplicitParamWrapper)pw)).getExamples()) != null && example.value() != null) {
                    for (ExampleProperty ex : example.value()) {
                        mediaType = ex.mediaType();
                        value = ex.value();
                        if (mediaType.isEmpty() || value.isEmpty()) continue;
                        bp.example(mediaType.trim(), value.trim());
                    }
                }
            }
            bp.setRequired(param.isRequired());
            bp.setName(StringUtils.isNotEmpty(param.getName()) ? param.getName() : "body");
            if (StringUtils.isNotEmpty(param.getDescription())) {
                bp.setDescription(param.getDescription());
            }
            if (StringUtils.isNotEmpty(param.getAccess())) {
                bp.setAccess(param.getAccess());
            }
            if ((property = ModelConverters.getInstance().readAsProperty(type)) != null) {
                EnumMap<PropertyBuilder.PropertyId, Object> args = new EnumMap<PropertyBuilder.PropertyId, Object>(PropertyBuilder.PropertyId.class);
                if (StringUtils.isNotEmpty(defaultValue)) {
                    args.put(PropertyBuilder.PropertyId.DEFAULT, defaultValue);
                }
                bp.setSchema(PropertyBuilder.toModel(PropertyBuilder.merge(property, args)));
                for (Map.Entry<String, Model> entry : ModelConverters.getInstance().readAll(type).entrySet()) {
                    swagger.addDefinition(entry.getKey(), entry.getValue());
                }
            }
            parameter = bp;
        }
        return parameter;
    }

    private static void processAllowedValues(AllowableValues allowableValues, AbstractSerializableParameter<?> p) {
        if (allowableValues == null) {
            return;
        }
        Map<PropertyBuilder.PropertyId, Object> args = allowableValues.asPropertyArguments();
        if (args.containsKey((Object)PropertyBuilder.PropertyId.ENUM)) {
            p.setEnum((List)args.get((Object)PropertyBuilder.PropertyId.ENUM));
        } else {
            if (args.containsKey((Object)PropertyBuilder.PropertyId.MINIMUM)) {
                p.setMinimum((Double)args.get((Object)PropertyBuilder.PropertyId.MINIMUM));
            }
            if (args.containsKey((Object)PropertyBuilder.PropertyId.MAXIMUM)) {
                p.setMaximum((Double)args.get((Object)PropertyBuilder.PropertyId.MAXIMUM));
            }
            if (args.containsKey((Object)PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM)) {
                p.setExclusiveMinimum((Boolean)args.get((Object)PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM) != false ? Boolean.valueOf(true) : null);
            }
            if (args.containsKey((Object)PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM)) {
                p.setExclusiveMaximum((Boolean)args.get((Object)PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM) != false ? Boolean.valueOf(true) : null);
            }
        }
    }

    private static void processJsr303Annotations(AnnotationsHelper helper, AbstractSerializableParameter<?> p) {
        if (helper == null) {
            return;
        }
        if (helper.getMin() != null) {
            p.setMinimum(helper.getMin().doubleValue());
        }
        if (helper.getMax() != null) {
            p.setMaximum(helper.getMax().doubleValue());
        }
    }

    private static final class ApiImplicitParamWrapper
    implements ParamWrapper<ApiImplicitParam> {
        private final ApiImplicitParam apiParam;

        private ApiImplicitParamWrapper(ApiImplicitParam apiParam) {
            this.apiParam = apiParam;
        }

        @Override
        public String getName() {
            return this.apiParam.name();
        }

        @Override
        public String getDescription() {
            return this.apiParam.value();
        }

        @Override
        public String getDefaultValue() {
            return this.apiParam.defaultValue();
        }

        @Override
        public String getAllowableValues() {
            return this.apiParam.allowableValues();
        }

        @Override
        public boolean isRequired() {
            return this.apiParam.required();
        }

        @Override
        public String getAccess() {
            return this.apiParam.access();
        }

        @Override
        public boolean isAllowMultiple() {
            return this.apiParam.allowMultiple();
        }

        @Override
        public String getDataType() {
            return this.apiParam.dataType();
        }

        @Override
        public String getParamType() {
            return this.apiParam.paramType();
        }

        @Override
        public ApiImplicitParam getAnnotation() {
            return this.apiParam;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public String getExample() {
            return this.apiParam.example();
        }

        public Example getExamples() {
            return this.apiParam.examples();
        }
    }

    private static final class ApiParamWrapper
    implements ParamWrapper<ApiParam> {
        private final ApiParam apiParam;

        private ApiParamWrapper(ApiParam apiParam) {
            this.apiParam = apiParam;
        }

        @Override
        public String getName() {
            return this.apiParam.name();
        }

        @Override
        public String getDescription() {
            return this.apiParam.value();
        }

        @Override
        public String getDefaultValue() {
            return this.apiParam.defaultValue();
        }

        @Override
        public String getAllowableValues() {
            return this.apiParam.allowableValues();
        }

        @Override
        public boolean isRequired() {
            return this.apiParam.required();
        }

        @Override
        public String getAccess() {
            return this.apiParam.access();
        }

        @Override
        public boolean isAllowMultiple() {
            return this.apiParam.allowMultiple();
        }

        @Override
        public String getDataType() {
            return null;
        }

        @Override
        public String getParamType() {
            return null;
        }

        @Override
        public ApiParam getAnnotation() {
            return this.apiParam;
        }

        @Override
        public boolean isHidden() {
            return this.apiParam.hidden();
        }

        @Override
        public String getExample() {
            return this.apiParam.example();
        }

        public Example getExamples() {
            return this.apiParam.examples();
        }
    }

    private static class AnnotationsHelper {
        private static final ApiParam DEFAULT_API_PARAM = AnnotationsHelper.getDefaultApiParam(null);
        private boolean context;
        private ParamWrapper<?> apiParam = new ApiParamWrapper(DEFAULT_API_PARAM);
        private String defaultValue;
        private Integer minItems;
        private Integer maxItems;
        private Boolean required;
        private Long min;
        private Long max;

        public AnnotationsHelper(List<Annotation> annotations) {
            String rsDefault = null;
            for (Annotation item : annotations) {
                if ("javax.ws.rs.core.Context".equals(item.annotationType().getName())) {
                    this.context = true;
                    continue;
                }
                if (item instanceof ApiParam) {
                    this.apiParam = new ApiParamWrapper((ApiParam)item);
                    continue;
                }
                if (item instanceof ApiImplicitParam) {
                    this.apiParam = new ApiImplicitParamWrapper((ApiImplicitParam)item);
                    continue;
                }
                if ("javax.ws.rs.DefaultValue".equals(item.annotationType().getName())) {
                    try {
                        rsDefault = (String)item.getClass().getMethod("value", new Class[0]).invoke((Object)item, new Object[0]);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Invocation of value method failed", ex);
                    }
                    continue;
                }
                if (item instanceof Size) {
                    Size size = (Size)item;
                    this.minItems = size.min();
                    this.maxItems = size.max();
                    continue;
                }
                if (item instanceof NotNull) {
                    this.required = true;
                    continue;
                }
                if (item instanceof Min) {
                    this.min = ((Min)item).value();
                    continue;
                }
                if (!(item instanceof Max)) continue;
                this.max = ((Max)item).value();
            }
            this.defaultValue = StringUtils.isNotEmpty(this.apiParam.getDefaultValue()) ? this.apiParam.getDefaultValue() : rsDefault;
        }

        private static ApiParam getDefaultApiParam(@ApiParam String annotationHolder) {
            for (Method method : AnnotationsHelper.class.getDeclaredMethods()) {
                if (!"getDefaultApiParam".equals(method.getName())) continue;
                return (ApiParam)method.getParameterAnnotations()[0][0];
            }
            throw new IllegalStateException("Failed to locate default @ApiParam");
        }

        public boolean isContext() {
            return this.context;
        }

        public ParamWrapper<?> getApiParam() {
            return this.apiParam;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public Integer getMinItems() {
            return this.minItems;
        }

        public Integer getMaxItems() {
            return this.maxItems;
        }

        public Boolean isRequired() {
            return this.required;
        }

        public Long getMax() {
            return this.max;
        }

        public Long getMin() {
            return this.min;
        }
    }

    public static interface ParamWrapper<T extends Annotation> {
        public String getName();

        public String getDescription();

        public String getDefaultValue();

        public String getAllowableValues();

        public boolean isRequired();

        public String getAccess();

        public boolean isAllowMultiple();

        public String getDataType();

        public String getParamType();

        public T getAnnotation();

        public boolean isHidden();

        public String getExample();
    }
}

