/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.endpoint;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.agent.conf.DataEndpointConfiguration;
import org.wso2.carbon.databridge.agent.endpoint.DataEndpoint;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAuthenticationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointException;

public class DataEndpointConnectionWorker
implements Runnable {
    private static Log log = LogFactory.getLog(DataEndpointConnectionWorker.class);
    private DataEndpointConfiguration dataEndpointConfiguration;
    private DataEndpoint dataEndpoint;

    @Override
    public void run() {
        if (this.isInitialized()) {
            try {
                this.connect();
                this.dataEndpoint.activate();
            }
            catch (DataEndpointAuthenticationException e) {
                log.error("Error while trying to connect to the endpoint. " + e.getErrorMessage(), e);
                this.dataEndpoint.deactivate();
            }
        } else {
            String errorMsg = "Data endpoint connection worker is not properly initialized ";
            if (this.dataEndpoint == null) {
                errorMsg = errorMsg + ", data Endpoint is not provided ";
            }
            if (this.dataEndpointConfiguration == null) {
                errorMsg = errorMsg + ", data Endpoint configuration is not provided";
            }
            errorMsg = errorMsg + ".";
            log.error(errorMsg);
        }
    }

    DataEndpointConfiguration getDataEndpointConfiguration() {
        return this.dataEndpointConfiguration;
    }

    public void initialize(DataEndpoint dataEndpoint, DataEndpointConfiguration dataEndpointConfiguration) throws DataEndpointException {
        if (this.dataEndpointConfiguration != null) {
            throw new DataEndpointException("Already data endpoint configuration is set: " + this.dataEndpointConfiguration.toString() + " for the endpoint " + dataEndpointConfiguration.toString());
        }
        this.dataEndpointConfiguration = dataEndpointConfiguration;
        if (this.dataEndpoint != null) {
            throw new DataEndpointException("Already data endpoint is configured for the connection worker");
        }
        this.dataEndpoint = dataEndpoint;
    }

    private void connect() throws DataEndpointAuthenticationException {
        Object client = null;
        try {
            client = this.dataEndpointConfiguration.getSecuredTransportPool().borrowObject(this.dataEndpointConfiguration.getAuthKey());
            String sessionId = this.dataEndpoint.login(client, this.dataEndpointConfiguration.getUsername(), this.dataEndpointConfiguration.getPassword());
            this.dataEndpointConfiguration.setSessionId(sessionId);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            throw new DataEndpointAuthenticationException("Cannot borrow client for " + this.dataEndpointConfiguration.getAuthURL(), e);
        }
        finally {
            try {
                this.dataEndpointConfiguration.getSecuredTransportPool().returnObject(this.dataEndpointConfiguration.getAuthKey(), client);
            }
            catch (Exception e) {
                this.dataEndpointConfiguration.getSecuredTransportPool().clear(this.dataEndpointConfiguration.getAuthKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(DataEndpointConfiguration dataPublisherConfiguration) {
        Object client = null;
        try {
            client = this.dataEndpointConfiguration.getSecuredTransportPool().borrowObject(dataPublisherConfiguration.getAuthKey());
            this.dataEndpoint.logout(client, dataPublisherConfiguration.getSessionId());
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Cannot connect to the server at " + dataPublisherConfiguration.getAuthKey() + " Authenticator", e);
            }
            log.warn("Cannot connect to the server at " + dataPublisherConfiguration.getAuthKey() + " Authenticator");
        }
        finally {
            try {
                this.dataEndpointConfiguration.getSecuredTransportPool().returnObject(dataPublisherConfiguration.getAuthKey(), client);
            }
            catch (Exception e) {
                this.dataEndpointConfiguration.getSecuredTransportPool().clear(dataPublisherConfiguration.getAuthKey());
            }
        }
    }

    private boolean isInitialized() {
        return this.dataEndpoint != null && this.dataEndpointConfiguration != null;
    }
}

