/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.internal;

import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.messaging.TransportListenerManager;
import org.wso2.carbon.messaging.handler.HandlerExecutor;
import org.wso2.carbon.transport.http.netty.config.ListenerConfiguration;

public class NettyTransportContextHolder {
    private static final Logger log = LoggerFactory.getLogger(NettyTransportContextHolder.class);
    private static NettyTransportContextHolder instance = new NettyTransportContextHolder();
    private BundleContext bundleContext;
    private CarbonMessageProcessor messageProcessor;
    private HandlerExecutor handlerExecutor;
    private Map<String, ListenerConfiguration> listenerConfigurations = new HashMap<String, ListenerConfiguration>();
    private TransportListenerManager manager;

    public ListenerConfiguration getListenerConfiguration(String id) {
        return this.listenerConfigurations.get(id);
    }

    public void setListenerConfiguration(String id, ListenerConfiguration config) {
        this.listenerConfigurations.put(id, config);
    }

    private NettyTransportContextHolder() {
    }

    public static NettyTransportContextHolder getInstance() {
        return instance;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public CarbonMessageProcessor getMessageProcessor() {
        return this.messageProcessor;
    }

    public void addMessageProcessor(CarbonMessageProcessor carbonMessageProcessor) {
        this.messageProcessor = carbonMessageProcessor;
    }

    public void removeMessageProcessor(CarbonMessageProcessor carbonMessageProcessor) {
        if (carbonMessageProcessor.getId().equals(this.messageProcessor.getId())) {
            this.messageProcessor = null;
        }
    }

    public TransportListenerManager getManager() {
        return this.manager;
    }

    public void removeManager() {
        this.manager = null;
    }

    public void setManager(TransportListenerManager manager) {
        this.manager = manager;
    }

    public void setHandlerExecutor(HandlerExecutor handlerExecutor) {
        this.handlerExecutor = handlerExecutor;
    }

    public HandlerExecutor getHandlerExecutor() {
        return this.handlerExecutor;
    }
}

