/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonMessage;

public class NettyCarbonMessage
extends CarbonMessage {
    private static final Logger LOG = LoggerFactory.getLogger(NettyCarbonMessage.class);
    private BlockingQueue<HttpContent> httpContentQueue = new LinkedBlockingQueue<HttpContent>();
    private BlockingQueue<HttpContent> outContentQueue = new LinkedBlockingQueue<HttpContent>();
    private BlockingQueue<HttpContent> garbageCollected = new LinkedBlockingQueue<HttpContent>();

    public void addHttpContent(HttpContent httpContent) {
        try {
            this.httpContentQueue.put(httpContent);
        }
        catch (InterruptedException e) {
            LOG.error("Cannot put content to queue", e);
        }
    }

    public HttpContent getHttpContent() {
        try {
            return this.httpContentQueue.take();
        }
        catch (InterruptedException e) {
            LOG.error("Error while retrieving http content from queue.", e);
            return null;
        }
    }

    @Override
    public ByteBuffer getMessageBody() {
        try {
            HttpContent httpContent = this.httpContentQueue.take();
            if (httpContent instanceof LastHttpContent) {
                super.setEndOfMsgAdded(true);
            }
            ByteBuf buf = httpContent.content();
            this.garbageCollected.add(httpContent);
            return buf.nioBuffer();
        }
        catch (InterruptedException e) {
            LOG.error("Error while retrieving message body from queue.", e);
            return null;
        }
    }

    @Override
    public List<ByteBuffer> getFullMessageBody() {
        ArrayList<ByteBuffer> byteBufferList = new ArrayList<ByteBuffer>();
        boolean isEndOfMessageProcessed = false;
        while (!isEndOfMessageProcessed) {
            try {
                HttpContent httpContent = this.httpContentQueue.take();
                if (httpContent instanceof LastHttpContent) {
                    isEndOfMessageProcessed = true;
                }
                ByteBuf buf = httpContent.content();
                this.garbageCollected.add(httpContent);
                byteBufferList.add(buf.nioBuffer());
            }
            catch (InterruptedException e) {
                LOG.error("Error while getting full message body", e);
            }
        }
        return byteBufferList;
    }

    @Override
    public boolean isEmpty() {
        return this.httpContentQueue.isEmpty();
    }

    @Override
    public int getFullMessageLength() {
        ArrayList<HttpContent> contentList = new ArrayList<HttpContent>();
        boolean isEndOfMessageProcessed = false;
        while (!isEndOfMessageProcessed) {
            try {
                HttpContent httpContent = this.httpContentQueue.take();
                if (httpContent instanceof LastHttpContent) {
                    isEndOfMessageProcessed = true;
                }
                contentList.add(httpContent);
            }
            catch (InterruptedException e) {
                LOG.error("Error while getting full message length", e);
            }
        }
        int size = 0;
        for (HttpContent httpContent : contentList) {
            size += httpContent.content().readableBytes();
            this.httpContentQueue.add(httpContent);
        }
        return size;
    }

    @Override
    public boolean isEndOfMsgAdded() {
        return super.isEndOfMsgAdded();
    }

    @Override
    public void addMessageBody(ByteBuffer msgBody) {
        if (this.isAlreadyRead()) {
            this.outContentQueue.add(new DefaultHttpContent(Unpooled.copiedBuffer(msgBody)));
        } else if (this.httpContentQueue.isEmpty()) {
            this.httpContentQueue.add(new DefaultHttpContent(Unpooled.copiedBuffer(msgBody)));
        } else {
            LOG.error("Please don't add message body before reading existing values");
        }
    }

    @Override
    public void setEndOfMsgAdded(boolean endOfMsgAdded) {
        super.setEndOfMsgAdded(endOfMsgAdded);
        if (this.isAlreadyRead()) {
            this.outContentQueue.forEach(buffer -> this.httpContentQueue.add((HttpContent)buffer));
            this.outContentQueue.clear();
        }
    }

    @Override
    public void release() {
        this.httpContentQueue.forEach(content -> content.release());
        this.garbageCollected.forEach(content -> content.release());
    }
}

