/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.analytics.metrics;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.core.MetricManagementService;
import org.wso2.carbon.metrics.core.MetricService;

public final class Metrics {
    private static final Logger logger = LoggerFactory.getLogger(Metrics.class);
    private volatile MetricService metricService;
    private volatile MetricManagementService metricManagementService;

    private Metrics() {
    }

    public static Metrics getInstance() {
        return MetricsHolder.INSTANCE;
    }

    private void initializeServices() {
        if (logger.isInfoEnabled()) {
            logger.info("Initializing Metrics Services");
        }
        org.wso2.carbon.metrics.core.Metrics metrics = new org.wso2.carbon.metrics.core.Metrics();
        metrics.activate();
        this.metricService = metrics.getMetricService();
        this.metricManagementService = metrics.getMetricManagementService();
        Thread thread = new Thread(() -> metrics.deactivate());
        Runtime.getRuntime().addShutdownHook(thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricService getMetricService() {
        if (this.metricService == null) {
            Metrics metrics = this;
            synchronized (metrics) {
                if (this.metricService == null) {
                    this.initializeServices();
                }
            }
        }
        return this.metricService;
    }

    void setMetricService(MetricService metricService) {
        this.metricService = metricService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricManagementService getMetricManagementService() {
        if (this.metricManagementService == null) {
            Metrics metrics = this;
            synchronized (metrics) {
                if (this.metricManagementService == null) {
                    this.initializeServices();
                }
            }
        }
        return this.metricManagementService;
    }

    void setMetricManagementService(MetricManagementService metricManagementService) {
        this.metricManagementService = metricManagementService;
    }

    private static class MetricsHolder {
        private static final Metrics INSTANCE = new Metrics();

        private MetricsHolder() {
        }
    }
}

